/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.hoglin;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.phys.Vec3D;

public interface IOglin {
    public static final int ATTACK_ANIMATION_DURATION = 10;

    public int getAttackAnimationRemainingTicks();

    public static boolean hurtAndThrowTarget(EntityLiving var0, EntityLiving var1) {
        float var3 = (float)var0.getAttributeValue(GenericAttributes.ATTACK_DAMAGE);
        float var2 = !var0.isBaby() && (int)var3 > 0 ? var3 / 2.0f + (float)var0.level.random.nextInt((int)var3) : var3;
        boolean var4 = var1.hurt(DamageSource.mobAttack(var0), var2);
        if (var4) {
            var0.doEnchantDamageEffects(var0, var1);
            if (!var0.isBaby()) {
                IOglin.throwTarget(var0, var1);
            }
        }
        return var4;
    }

    public static void throwTarget(EntityLiving var0, EntityLiving var1) {
        double var4;
        double var2 = var0.getAttributeValue(GenericAttributes.ATTACK_KNOCKBACK);
        double var6 = var2 - (var4 = var1.getAttributeValue(GenericAttributes.KNOCKBACK_RESISTANCE));
        if (var6 <= 0.0) {
            return;
        }
        double var8 = var1.getX() - var0.getX();
        double var10 = var1.getZ() - var0.getZ();
        float var12 = var0.level.random.nextInt(21) - 10;
        double var13 = var6 * (double)(var0.level.random.nextFloat() * 0.5f + 0.2f);
        Vec3D var15 = new Vec3D(var8, 0.0, var10).normalize().scale(var13).yRot(var12);
        double var16 = var6 * (double)var0.level.random.nextFloat() * 0.5;
        var1.push(var15.x, var16, var15.z);
        var1.hurtMarked = true;
    }
}

