/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.phys.Vec3D;

public class EntityVex
extends EntityMonster {
    public static final float FLAP_DEGREES_PER_TICK = 45.836624f;
    public static final int TICKS_PER_FLAP = MathHelper.ceil(3.9269907f);
    protected static final DataWatcherObject<Byte> DATA_FLAGS_ID = DataWatcher.defineId(EntityVex.class, DataWatcherRegistry.BYTE);
    private static final int FLAG_IS_CHARGING = 1;
    @Nullable
    EntityInsentient owner;
    @Nullable
    private BlockPosition boundOrigin;
    public boolean hasLimitedLife;
    public int limitedLifeTicks;

    public EntityVex(EntityTypes<? extends EntityVex> var0, World var1) {
        super((EntityTypes<? extends EntityMonster>)var0, var1);
        this.moveControl = new c(this);
        this.xpReward = 3;
    }

    @Override
    public boolean isFlapping() {
        return this.tickCount % TICKS_PER_FLAP == 0;
    }

    @Override
    public void move(EnumMoveType var0, Vec3D var1) {
        super.move(var0, var1);
        this.checkInsideBlocks();
    }

    @Override
    public void tick() {
        this.noPhysics = true;
        super.tick();
        this.noPhysics = false;
        this.setNoGravity(true);
        if (this.hasLimitedLife && --this.limitedLifeTicks <= 0) {
            this.limitedLifeTicks = 20;
            this.hurt(DamageSource.STARVE, 1.0f);
        }
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(4, new a());
        this.goalSelector.addGoal(8, new d());
        this.goalSelector.addGoal(9, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.targetSelector.addGoal(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, new b(this));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MAX_HEALTH, 14.0).add(GenericAttributes.ATTACK_DAMAGE, 4.0);
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_FLAGS_ID, (byte)0);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        if (var0.contains("BoundX")) {
            this.boundOrigin = new BlockPosition(var0.getInt("BoundX"), var0.getInt("BoundY"), var0.getInt("BoundZ"));
        }
        if (var0.contains("LifeTicks")) {
            this.setLimitedLife(var0.getInt("LifeTicks"));
        }
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        if (this.boundOrigin != null) {
            var0.putInt("BoundX", this.boundOrigin.getX());
            var0.putInt("BoundY", this.boundOrigin.getY());
            var0.putInt("BoundZ", this.boundOrigin.getZ());
        }
        if (this.hasLimitedLife) {
            var0.putInt("LifeTicks", this.limitedLifeTicks);
        }
    }

    @Nullable
    public EntityInsentient getOwner() {
        return this.owner;
    }

    @Nullable
    public BlockPosition getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPosition var0) {
        this.boundOrigin = var0;
    }

    private boolean getVexFlag(int var0) {
        byte var1 = this.entityData.get(DATA_FLAGS_ID);
        return (var1 & var0) != 0;
    }

    private void setVexFlag(int var0, boolean var1) {
        int var2 = this.entityData.get(DATA_FLAGS_ID).byteValue();
        var2 = var1 ? (var2 |= var0) : (var2 &= ~var0);
        this.entityData.set(DATA_FLAGS_ID, (byte)(var2 & 0xFF));
    }

    public boolean isCharging() {
        return this.getVexFlag(1);
    }

    public void setIsCharging(boolean var0) {
        this.setVexFlag(1, var0);
    }

    public void setOwner(EntityInsentient var0) {
        this.owner = var0;
    }

    public void setLimitedLife(int var0) {
        this.hasLimitedLife = true;
        this.limitedLifeTicks = var0;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.VEX_AMBIENT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.VEX_DEATH;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.VEX_HURT;
    }

    @Override
    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        RandomSource var5 = var0.getRandom();
        this.populateDefaultEquipmentSlots(var5, var1);
        this.populateDefaultEquipmentEnchantments(var5, var1);
        return super.finalizeSpawn(var0, var1, var2, var3, var4);
    }

    @Override
    protected void populateDefaultEquipmentSlots(RandomSource var0, DifficultyDamageScaler var1) {
        this.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.IRON_SWORD));
        this.setDropChance(EnumItemSlot.MAINHAND, 0.0f);
    }

    class c
    extends ControllerMove {
        public c(EntityVex var1) {
            super(var1);
        }

        @Override
        public void tick() {
            if (this.operation != ControllerMove.Operation.MOVE_TO) {
                return;
            }
            Vec3D var0 = new Vec3D(this.wantedX - EntityVex.this.getX(), this.wantedY - EntityVex.this.getY(), this.wantedZ - EntityVex.this.getZ());
            double var1 = var0.length();
            if (var1 < EntityVex.this.getBoundingBox().getSize()) {
                this.operation = ControllerMove.Operation.WAIT;
                EntityVex.this.setDeltaMovement(EntityVex.this.getDeltaMovement().scale(0.5));
            } else {
                EntityVex.this.setDeltaMovement(EntityVex.this.getDeltaMovement().add(var0.scale(this.speedModifier * 0.05 / var1)));
                if (EntityVex.this.getTarget() == null) {
                    Vec3D var3 = EntityVex.this.getDeltaMovement();
                    EntityVex.this.setYRot(-((float)MathHelper.atan2(var3.x, var3.z)) * 57.295776f);
                    EntityVex.this.yBodyRot = EntityVex.this.getYRot();
                } else {
                    double var3 = EntityVex.this.getTarget().getX() - EntityVex.this.getX();
                    double var5 = EntityVex.this.getTarget().getZ() - EntityVex.this.getZ();
                    EntityVex.this.setYRot(-((float)MathHelper.atan2(var3, var5)) * 57.295776f);
                    EntityVex.this.yBodyRot = EntityVex.this.getYRot();
                }
            }
        }
    }

    class a
    extends PathfinderGoal {
        public a() {
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canUse() {
            EntityLiving var0 = EntityVex.this.getTarget();
            if (var0 != null && var0.isAlive() && !EntityVex.this.getMoveControl().hasWanted() && EntityVex.this.random.nextInt(net.minecraft.world.entity.monster.EntityVex$a.reducedTickDelay(7)) == 0) {
                return EntityVex.this.distanceToSqr(var0) > 4.0;
            }
            return false;
        }

        @Override
        public boolean canContinueToUse() {
            return EntityVex.this.getMoveControl().hasWanted() && EntityVex.this.isCharging() && EntityVex.this.getTarget() != null && EntityVex.this.getTarget().isAlive();
        }

        @Override
        public void start() {
            EntityLiving var0 = EntityVex.this.getTarget();
            if (var0 != null) {
                Vec3D var1 = var0.getEyePosition();
                EntityVex.this.moveControl.setWantedPosition(var1.x, var1.y, var1.z, 1.0);
            }
            EntityVex.this.setIsCharging(true);
            EntityVex.this.playSound(SoundEffects.VEX_CHARGE, 1.0f, 1.0f);
        }

        @Override
        public void stop() {
            EntityVex.this.setIsCharging(false);
        }

        @Override
        public boolean requiresUpdateEveryTick() {
            return true;
        }

        @Override
        public void tick() {
            EntityLiving var0 = EntityVex.this.getTarget();
            if (var0 == null) {
                return;
            }
            if (EntityVex.this.getBoundingBox().intersects(var0.getBoundingBox())) {
                EntityVex.this.doHurtTarget(var0);
                EntityVex.this.setIsCharging(false);
            } else {
                double var1 = EntityVex.this.distanceToSqr(var0);
                if (var1 < 9.0) {
                    Vec3D var3 = var0.getEyePosition();
                    EntityVex.this.moveControl.setWantedPosition(var3.x, var3.y, var3.z, 1.0);
                }
            }
        }
    }

    class d
    extends PathfinderGoal {
        public d() {
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canUse() {
            return !EntityVex.this.getMoveControl().hasWanted() && EntityVex.this.random.nextInt(d.reducedTickDelay(7)) == 0;
        }

        @Override
        public boolean canContinueToUse() {
            return false;
        }

        @Override
        public void tick() {
            BlockPosition var0 = EntityVex.this.getBoundOrigin();
            if (var0 == null) {
                var0 = EntityVex.this.blockPosition();
            }
            for (int var1 = 0; var1 < 3; ++var1) {
                BlockPosition var2 = var0.offset(EntityVex.this.random.nextInt(15) - 7, EntityVex.this.random.nextInt(11) - 5, EntityVex.this.random.nextInt(15) - 7);
                if (!EntityVex.this.level.isEmptyBlock(var2)) continue;
                EntityVex.this.moveControl.setWantedPosition((double)var2.getX() + 0.5, (double)var2.getY() + 0.5, (double)var2.getZ() + 0.5, 0.25);
                if (EntityVex.this.getTarget() != null) break;
                EntityVex.this.getLookControl().setLookAt((double)var2.getX() + 0.5, (double)var2.getY() + 0.5, (double)var2.getZ() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class b
    extends PathfinderGoalTarget {
        private final PathfinderTargetCondition copyOwnerTargeting;

        public b(EntityCreature var1) {
            super(var1, false);
            this.copyOwnerTargeting = PathfinderTargetCondition.forNonCombat().ignoreLineOfSight().ignoreInvisibilityTesting();
        }

        @Override
        public boolean canUse() {
            return EntityVex.this.owner != null && EntityVex.this.owner.getTarget() != null && this.canAttack(EntityVex.this.owner.getTarget(), this.copyOwnerTargeting);
        }

        @Override
        public void start() {
            EntityVex.this.setTarget(EntityVex.this.owner.getTarget());
            super.start();
        }
    }
}

