/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.wither;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.BossBattle;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;

public class EntityWither
extends EntityMonster
implements PowerableMob,
IRangedEntity {
    private static final DataWatcherObject<Integer> DATA_TARGET_A = DataWatcher.defineId(EntityWither.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Integer> DATA_TARGET_B = DataWatcher.defineId(EntityWither.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Integer> DATA_TARGET_C = DataWatcher.defineId(EntityWither.class, DataWatcherRegistry.INT);
    private static final List<DataWatcherObject<Integer>> DATA_TARGETS = ImmutableList.of(DATA_TARGET_A, DATA_TARGET_B, DATA_TARGET_C);
    private static final DataWatcherObject<Integer> DATA_ID_INV = DataWatcher.defineId(EntityWither.class, DataWatcherRegistry.INT);
    private static final int INVULNERABLE_TICKS = 220;
    private final float[] xRotHeads = new float[2];
    private final float[] yRotHeads = new float[2];
    private final float[] xRotOHeads = new float[2];
    private final float[] yRotOHeads = new float[2];
    private final int[] nextHeadUpdate = new int[2];
    private final int[] idleHeadUpdates = new int[2];
    private int destroyBlocksTick;
    public final BossBattleServer bossEvent = (BossBattleServer)new BossBattleServer(this.getDisplayName(), BossBattle.BarColor.PURPLE, BossBattle.BarStyle.PROGRESS).setDarkenScreen(true);
    private static final Predicate<EntityLiving> LIVING_ENTITY_SELECTOR = var0 -> var0.getMobType() != EnumMonsterType.UNDEAD && var0.attackable();
    private static final PathfinderTargetCondition TARGETING_CONDITIONS = PathfinderTargetCondition.forCombat().range(20.0).selector(LIVING_ENTITY_SELECTOR);

    public EntityWither(EntityTypes<? extends EntityWither> var0, World var1) {
        super((EntityTypes<? extends EntityMonster>)var0, var1);
        this.moveControl = new ControllerMoveFlying(this, 10, false);
        this.setHealth(this.getMaxHealth());
        this.xpReward = 50;
    }

    @Override
    protected NavigationAbstract createNavigation(World var0) {
        NavigationFlying var1 = new NavigationFlying(this, var0);
        var1.setCanOpenDoors(false);
        var1.setCanFloat(true);
        var1.setCanPassDoors(true);
        return var1;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new a());
        this.goalSelector.addGoal(2, new PathfinderGoalArrowAttack(this, 1.0, 40, 20.0f));
        this.goalSelector.addGoal(5, new PathfinderGoalRandomFly(this, 1.0));
        this.goalSelector.addGoal(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.addGoal(7, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.addGoal(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.targetSelector.addGoal(2, new PathfinderGoalNearestAttackableTarget<EntityLiving>(this, EntityLiving.class, 0, false, false, LIVING_ENTITY_SELECTOR));
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_TARGET_A, 0);
        this.entityData.define(DATA_TARGET_B, 0);
        this.entityData.define(DATA_TARGET_C, 0);
        this.entityData.define(DATA_ID_INV, 0);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("Invul", this.getInvulnerableTicks());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.setInvulnerableTicks(var0.getInt("Invul"));
        if (this.hasCustomName()) {
            this.bossEvent.setName(this.getDisplayName());
        }
    }

    @Override
    public void setCustomName(@Nullable IChatBaseComponent var0) {
        super.setCustomName(var0);
        this.bossEvent.setName(this.getDisplayName());
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.WITHER_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.WITHER_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.WITHER_DEATH;
    }

    @Override
    public void aiStep() {
        int var2;
        int var1;
        Entity var12;
        Vec3D var0 = this.getDeltaMovement().multiply(1.0, 0.6, 1.0);
        if (!this.level.isClientSide && this.getAlternativeTarget(0) > 0 && (var12 = this.level.getEntity(this.getAlternativeTarget(0))) != null) {
            double var22 = var0.y;
            if (this.getY() < var12.getY() || !this.isPowered() && this.getY() < var12.getY() + 5.0) {
                var22 = Math.max(0.0, var22);
                var22 += 0.3 - var22 * (double)0.6f;
            }
            var0 = new Vec3D(var0.x, var22, var0.z);
            Vec3D var4 = new Vec3D(var12.getX() - this.getX(), 0.0, var12.getZ() - this.getZ());
            if (var4.horizontalDistanceSqr() > 9.0) {
                Vec3D var5 = var4.normalize();
                var0 = var0.add(var5.x * 0.3 - var0.x * 0.6, 0.0, var5.z * 0.3 - var0.z * 0.6);
            }
        }
        this.setDeltaMovement(var0);
        if (var0.horizontalDistanceSqr() > 0.05) {
            this.setYRot((float)MathHelper.atan2(var0.z, var0.x) * 57.295776f - 90.0f);
        }
        super.aiStep();
        for (var1 = 0; var1 < 2; ++var1) {
            this.yRotOHeads[var1] = this.yRotHeads[var1];
            this.xRotOHeads[var1] = this.xRotHeads[var1];
        }
        for (var1 = 0; var1 < 2; ++var1) {
            int var23 = this.getAlternativeTarget(var1 + 1);
            Entity var3 = null;
            if (var23 > 0) {
                var3 = this.level.getEntity(var23);
            }
            if (var3 != null) {
                double var4 = this.getHeadX(var1 + 1);
                double var6 = this.getHeadY(var1 + 1);
                double var8 = this.getHeadZ(var1 + 1);
                double var10 = var3.getX() - var4;
                double var122 = var3.getEyeY() - var6;
                double var14 = var3.getZ() - var8;
                double var16 = Math.sqrt(var10 * var10 + var14 * var14);
                float var18 = (float)(MathHelper.atan2(var14, var10) * 57.2957763671875) - 90.0f;
                float var19 = (float)(-(MathHelper.atan2(var122, var16) * 57.2957763671875));
                this.xRotHeads[var1] = this.rotlerp(this.xRotHeads[var1], var19, 40.0f);
                this.yRotHeads[var1] = this.rotlerp(this.yRotHeads[var1], var18, 10.0f);
                continue;
            }
            this.yRotHeads[var1] = this.rotlerp(this.yRotHeads[var1], this.yBodyRot, 10.0f);
        }
        var1 = this.isPowered() ? 1 : 0;
        for (var2 = 0; var2 < 3; ++var2) {
            double var3 = this.getHeadX(var2);
            double var5 = this.getHeadY(var2);
            double var7 = this.getHeadZ(var2);
            this.level.addParticle(Particles.SMOKE, var3 + this.random.nextGaussian() * (double)0.3f, var5 + this.random.nextGaussian() * (double)0.3f, var7 + this.random.nextGaussian() * (double)0.3f, 0.0, 0.0, 0.0);
            if (var1 == 0 || this.level.random.nextInt(4) != 0) continue;
            this.level.addParticle(Particles.ENTITY_EFFECT, var3 + this.random.nextGaussian() * (double)0.3f, var5 + this.random.nextGaussian() * (double)0.3f, var7 + this.random.nextGaussian() * (double)0.3f, 0.7f, 0.7f, 0.5);
        }
        if (this.getInvulnerableTicks() > 0) {
            for (var2 = 0; var2 < 3; ++var2) {
                this.level.addParticle(Particles.ENTITY_EFFECT, this.getX() + this.random.nextGaussian(), this.getY() + (double)(this.random.nextFloat() * 3.3f), this.getZ() + this.random.nextGaussian(), 0.7f, 0.7f, 0.9f);
            }
        }
    }

    @Override
    protected void customServerAiStep() {
        int var1;
        int var0;
        if (this.getInvulnerableTicks() > 0) {
            int var02 = this.getInvulnerableTicks() - 1;
            this.bossEvent.setProgress(1.0f - (float)var02 / 220.0f);
            if (var02 <= 0) {
                Explosion.Effect var12 = this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) ? Explosion.Effect.DESTROY : Explosion.Effect.NONE;
                this.level.explode(this, this.getX(), this.getEyeY(), this.getZ(), 7.0f, false, var12);
                if (!this.isSilent()) {
                    this.level.globalLevelEvent(1023, this.blockPosition(), 0);
                }
            }
            this.setInvulnerableTicks(var02);
            if (this.tickCount % 10 == 0) {
                this.heal(10.0f);
            }
            return;
        }
        super.customServerAiStep();
        for (var0 = 1; var0 < 3; ++var0) {
            List<EntityLiving> var2;
            if (this.tickCount < this.nextHeadUpdate[var0 - 1]) continue;
            this.nextHeadUpdate[var0 - 1] = this.tickCount + 10 + this.random.nextInt(10);
            if (this.level.getDifficulty() == EnumDifficulty.NORMAL || this.level.getDifficulty() == EnumDifficulty.HARD) {
                int n2 = var0 - 1;
                int n3 = this.idleHeadUpdates[n2];
                this.idleHeadUpdates[n2] = n3 + 1;
                if (n3 > 15) {
                    float var13 = 10.0f;
                    float var22 = 5.0f;
                    double var3 = MathHelper.nextDouble(this.random, this.getX() - 10.0, this.getX() + 10.0);
                    double var5 = MathHelper.nextDouble(this.random, this.getY() - 5.0, this.getY() + 5.0);
                    double var7 = MathHelper.nextDouble(this.random, this.getZ() - 10.0, this.getZ() + 10.0);
                    this.performRangedAttack(var0 + 1, var3, var5, var7, true);
                    this.idleHeadUpdates[var0 - 1] = 0;
                }
            }
            if ((var1 = this.getAlternativeTarget(var0)) > 0) {
                var2 = (EntityLiving)this.level.getEntity(var1);
                if (var2 == null || !this.canAttack((EntityLiving)((Object)var2)) || this.distanceToSqr((Entity)((Object)var2)) > 900.0 || !this.hasLineOfSight((Entity)((Object)var2))) {
                    this.setAlternativeTarget(var0, 0);
                    continue;
                }
                this.performRangedAttack(var0 + 1, (EntityLiving)((Object)var2));
                this.nextHeadUpdate[var0 - 1] = this.tickCount + 40 + this.random.nextInt(20);
                this.idleHeadUpdates[var0 - 1] = 0;
                continue;
            }
            var2 = this.level.getNearbyEntities(EntityLiving.class, TARGETING_CONDITIONS, this, this.getBoundingBox().inflate(20.0, 8.0, 20.0));
            if (var2.isEmpty()) continue;
            EntityLiving var3 = (EntityLiving)var2.get(this.random.nextInt(var2.size()));
            this.setAlternativeTarget(var0, var3.getId());
        }
        if (this.getTarget() != null) {
            this.setAlternativeTarget(0, this.getTarget().getId());
        } else {
            this.setAlternativeTarget(0, 0);
        }
        if (this.destroyBlocksTick > 0) {
            --this.destroyBlocksTick;
            if (this.destroyBlocksTick == 0 && this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                var0 = MathHelper.floor(this.getY());
                var1 = MathHelper.floor(this.getX());
                int var2 = MathHelper.floor(this.getZ());
                boolean var3 = false;
                for (int var4 = -1; var4 <= 1; ++var4) {
                    for (int var5 = -1; var5 <= 1; ++var5) {
                        for (int var6 = 0; var6 <= 3; ++var6) {
                            int var7 = var1 + var4;
                            int var8 = var0 + var6;
                            int var9 = var2 + var5;
                            BlockPosition var10 = new BlockPosition(var7, var8, var9);
                            IBlockData var11 = this.level.getBlockState(var10);
                            if (!EntityWither.canDestroy(var11)) continue;
                            var3 = this.level.destroyBlock(var10, true, this) || var3;
                        }
                    }
                }
                if (var3) {
                    this.level.levelEvent(null, 1022, this.blockPosition(), 0);
                }
            }
        }
        if (this.tickCount % 20 == 0) {
            this.heal(1.0f);
        }
        this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public static boolean canDestroy(IBlockData var0) {
        return !var0.isAir() && !var0.is(TagsBlock.WITHER_IMMUNE);
    }

    public void makeInvulnerable() {
        this.setInvulnerableTicks(220);
        this.bossEvent.setProgress(0.0f);
        this.setHealth(this.getMaxHealth() / 3.0f);
    }

    @Override
    public void makeStuckInBlock(IBlockData var0, Vec3D var1) {
    }

    @Override
    public void startSeenByPlayer(EntityPlayer var0) {
        super.startSeenByPlayer(var0);
        this.bossEvent.addPlayer(var0);
    }

    @Override
    public void stopSeenByPlayer(EntityPlayer var0) {
        super.stopSeenByPlayer(var0);
        this.bossEvent.removePlayer(var0);
    }

    private double getHeadX(int var0) {
        if (var0 <= 0) {
            return this.getX();
        }
        float var1 = (this.yBodyRot + (float)(180 * (var0 - 1))) * ((float)Math.PI / 180);
        float var2 = MathHelper.cos(var1);
        return this.getX() + (double)var2 * 1.3;
    }

    private double getHeadY(int var0) {
        if (var0 <= 0) {
            return this.getY() + 3.0;
        }
        return this.getY() + 2.2;
    }

    private double getHeadZ(int var0) {
        if (var0 <= 0) {
            return this.getZ();
        }
        float var1 = (this.yBodyRot + (float)(180 * (var0 - 1))) * ((float)Math.PI / 180);
        float var2 = MathHelper.sin(var1);
        return this.getZ() + (double)var2 * 1.3;
    }

    private float rotlerp(float var0, float var1, float var2) {
        float var3 = MathHelper.wrapDegrees(var1 - var0);
        if (var3 > var2) {
            var3 = var2;
        }
        if (var3 < -var2) {
            var3 = -var2;
        }
        return var0 + var3;
    }

    private void performRangedAttack(int var0, EntityLiving var1) {
        this.performRangedAttack(var0, var1.getX(), var1.getY() + (double)var1.getEyeHeight() * 0.5, var1.getZ(), var0 == 0 && this.random.nextFloat() < 0.001f);
    }

    private void performRangedAttack(int var0, double var1, double var3, double var5, boolean var7) {
        if (!this.isSilent()) {
            this.level.levelEvent(null, 1024, this.blockPosition(), 0);
        }
        double var8 = this.getHeadX(var0);
        double var10 = this.getHeadY(var0);
        double var12 = this.getHeadZ(var0);
        double var14 = var1 - var8;
        double var16 = var3 - var10;
        double var18 = var5 - var12;
        EntityWitherSkull var20 = new EntityWitherSkull(this.level, this, var14, var16, var18);
        var20.setOwner(this);
        if (var7) {
            var20.setDangerous(true);
        }
        var20.setPosRaw(var8, var10, var12);
        this.level.addFreshEntity(var20);
    }

    @Override
    public void performRangedAttack(EntityLiving var0, float var1) {
        this.performRangedAttack(0, var0);
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        Entity var2;
        if (this.isInvulnerableTo(var0)) {
            return false;
        }
        if (var0 == DamageSource.DROWN || var0.getEntity() instanceof EntityWither) {
            return false;
        }
        if (this.getInvulnerableTicks() > 0 && var0 != DamageSource.OUT_OF_WORLD) {
            return false;
        }
        if (this.isPowered() && (var2 = var0.getDirectEntity()) instanceof EntityArrow) {
            return false;
        }
        var2 = var0.getEntity();
        if (var2 != null && !(var2 instanceof EntityHuman) && var2 instanceof EntityLiving && ((EntityLiving)var2).getMobType() == this.getMobType()) {
            return false;
        }
        if (this.destroyBlocksTick <= 0) {
            this.destroyBlocksTick = 20;
        }
        int var3 = 0;
        while (var3 < this.idleHeadUpdates.length) {
            int n2 = var3++;
            this.idleHeadUpdates[n2] = this.idleHeadUpdates[n2] + 3;
        }
        return super.hurt(var0, var1);
    }

    @Override
    protected void dropCustomDeathLoot(DamageSource var0, int var1, boolean var2) {
        super.dropCustomDeathLoot(var0, var1, var2);
        EntityItem var3 = this.spawnAtLocation(Items.NETHER_STAR);
        if (var3 != null) {
            var3.setExtendedLifetime();
        }
    }

    @Override
    public void checkDespawn() {
        if (this.level.getDifficulty() == EnumDifficulty.PEACEFUL && this.shouldDespawnInPeaceful()) {
            this.discard();
            return;
        }
        this.noActionTime = 0;
    }

    @Override
    public boolean causeFallDamage(float var0, float var1, DamageSource var2) {
        return false;
    }

    @Override
    public boolean addEffect(MobEffect var0, @Nullable Entity var1) {
        return false;
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityMonster.createMonsterAttributes().add(GenericAttributes.MAX_HEALTH, 300.0).add(GenericAttributes.MOVEMENT_SPEED, 0.6f).add(GenericAttributes.FLYING_SPEED, 0.6f).add(GenericAttributes.FOLLOW_RANGE, 40.0).add(GenericAttributes.ARMOR, 4.0);
    }

    public float getHeadYRot(int var0) {
        return this.yRotHeads[var0];
    }

    public float getHeadXRot(int var0) {
        return this.xRotHeads[var0];
    }

    public int getInvulnerableTicks() {
        return this.entityData.get(DATA_ID_INV);
    }

    public void setInvulnerableTicks(int var0) {
        this.entityData.set(DATA_ID_INV, var0);
    }

    public int getAlternativeTarget(int var0) {
        return this.entityData.get(DATA_TARGETS.get(var0));
    }

    public void setAlternativeTarget(int var0, int var1) {
        this.entityData.set(DATA_TARGETS.get(var0), var1);
    }

    @Override
    public boolean isPowered() {
        return this.getHealth() <= this.getMaxHealth() / 2.0f;
    }

    @Override
    public EnumMonsterType getMobType() {
        return EnumMonsterType.UNDEAD;
    }

    @Override
    protected boolean canRide(Entity var0) {
        return false;
    }

    @Override
    public boolean canChangeDimensions() {
        return false;
    }

    @Override
    public boolean canBeAffected(MobEffect var0) {
        if (var0.getEffect() == MobEffects.WITHER) {
            return false;
        }
        return super.canBeAffected(var0);
    }

    class a
    extends PathfinderGoal {
        public a() {
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.JUMP, PathfinderGoal.Type.LOOK));
        }

        @Override
        public boolean canUse() {
            return EntityWither.this.getInvulnerableTicks() > 0;
        }
    }
}

