/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;

public class EntityPanda
extends EntityAnimal {
    private static final DataWatcherObject<Integer> UNHAPPY_COUNTER = DataWatcher.defineId(EntityPanda.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Integer> SNEEZE_COUNTER = DataWatcher.defineId(EntityPanda.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Integer> EAT_COUNTER = DataWatcher.defineId(EntityPanda.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Byte> MAIN_GENE_ID = DataWatcher.defineId(EntityPanda.class, DataWatcherRegistry.BYTE);
    private static final DataWatcherObject<Byte> HIDDEN_GENE_ID = DataWatcher.defineId(EntityPanda.class, DataWatcherRegistry.BYTE);
    private static final DataWatcherObject<Byte> DATA_ID_FLAGS = DataWatcher.defineId(EntityPanda.class, DataWatcherRegistry.BYTE);
    static final PathfinderTargetCondition BREED_TARGETING = PathfinderTargetCondition.forNonCombat().range(8.0);
    private static final int FLAG_SNEEZE = 2;
    private static final int FLAG_ROLL = 4;
    private static final int FLAG_SIT = 8;
    private static final int FLAG_ON_BACK = 16;
    private static final int EAT_TICK_INTERVAL = 5;
    public static final int TOTAL_ROLL_STEPS = 32;
    private static final int TOTAL_UNHAPPY_TIME = 32;
    boolean gotBamboo;
    boolean didBite;
    public int rollCounter;
    private Vec3D rollDelta;
    private float sitAmount;
    private float sitAmountO;
    private float onBackAmount;
    private float onBackAmountO;
    private float rollAmount;
    private float rollAmountO;
    g lookAtPlayerGoal;
    static final Predicate<EntityItem> PANDA_ITEMS = var0 -> {
        ItemStack var1 = var0.getItem();
        return (var1.is(Blocks.BAMBOO.asItem()) || var1.is(Blocks.CAKE.asItem())) && var0.isAlive() && !var0.hasPickUpDelay();
    };

    public EntityPanda(EntityTypes<? extends EntityPanda> var0, World var1) {
        super((EntityTypes<? extends EntityAnimal>)var0, var1);
        this.moveControl = new h(this);
        if (!this.isBaby()) {
            this.setCanPickUpLoot(true);
        }
    }

    @Override
    public boolean canTakeItem(ItemStack var0) {
        EnumItemSlot var1 = EntityInsentient.getEquipmentSlotForItem(var0);
        if (!this.getItemBySlot(var1).isEmpty()) {
            return false;
        }
        return var1 == EnumItemSlot.MAINHAND && super.canTakeItem(var0);
    }

    public int getUnhappyCounter() {
        return this.entityData.get(UNHAPPY_COUNTER);
    }

    public void setUnhappyCounter(int var0) {
        this.entityData.set(UNHAPPY_COUNTER, var0);
    }

    public boolean isSneezing() {
        return this.getFlag(2);
    }

    public boolean isSitting() {
        return this.getFlag(8);
    }

    public void sit(boolean var0) {
        this.setFlag(8, var0);
    }

    public boolean isOnBack() {
        return this.getFlag(16);
    }

    public void setOnBack(boolean var0) {
        this.setFlag(16, var0);
    }

    public boolean isEating() {
        return this.entityData.get(EAT_COUNTER) > 0;
    }

    public void eat(boolean var0) {
        this.entityData.set(EAT_COUNTER, var0 ? 1 : 0);
    }

    private int getEatCounter() {
        return this.entityData.get(EAT_COUNTER);
    }

    private void setEatCounter(int var0) {
        this.entityData.set(EAT_COUNTER, var0);
    }

    public void sneeze(boolean var0) {
        this.setFlag(2, var0);
        if (!var0) {
            this.setSneezeCounter(0);
        }
    }

    public int getSneezeCounter() {
        return this.entityData.get(SNEEZE_COUNTER);
    }

    public void setSneezeCounter(int var0) {
        this.entityData.set(SNEEZE_COUNTER, var0);
    }

    public Gene getMainGene() {
        return Gene.byId(this.entityData.get(MAIN_GENE_ID).byteValue());
    }

    public void setMainGene(Gene var0) {
        if (var0.getId() > 6) {
            var0 = Gene.getRandom(this.random);
        }
        this.entityData.set(MAIN_GENE_ID, (byte)var0.getId());
    }

    public Gene getHiddenGene() {
        return Gene.byId(this.entityData.get(HIDDEN_GENE_ID).byteValue());
    }

    public void setHiddenGene(Gene var0) {
        if (var0.getId() > 6) {
            var0 = Gene.getRandom(this.random);
        }
        this.entityData.set(HIDDEN_GENE_ID, (byte)var0.getId());
    }

    public boolean isRolling() {
        return this.getFlag(4);
    }

    public void roll(boolean var0) {
        this.setFlag(4, var0);
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(UNHAPPY_COUNTER, 0);
        this.entityData.define(SNEEZE_COUNTER, 0);
        this.entityData.define(MAIN_GENE_ID, (byte)0);
        this.entityData.define(HIDDEN_GENE_ID, (byte)0);
        this.entityData.define(DATA_ID_FLAGS, (byte)0);
        this.entityData.define(EAT_COUNTER, 0);
    }

    private boolean getFlag(int var0) {
        return (this.entityData.get(DATA_ID_FLAGS) & var0) != 0;
    }

    private void setFlag(int var0, boolean var1) {
        byte var2 = this.entityData.get(DATA_ID_FLAGS);
        if (var1) {
            this.entityData.set(DATA_ID_FLAGS, (byte)(var2 | var0));
        } else {
            this.entityData.set(DATA_ID_FLAGS, (byte)(var2 & ~var0));
        }
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putString("MainGene", this.getMainGene().getName());
        var0.putString("HiddenGene", this.getHiddenGene().getName());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.setMainGene(Gene.byName(var0.getString("MainGene")));
        this.setHiddenGene(Gene.byName(var0.getString("HiddenGene")));
    }

    @Override
    @Nullable
    public EntityAgeable getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        EntityPanda var2 = EntityTypes.PANDA.create(var0);
        if (var1 instanceof EntityPanda) {
            var2.setGeneFromParents(this, (EntityPanda)var1);
        }
        var2.setAttributes();
        return var2;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(2, new i(this, 2.0));
        this.goalSelector.addGoal(2, new d(this, 1.0));
        this.goalSelector.addGoal(3, new b(this, (double)1.2f, true));
        this.goalSelector.addGoal(4, new PathfinderGoalTempt(this, 1.0, RecipeItemStack.of(Blocks.BAMBOO.asItem()), false));
        this.goalSelector.addGoal(6, new c<EntityHuman>(this, EntityHuman.class, 8.0f, 2.0, 2.0));
        this.goalSelector.addGoal(6, new c<EntityMonster>(this, EntityMonster.class, 4.0f, 2.0, 2.0));
        this.goalSelector.addGoal(7, new k());
        this.goalSelector.addGoal(8, new f(this));
        this.goalSelector.addGoal(8, new l(this));
        this.lookAtPlayerGoal = new g(this, EntityHuman.class, 6.0f);
        this.goalSelector.addGoal(9, this.lookAtPlayerGoal);
        this.goalSelector.addGoal(10, new PathfinderGoalRandomLookaround(this));
        this.goalSelector.addGoal(12, new j(this));
        this.goalSelector.addGoal(13, new PathfinderGoalFollowParent(this, 1.25));
        this.goalSelector.addGoal(14, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.targetSelector.addGoal(1, new e(this, new Class[0]).setAlertOthers(new Class[0]));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.15f).add(GenericAttributes.ATTACK_DAMAGE, 6.0);
    }

    public Gene getVariant() {
        return Gene.getVariantFromGenes(this.getMainGene(), this.getHiddenGene());
    }

    public boolean isLazy() {
        return this.getVariant() == Gene.LAZY;
    }

    public boolean isWorried() {
        return this.getVariant() == Gene.WORRIED;
    }

    public boolean isPlayful() {
        return this.getVariant() == Gene.PLAYFUL;
    }

    public boolean isBrown() {
        return this.getVariant() == Gene.BROWN;
    }

    public boolean isWeak() {
        return this.getVariant() == Gene.WEAK;
    }

    @Override
    public boolean isAggressive() {
        return this.getVariant() == Gene.AGGRESSIVE;
    }

    @Override
    public boolean canBeLeashed(EntityHuman var0) {
        return false;
    }

    @Override
    public boolean doHurtTarget(Entity var0) {
        this.playSound(SoundEffects.PANDA_BITE, 1.0f, 1.0f);
        if (!this.isAggressive()) {
            this.didBite = true;
        }
        return super.doHurtTarget(var0);
    }

    @Override
    public void tick() {
        EntityLiving var0;
        super.tick();
        if (this.isWorried()) {
            if (this.level.isThundering() && !this.isInWater()) {
                this.sit(true);
                this.eat(false);
            } else if (!this.isEating()) {
                this.sit(false);
            }
        }
        if ((var0 = this.getTarget()) == null) {
            this.gotBamboo = false;
            this.didBite = false;
        }
        if (this.getUnhappyCounter() > 0) {
            if (var0 != null) {
                this.lookAt(var0, 90.0f, 90.0f);
            }
            if (this.getUnhappyCounter() == 29 || this.getUnhappyCounter() == 14) {
                this.playSound(SoundEffects.PANDA_CANT_BREED, 1.0f, 1.0f);
            }
            this.setUnhappyCounter(this.getUnhappyCounter() - 1);
        }
        if (this.isSneezing()) {
            this.setSneezeCounter(this.getSneezeCounter() + 1);
            if (this.getSneezeCounter() > 20) {
                this.sneeze(false);
                this.afterSneeze();
            } else if (this.getSneezeCounter() == 1) {
                this.playSound(SoundEffects.PANDA_PRE_SNEEZE, 1.0f, 1.0f);
            }
        }
        if (this.isRolling()) {
            this.handleRoll();
        } else {
            this.rollCounter = 0;
        }
        if (this.isSitting()) {
            this.setXRot(0.0f);
        }
        this.updateSitAmount();
        this.handleEating();
        this.updateOnBackAnimation();
        this.updateRollAmount();
    }

    public boolean isScared() {
        return this.isWorried() && this.level.isThundering();
    }

    private void handleEating() {
        if (!this.isEating() && this.isSitting() && !this.isScared() && !this.getItemBySlot(EnumItemSlot.MAINHAND).isEmpty() && this.random.nextInt(80) == 1) {
            this.eat(true);
        } else if (this.getItemBySlot(EnumItemSlot.MAINHAND).isEmpty() || !this.isSitting()) {
            this.eat(false);
        }
        if (this.isEating()) {
            this.addEatingParticles();
            if (!this.level.isClientSide && this.getEatCounter() > 80 && this.random.nextInt(20) == 1) {
                if (this.getEatCounter() > 100 && this.isFoodOrCake(this.getItemBySlot(EnumItemSlot.MAINHAND))) {
                    if (!this.level.isClientSide) {
                        this.setItemSlot(EnumItemSlot.MAINHAND, ItemStack.EMPTY);
                        this.gameEvent(GameEvent.EAT);
                    }
                    this.sit(false);
                }
                this.eat(false);
                return;
            }
            this.setEatCounter(this.getEatCounter() + 1);
        }
    }

    private void addEatingParticles() {
        if (this.getEatCounter() % 5 == 0) {
            this.playSound(SoundEffects.PANDA_EAT, 0.5f + 0.5f * (float)this.random.nextInt(2), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            for (int var0 = 0; var0 < 6; ++var0) {
                Vec3D var1 = new Vec3D(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.random.nextFloat() - 0.5) * 0.1);
                var1 = var1.xRot(-this.getXRot() * ((float)Math.PI / 180));
                var1 = var1.yRot(-this.getYRot() * ((float)Math.PI / 180));
                double var2 = (double)(-this.random.nextFloat()) * 0.6 - 0.3;
                Vec3D var4 = new Vec3D(((double)this.random.nextFloat() - 0.5) * 0.8, var2, 1.0 + ((double)this.random.nextFloat() - 0.5) * 0.4);
                var4 = var4.yRot(-this.yBodyRot * ((float)Math.PI / 180));
                var4 = var4.add(this.getX(), this.getEyeY() + 1.0, this.getZ());
                this.level.addParticle(new ParticleParamItem(Particles.ITEM, this.getItemBySlot(EnumItemSlot.MAINHAND)), var4.x, var4.y, var4.z, var1.x, var1.y + 0.05, var1.z);
            }
        }
    }

    private void updateSitAmount() {
        this.sitAmountO = this.sitAmount;
        this.sitAmount = this.isSitting() ? Math.min(1.0f, this.sitAmount + 0.15f) : Math.max(0.0f, this.sitAmount - 0.19f);
    }

    private void updateOnBackAnimation() {
        this.onBackAmountO = this.onBackAmount;
        this.onBackAmount = this.isOnBack() ? Math.min(1.0f, this.onBackAmount + 0.15f) : Math.max(0.0f, this.onBackAmount - 0.19f);
    }

    private void updateRollAmount() {
        this.rollAmountO = this.rollAmount;
        this.rollAmount = this.isRolling() ? Math.min(1.0f, this.rollAmount + 0.15f) : Math.max(0.0f, this.rollAmount - 0.19f);
    }

    public float getSitAmount(float var0) {
        return MathHelper.lerp(var0, this.sitAmountO, this.sitAmount);
    }

    public float getLieOnBackAmount(float var0) {
        return MathHelper.lerp(var0, this.onBackAmountO, this.onBackAmount);
    }

    public float getRollAmount(float var0) {
        return MathHelper.lerp(var0, this.rollAmountO, this.rollAmount);
    }

    private void handleRoll() {
        ++this.rollCounter;
        if (this.rollCounter > 32) {
            this.roll(false);
            return;
        }
        if (!this.level.isClientSide) {
            Vec3D var0 = this.getDeltaMovement();
            if (this.rollCounter == 1) {
                float var1 = this.getYRot() * ((float)Math.PI / 180);
                float var2 = this.isBaby() ? 0.1f : 0.2f;
                this.rollDelta = new Vec3D(var0.x + (double)(-MathHelper.sin(var1) * var2), 0.0, var0.z + (double)(MathHelper.cos(var1) * var2));
                this.setDeltaMovement(this.rollDelta.add(0.0, 0.27, 0.0));
            } else if ((float)this.rollCounter == 7.0f || (float)this.rollCounter == 15.0f || (float)this.rollCounter == 23.0f) {
                this.setDeltaMovement(0.0, this.onGround ? 0.27 : var0.y, 0.0);
            } else {
                this.setDeltaMovement(this.rollDelta.x, var0.y, this.rollDelta.z);
            }
        }
    }

    private void afterSneeze() {
        Vec3D var0 = this.getDeltaMovement();
        this.level.addParticle(Particles.SNEEZE, this.getX() - (double)(this.getBbWidth() + 1.0f) * 0.5 * (double)MathHelper.sin(this.yBodyRot * ((float)Math.PI / 180)), this.getEyeY() - (double)0.1f, this.getZ() + (double)(this.getBbWidth() + 1.0f) * 0.5 * (double)MathHelper.cos(this.yBodyRot * ((float)Math.PI / 180)), var0.x, 0.0, var0.z);
        this.playSound(SoundEffects.PANDA_SNEEZE, 1.0f, 1.0f);
        List<EntityPanda> var1 = this.level.getEntitiesOfClass(EntityPanda.class, this.getBoundingBox().inflate(10.0));
        for (EntityPanda var3 : var1) {
            if (var3.isBaby() || !var3.onGround || var3.isInWater() || !var3.canPerformAction()) continue;
            var3.jumpFromGround();
        }
        if (!this.level.isClientSide() && this.random.nextInt(700) == 0 && this.level.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            this.spawnAtLocation(Items.SLIME_BALL);
        }
    }

    @Override
    protected void pickUpItem(EntityItem var0) {
        if (this.getItemBySlot(EnumItemSlot.MAINHAND).isEmpty() && PANDA_ITEMS.test(var0)) {
            this.onItemPickup(var0);
            ItemStack var1 = var0.getItem();
            this.setItemSlot(EnumItemSlot.MAINHAND, var1);
            this.setGuaranteedDrop(EnumItemSlot.MAINHAND);
            this.take(var0, var1.getCount());
            var0.discard();
        }
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        if (!this.level.isClientSide) {
            this.sit(false);
        }
        return super.hurt(var0, var1);
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        RandomSource var5 = var0.getRandom();
        this.setMainGene(Gene.getRandom(var5));
        this.setHiddenGene(Gene.getRandom(var5));
        this.setAttributes();
        if (var3 == null) {
            var3 = new EntityAgeable.a(0.2f);
        }
        return super.finalizeSpawn(var0, var1, var2, var3, var4);
    }

    public void setGeneFromParents(EntityPanda var0, @Nullable EntityPanda var1) {
        if (var1 == null) {
            if (this.random.nextBoolean()) {
                this.setMainGene(var0.getOneOfGenesRandomly());
                this.setHiddenGene(Gene.getRandom(this.random));
            } else {
                this.setMainGene(Gene.getRandom(this.random));
                this.setHiddenGene(var0.getOneOfGenesRandomly());
            }
        } else if (this.random.nextBoolean()) {
            this.setMainGene(var0.getOneOfGenesRandomly());
            this.setHiddenGene(var1.getOneOfGenesRandomly());
        } else {
            this.setMainGene(var1.getOneOfGenesRandomly());
            this.setHiddenGene(var0.getOneOfGenesRandomly());
        }
        if (this.random.nextInt(32) == 0) {
            this.setMainGene(Gene.getRandom(this.random));
        }
        if (this.random.nextInt(32) == 0) {
            this.setHiddenGene(Gene.getRandom(this.random));
        }
    }

    private Gene getOneOfGenesRandomly() {
        if (this.random.nextBoolean()) {
            return this.getMainGene();
        }
        return this.getHiddenGene();
    }

    public void setAttributes() {
        if (this.isWeak()) {
            this.getAttribute(GenericAttributes.MAX_HEALTH).setBaseValue(10.0);
        }
        if (this.isLazy()) {
            this.getAttribute(GenericAttributes.MOVEMENT_SPEED).setBaseValue(0.07f);
        }
    }

    void tryToSit() {
        if (!this.isInWater()) {
            this.setZza(0.0f);
            this.getNavigation().stop();
            this.sit(true);
        }
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        if (this.isScared()) {
            return EnumInteractionResult.PASS;
        }
        if (this.isOnBack()) {
            this.setOnBack(false);
            return EnumInteractionResult.sidedSuccess(this.level.isClientSide);
        }
        if (this.isFood(var2)) {
            if (this.getTarget() != null) {
                this.gotBamboo = true;
            }
            if (this.isBaby()) {
                this.usePlayerItem(var0, var1, var2);
                this.ageUp((int)((float)(-this.getAge() / 20) * 0.1f), true);
            } else if (!this.level.isClientSide && this.getAge() == 0 && this.canFallInLove()) {
                this.usePlayerItem(var0, var1, var2);
                this.setInLove(var0);
            } else if (!(this.level.isClientSide || this.isSitting() || this.isInWater())) {
                this.tryToSit();
                this.eat(true);
                ItemStack var3 = this.getItemBySlot(EnumItemSlot.MAINHAND);
                if (!var3.isEmpty() && !var0.getAbilities().instabuild) {
                    this.spawnAtLocation(var3);
                }
                this.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(var2.getItem(), 1));
                this.usePlayerItem(var0, var1, var2);
            } else {
                return EnumInteractionResult.PASS;
            }
            return EnumInteractionResult.SUCCESS;
        }
        return EnumInteractionResult.PASS;
    }

    @Override
    @Nullable
    protected SoundEffect getAmbientSound() {
        if (this.isAggressive()) {
            return SoundEffects.PANDA_AGGRESSIVE_AMBIENT;
        }
        if (this.isWorried()) {
            return SoundEffects.PANDA_WORRIED_AMBIENT;
        }
        return SoundEffects.PANDA_AMBIENT;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.PANDA_STEP, 0.15f, 1.0f);
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return var0.is(Blocks.BAMBOO.asItem());
    }

    private boolean isFoodOrCake(ItemStack var0) {
        return this.isFood(var0) || var0.is(Blocks.CAKE.asItem());
    }

    @Override
    @Nullable
    protected SoundEffect getDeathSound() {
        return SoundEffects.PANDA_DEATH;
    }

    @Override
    @Nullable
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.PANDA_HURT;
    }

    public boolean canPerformAction() {
        return !this.isOnBack() && !this.isScared() && !this.isEating() && !this.isRolling() && !this.isSitting();
    }

    static class h
    extends ControllerMove {
        private final EntityPanda panda;

        public h(EntityPanda var0) {
            super(var0);
            this.panda = var0;
        }

        @Override
        public void tick() {
            if (!this.panda.canPerformAction()) {
                return;
            }
            super.tick();
        }
    }

    public static final class Gene
    extends Enum<Gene> {
        public static final /* enum */ Gene NORMAL = new Gene(0, "normal", false);
        public static final /* enum */ Gene LAZY = new Gene(1, "lazy", false);
        public static final /* enum */ Gene WORRIED = new Gene(2, "worried", false);
        public static final /* enum */ Gene PLAYFUL = new Gene(3, "playful", false);
        public static final /* enum */ Gene BROWN = new Gene(4, "brown", true);
        public static final /* enum */ Gene WEAK = new Gene(5, "weak", true);
        public static final /* enum */ Gene AGGRESSIVE = new Gene(6, "aggressive", false);
        private static final Gene[] BY_ID;
        private static final int MAX_GENE = 6;
        private final int id;
        private final String name;
        private final boolean isRecessive;
        private static final /* synthetic */ Gene[] m;

        public static Gene[] values() {
            return (Gene[])m.clone();
        }

        public static Gene valueOf(String var0) {
            return Enum.valueOf(Gene.class, var0);
        }

        private Gene(int var2, String var3, boolean var4) {
            this.id = var2;
            this.name = var3;
            this.isRecessive = var4;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean isRecessive() {
            return this.isRecessive;
        }

        static Gene getVariantFromGenes(Gene var0, Gene var1) {
            if (var0.isRecessive()) {
                if (var0 == var1) {
                    return var0;
                }
                return NORMAL;
            }
            return var0;
        }

        public static Gene byId(int var0) {
            if (var0 < 0 || var0 >= BY_ID.length) {
                var0 = 0;
            }
            return BY_ID[var0];
        }

        public static Gene byName(String var0) {
            for (Gene var4 : Gene.values()) {
                if (!var4.name.equals(var0)) continue;
                return var4;
            }
            return NORMAL;
        }

        public static Gene getRandom(RandomSource var0) {
            int var1 = var0.nextInt(16);
            if (var1 == 0) {
                return LAZY;
            }
            if (var1 == 1) {
                return WORRIED;
            }
            if (var1 == 2) {
                return PLAYFUL;
            }
            if (var1 == 4) {
                return AGGRESSIVE;
            }
            if (var1 < 9) {
                return WEAK;
            }
            if (var1 < 11) {
                return BROWN;
            }
            return NORMAL;
        }

        private static /* synthetic */ Gene[] d() {
            return new Gene[]{NORMAL, LAZY, WORRIED, PLAYFUL, BROWN, WEAK, AGGRESSIVE};
        }

        static {
            m = Gene.d();
            BY_ID = (Gene[])Arrays.stream(Gene.values()).sorted(Comparator.comparingInt(Gene::getId)).toArray(Gene[]::new);
        }
    }

    static class i
    extends PathfinderGoalPanic {
        private final EntityPanda panda;

        public i(EntityPanda var0, double var1) {
            super(var0, var1);
            this.panda = var0;
        }

        @Override
        protected boolean shouldPanic() {
            return this.mob.isFreezing() || this.mob.isOnFire();
        }

        @Override
        public boolean canContinueToUse() {
            if (this.panda.isSitting()) {
                this.panda.getNavigation().stop();
                return false;
            }
            return super.canContinueToUse();
        }
    }

    static class d
    extends PathfinderGoalBreed {
        private final EntityPanda panda;
        private int unhappyCooldown;

        public d(EntityPanda var0, double var1) {
            super(var0, var1);
            this.panda = var0;
        }

        @Override
        public boolean canUse() {
            if (super.canUse() && this.panda.getUnhappyCounter() == 0) {
                if (!this.canFindBamboo()) {
                    if (this.unhappyCooldown <= this.panda.tickCount) {
                        this.panda.setUnhappyCounter(32);
                        this.unhappyCooldown = this.panda.tickCount + 600;
                        if (this.panda.isEffectiveAi()) {
                            EntityHuman var0 = this.level.getNearestPlayer(BREED_TARGETING, this.panda);
                            this.panda.lookAtPlayerGoal.setTarget(var0);
                        }
                    }
                    return false;
                }
                return true;
            }
            return false;
        }

        private boolean canFindBamboo() {
            BlockPosition var0 = this.panda.blockPosition();
            BlockPosition.MutableBlockPosition var1 = new BlockPosition.MutableBlockPosition();
            for (int var2 = 0; var2 < 3; ++var2) {
                for (int var3 = 0; var3 < 8; ++var3) {
                    int var4 = 0;
                    while (var4 <= var3) {
                        int var5;
                        int n2 = var5 = var4 < var3 && var4 > -var3 ? var3 : 0;
                        while (var5 <= var3) {
                            var1.setWithOffset(var0, var4, var2, var5);
                            if (this.level.getBlockState(var1).is(Blocks.BAMBOO)) {
                                return true;
                            }
                            var5 = var5 > 0 ? -var5 : 1 - var5;
                        }
                        var4 = var4 > 0 ? -var4 : 1 - var4;
                    }
                }
            }
            return false;
        }
    }

    static class b
    extends PathfinderGoalMeleeAttack {
        private final EntityPanda panda;

        public b(EntityPanda var0, double var1, boolean var3) {
            super(var0, var1, var3);
            this.panda = var0;
        }

        @Override
        public boolean canUse() {
            return this.panda.canPerformAction() && super.canUse();
        }
    }

    static class c<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityPanda panda;

        public c(EntityPanda var0, Class<T> var1, float var2, double var3, double var5) {
            super(var0, var1, var2, var3, var5, IEntitySelector.NO_SPECTATORS::test);
            this.panda = var0;
        }

        @Override
        public boolean canUse() {
            return this.panda.isWorried() && this.panda.canPerformAction() && super.canUse();
        }
    }

    class k
    extends PathfinderGoal {
        private int cooldown;

        public k() {
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canUse() {
            if (this.cooldown > EntityPanda.this.tickCount || EntityPanda.this.isBaby() || EntityPanda.this.isInWater() || !EntityPanda.this.canPerformAction() || EntityPanda.this.getUnhappyCounter() > 0) {
                return false;
            }
            List<EntityItem> var0 = EntityPanda.this.level.getEntitiesOfClass(EntityItem.class, EntityPanda.this.getBoundingBox().inflate(6.0, 6.0, 6.0), PANDA_ITEMS);
            return !var0.isEmpty() || !EntityPanda.this.getItemBySlot(EnumItemSlot.MAINHAND).isEmpty();
        }

        @Override
        public boolean canContinueToUse() {
            if (EntityPanda.this.isInWater() || !EntityPanda.this.isLazy() && EntityPanda.this.random.nextInt(k.reducedTickDelay(600)) == 1) {
                return false;
            }
            return EntityPanda.this.random.nextInt(k.reducedTickDelay(2000)) != 1;
        }

        @Override
        public void tick() {
            if (!EntityPanda.this.isSitting() && !EntityPanda.this.getItemBySlot(EnumItemSlot.MAINHAND).isEmpty()) {
                EntityPanda.this.tryToSit();
            }
        }

        @Override
        public void start() {
            List<EntityItem> var0 = EntityPanda.this.level.getEntitiesOfClass(EntityItem.class, EntityPanda.this.getBoundingBox().inflate(8.0, 8.0, 8.0), PANDA_ITEMS);
            if (!var0.isEmpty() && EntityPanda.this.getItemBySlot(EnumItemSlot.MAINHAND).isEmpty()) {
                EntityPanda.this.getNavigation().moveTo(var0.get(0), (double)1.2f);
            } else if (!EntityPanda.this.getItemBySlot(EnumItemSlot.MAINHAND).isEmpty()) {
                EntityPanda.this.tryToSit();
            }
            this.cooldown = 0;
        }

        @Override
        public void stop() {
            ItemStack var0 = EntityPanda.this.getItemBySlot(EnumItemSlot.MAINHAND);
            if (!var0.isEmpty()) {
                EntityPanda.this.spawnAtLocation(var0);
                EntityPanda.this.setItemSlot(EnumItemSlot.MAINHAND, ItemStack.EMPTY);
                int var1 = EntityPanda.this.isLazy() ? EntityPanda.this.random.nextInt(50) + 10 : EntityPanda.this.random.nextInt(150) + 10;
                this.cooldown = EntityPanda.this.tickCount + var1 * 20;
            }
            EntityPanda.this.sit(false);
        }
    }

    static class f
    extends PathfinderGoal {
        private final EntityPanda panda;
        private int cooldown;

        public f(EntityPanda var0) {
            this.panda = var0;
        }

        @Override
        public boolean canUse() {
            return this.cooldown < this.panda.tickCount && this.panda.isLazy() && this.panda.canPerformAction() && this.panda.random.nextInt(f.reducedTickDelay(400)) == 1;
        }

        @Override
        public boolean canContinueToUse() {
            if (this.panda.isInWater() || !this.panda.isLazy() && this.panda.random.nextInt(f.reducedTickDelay(600)) == 1) {
                return false;
            }
            return this.panda.random.nextInt(f.reducedTickDelay(2000)) != 1;
        }

        @Override
        public void start() {
            this.panda.setOnBack(true);
            this.cooldown = 0;
        }

        @Override
        public void stop() {
            this.panda.setOnBack(false);
            this.cooldown = this.panda.tickCount + 200;
        }
    }

    static class l
    extends PathfinderGoal {
        private final EntityPanda panda;

        public l(EntityPanda var0) {
            this.panda = var0;
        }

        @Override
        public boolean canUse() {
            if (!this.panda.isBaby() || !this.panda.canPerformAction()) {
                return false;
            }
            if (this.panda.isWeak() && this.panda.random.nextInt(l.reducedTickDelay(500)) == 1) {
                return true;
            }
            return this.panda.random.nextInt(l.reducedTickDelay(6000)) == 1;
        }

        @Override
        public boolean canContinueToUse() {
            return false;
        }

        @Override
        public void start() {
            this.panda.sneeze(true);
        }
    }

    static class g
    extends PathfinderGoalLookAtPlayer {
        private final EntityPanda panda;

        public g(EntityPanda var0, Class<? extends EntityLiving> var1, float var2) {
            super(var0, var1, var2);
            this.panda = var0;
        }

        public void setTarget(EntityLiving var0) {
            this.lookAt = var0;
        }

        @Override
        public boolean canContinueToUse() {
            return this.lookAt != null && super.canContinueToUse();
        }

        @Override
        public boolean canUse() {
            if (this.mob.getRandom().nextFloat() >= this.probability) {
                return false;
            }
            if (this.lookAt == null) {
                this.lookAt = this.lookAtType == EntityHuman.class ? this.mob.level.getNearestPlayer(this.lookAtContext, this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ()) : this.mob.level.getNearestEntity(this.mob.level.getEntitiesOfClass(this.lookAtType, this.mob.getBoundingBox().inflate(this.lookDistance, 3.0, this.lookDistance), var0 -> true), this.lookAtContext, this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ());
            }
            return this.panda.canPerformAction() && this.lookAt != null;
        }

        @Override
        public void tick() {
            if (this.lookAt != null) {
                super.tick();
            }
        }
    }

    static class j
    extends PathfinderGoal {
        private final EntityPanda panda;

        public j(EntityPanda var0) {
            this.panda = var0;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK, PathfinderGoal.Type.JUMP));
        }

        @Override
        public boolean canUse() {
            int var4;
            if (!this.panda.isBaby() && !this.panda.isPlayful() || !this.panda.onGround) {
                return false;
            }
            if (!this.panda.canPerformAction()) {
                return false;
            }
            float var0 = this.panda.getYRot() * ((float)Math.PI / 180);
            float var1 = -MathHelper.sin(var0);
            float var2 = MathHelper.cos(var0);
            int var3 = (double)Math.abs(var1) > 0.5 ? MathHelper.sign(var1) : 0;
            int n2 = var4 = (double)Math.abs(var2) > 0.5 ? MathHelper.sign(var2) : 0;
            if (this.panda.level.getBlockState(this.panda.blockPosition().offset(var3, -1, var4)).isAir()) {
                return true;
            }
            if (this.panda.isPlayful() && this.panda.random.nextInt(j.reducedTickDelay(60)) == 1) {
                return true;
            }
            return this.panda.random.nextInt(j.reducedTickDelay(500)) == 1;
        }

        @Override
        public boolean canContinueToUse() {
            return false;
        }

        @Override
        public void start() {
            this.panda.roll(true);
        }

        @Override
        public boolean isInterruptable() {
            return false;
        }
    }

    static class e
    extends PathfinderGoalHurtByTarget {
        private final EntityPanda panda;

        public e(EntityPanda var0, Class<?> ... var1) {
            super(var0, var1);
            this.panda = var0;
        }

        @Override
        public boolean canContinueToUse() {
            if (this.panda.gotBamboo || this.panda.didBite) {
                this.panda.setTarget(null);
                return false;
            }
            return super.canContinueToUse();
        }

        @Override
        protected void alertOther(EntityInsentient var0, EntityLiving var1) {
            if (var0 instanceof EntityPanda && ((EntityPanda)var0).isAggressive()) {
                var0.setTarget(var1);
            }
        }
    }
}

