/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village.poi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceRecord;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import org.slf4j.Logger;

public class VillagePlaceSection {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Short2ObjectMap<VillagePlaceRecord> records = new Short2ObjectOpenHashMap();
    private final Map<Holder<VillagePlaceType>, Set<VillagePlaceRecord>> byType = Maps.newHashMap();
    private final Runnable setDirty;
    private boolean isValid;

    public static Codec<VillagePlaceSection> codec(Runnable var0) {
        return RecordCodecBuilder.create(var1 -> var1.group((App)RecordCodecBuilder.point((Object)var0), (App)Codec.BOOL.optionalFieldOf("Valid", (Object)false).forGetter(var0 -> var0.isValid), (App)VillagePlaceRecord.codec(var0).listOf().fieldOf("Records").forGetter(var0 -> ImmutableList.copyOf((Collection)var0.records.values()))).apply((Applicative)var1, VillagePlaceSection::new)).orElseGet(SystemUtils.prefix("Failed to read POI section: ", arg_0 -> ((Logger)LOGGER).error(arg_0)), () -> new VillagePlaceSection(var0, false, (List<VillagePlaceRecord>)ImmutableList.of()));
    }

    public VillagePlaceSection(Runnable var0) {
        this(var0, true, (List<VillagePlaceRecord>)ImmutableList.of());
    }

    private VillagePlaceSection(Runnable var0, boolean var1, List<VillagePlaceRecord> var2) {
        this.setDirty = var0;
        this.isValid = var1;
        var2.forEach(this::add);
    }

    public Stream<VillagePlaceRecord> getRecords(Predicate<Holder<VillagePlaceType>> var02, VillagePlace.Occupancy var12) {
        return this.byType.entrySet().stream().filter(var1 -> var02.test((Holder)var1.getKey())).flatMap(var0 -> ((Set)var0.getValue()).stream()).filter(var12.getTest());
    }

    public void add(BlockPosition var02, Holder<VillagePlaceType> var1) {
        if (this.add(new VillagePlaceRecord(var02, var1, this.setDirty))) {
            LOGGER.debug("Added POI of type {} @ {}", (Object)var1.unwrapKey().map(var0 -> var0.location().toString()).orElse("[unregistered]"), (Object)var02);
            this.setDirty.run();
        }
    }

    private boolean add(VillagePlaceRecord var02) {
        BlockPosition var1 = var02.getPos();
        Holder<VillagePlaceType> var2 = var02.getPoiType();
        short var3 = SectionPosition.sectionRelativePos(var1);
        VillagePlaceRecord var4 = (VillagePlaceRecord)this.records.get(var3);
        if (var4 != null) {
            if (var2.equals(var4.getPoiType())) {
                return false;
            }
            SystemUtils.logAndPauseIfInIde("POI data mismatch: already registered at " + var1);
        }
        this.records.put(var3, (Object)var02);
        this.byType.computeIfAbsent(var2, var0 -> Sets.newHashSet()).add(var02);
        return true;
    }

    public void remove(BlockPosition var0) {
        VillagePlaceRecord var1 = (VillagePlaceRecord)this.records.remove(SectionPosition.sectionRelativePos(var0));
        if (var1 == null) {
            LOGGER.error("POI data mismatch: never registered at {}", (Object)var0);
            return;
        }
        this.byType.get(var1.getPoiType()).remove(var1);
        LOGGER.debug("Removed POI of type {} @ {}", LogUtils.defer(var1::getPoiType), LogUtils.defer(var1::getPos));
        this.setDirty.run();
    }

    @Deprecated
    @VisibleForDebug
    public int getFreeTickets(BlockPosition var0) {
        return this.getPoiRecord(var0).map(VillagePlaceRecord::getFreeTickets).orElse(0);
    }

    public boolean release(BlockPosition var0) {
        VillagePlaceRecord var1 = (VillagePlaceRecord)this.records.get(SectionPosition.sectionRelativePos(var0));
        if (var1 == null) {
            throw SystemUtils.pauseInIde(new IllegalStateException("POI never registered at " + var0));
        }
        boolean var2 = var1.releaseTicket();
        this.setDirty.run();
        return var2;
    }

    public boolean exists(BlockPosition var0, Predicate<Holder<VillagePlaceType>> var1) {
        return this.getType(var0).filter(var1).isPresent();
    }

    public Optional<Holder<VillagePlaceType>> getType(BlockPosition var0) {
        return this.getPoiRecord(var0).map(VillagePlaceRecord::getPoiType);
    }

    private Optional<VillagePlaceRecord> getPoiRecord(BlockPosition var0) {
        return Optional.ofNullable((VillagePlaceRecord)this.records.get(SectionPosition.sectionRelativePos(var0)));
    }

    public void refresh(Consumer<BiConsumer<BlockPosition, Holder<VillagePlaceType>>> var0) {
        if (!this.isValid) {
            Short2ObjectOpenHashMap var1 = new Short2ObjectOpenHashMap(this.records);
            this.clear();
            var0.accept((arg_0, arg_1) -> this.a((Short2ObjectMap)var1, arg_0, arg_1));
            this.isValid = true;
            this.setDirty.run();
        }
    }

    private void clear() {
        this.records.clear();
        this.byType.clear();
    }

    boolean isValid() {
        return this.isValid;
    }

    private /* synthetic */ void a(Short2ObjectMap var0, BlockPosition var1, Holder var22) {
        short var3 = SectionPosition.sectionRelativePos(var1);
        VillagePlaceRecord var4 = (VillagePlaceRecord)var0.computeIfAbsent(var3, var2 -> new VillagePlaceRecord(var1, var22, this.setDirty));
        this.add(var4);
    }
}

