/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.navigation;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.level.World;
import net.minecraft.world.level.pathfinder.PathEntity;

public class NavigationSpider
extends Navigation {
    @Nullable
    private BlockPosition pathToPosition;

    public NavigationSpider(EntityInsentient var0, World var1) {
        super(var0, var1);
    }

    @Override
    public PathEntity createPath(BlockPosition var0, int var1) {
        this.pathToPosition = var0;
        return super.createPath(var0, var1);
    }

    @Override
    public PathEntity createPath(Entity var0, int var1) {
        this.pathToPosition = var0.blockPosition();
        return super.createPath(var0, var1);
    }

    @Override
    public boolean moveTo(Entity var0, double var1) {
        PathEntity var3 = this.createPath(var0, 0);
        if (var3 != null) {
            return this.moveTo(var3, var1);
        }
        this.pathToPosition = var0.blockPosition();
        this.speedModifier = var1;
        return true;
    }

    @Override
    public void tick() {
        if (this.isDone()) {
            if (this.pathToPosition != null) {
                if (this.pathToPosition.closerToCenterThan(this.mob.position(), this.mob.getBbWidth()) || this.mob.getY() > (double)this.pathToPosition.getY() && new BlockPosition((double)this.pathToPosition.getX(), this.mob.getY(), (double)this.pathToPosition.getZ()).closerToCenterThan(this.mob.position(), this.mob.getBbWidth())) {
                    this.pathToPosition = null;
                } else {
                    this.mob.getMoveControl().setWantedPosition(this.pathToPosition.getX(), this.pathToPosition.getY(), this.pathToPosition.getZ(), this.speedModifier);
                }
            }
            return;
        }
        super.tick();
    }
}

