/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior.warden;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.phys.Vec3D;

public class SonicBoom
extends Behavior<Warden> {
    private static final int DISTANCE_XZ = 15;
    private static final int DISTANCE_Y = 20;
    private static final double KNOCKBACK_VERTICAL = 0.5;
    private static final double KNOCKBACK_HORIZONTAL = 2.5;
    public static final int COOLDOWN = 40;
    private static final int TICKS_BEFORE_PLAYING_SOUND = MathHelper.ceil(34.0);
    private static final int DURATION = MathHelper.ceil(60.0f);

    public SonicBoom() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.SONIC_BOOM_COOLDOWN, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.SONIC_BOOM_SOUND_COOLDOWN, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.SONIC_BOOM_SOUND_DELAY, (Object)((Object)MemoryStatus.REGISTERED)), DURATION);
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, Warden var1) {
        return var1.closerThan(var1.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get(), 15.0, 20.0);
    }

    @Override
    protected boolean canStillUse(WorldServer var0, Warden var1, long var2) {
        return true;
    }

    @Override
    protected void start(WorldServer var0, Warden var1, long var2) {
        var1.getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_COOLING_DOWN, true, DURATION);
        var1.getBrain().setMemoryWithExpiry(MemoryModuleType.SONIC_BOOM_SOUND_DELAY, Unit.INSTANCE, TICKS_BEFORE_PLAYING_SOUND);
        var0.broadcastEntityEvent(var1, (byte)62);
        var1.playSound(SoundEffects.WARDEN_SONIC_CHARGE, 3.0f, 1.0f);
    }

    @Override
    protected void tick(WorldServer var0, Warden var12, long var22) {
        var12.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).ifPresent(var1 -> var12.getLookControl().setLookAt(var1.position()));
        if (var12.getBrain().hasMemoryValue(MemoryModuleType.SONIC_BOOM_SOUND_DELAY) || var12.getBrain().hasMemoryValue(MemoryModuleType.SONIC_BOOM_SOUND_COOLDOWN)) {
            return;
        }
        var12.getBrain().setMemoryWithExpiry(MemoryModuleType.SONIC_BOOM_SOUND_COOLDOWN, Unit.INSTANCE, DURATION - TICKS_BEFORE_PLAYING_SOUND);
        var12.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).filter(var12::canTargetEntity).filter(var1 -> var12.closerThan((Entity)var1, 15.0, 20.0)).ifPresent(var2 -> {
            Vec3D var3 = var12.position().add(0.0, 1.6f, 0.0);
            Vec3D var4 = var2.getEyePosition().subtract(var3);
            Vec3D var5 = var4.normalize();
            for (int var6 = 1; var6 < MathHelper.floor(var4.length()) + 7; ++var6) {
                Vec3D var7 = var3.add(var5.scale(var6));
                var0.sendParticles(Particles.SONIC_BOOM, var7.x, var7.y, var7.z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            var12.playSound(SoundEffects.WARDEN_SONIC_BOOM, 3.0f, 1.0f);
            var2.hurt(DamageSource.sonicBoom(var12), 10.0f);
            double var6 = 0.5 * (1.0 - var2.getAttributeValue(GenericAttributes.KNOCKBACK_RESISTANCE));
            double var8 = 2.5 * (1.0 - var2.getAttributeValue(GenericAttributes.KNOCKBACK_RESISTANCE));
            var2.push(var5.x() * var8, var5.y() * var6, var5.z() * var8);
        });
    }

    @Override
    protected void stop(WorldServer var0, Warden var1, long var2) {
        SonicBoom.setCooldown(var1, 40);
    }

    public static void setCooldown(EntityLiving var0, int var1) {
        var0.getBrain().setMemoryWithExpiry(MemoryModuleType.SONIC_BOOM_COOLDOWN, Unit.INSTANCE, var1);
    }

    @Override
    protected /* synthetic */ boolean canStillUse(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        return this.canStillUse(worldServer, (Warden)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.stop(worldServer, (Warden)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void tick(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.tick(worldServer, (Warden)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (Warden)entityLiving, l2);
    }
}

