/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior.warden;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.monster.warden.WardenAi;

public class Roar
extends Behavior<Warden> {
    private static final int TICKS_BEFORE_PLAYING_ROAR_SOUND = 25;
    private static final int ROAR_ANGER_INCREASE = 20;

    public Roar() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ROAR_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.ROAR_SOUND_COOLDOWN, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.ROAR_SOUND_DELAY, (Object)((Object)MemoryStatus.REGISTERED)), WardenAi.ROAR_DURATION);
    }

    @Override
    protected void start(WorldServer var0, Warden var1, long var2) {
        BehaviorController<Warden> var4 = var1.getBrain();
        var4.setMemoryWithExpiry(MemoryModuleType.ROAR_SOUND_DELAY, Unit.INSTANCE, 25L);
        var4.eraseMemory(MemoryModuleType.WALK_TARGET);
        EntityLiving var5 = var1.getBrain().getMemory(MemoryModuleType.ROAR_TARGET).get();
        BehaviorUtil.lookAtEntity(var1, var5);
        var1.setPose(EntityPose.ROARING);
        var1.increaseAngerAt(var5, 20, false);
    }

    @Override
    protected boolean canStillUse(WorldServer var0, Warden var1, long var2) {
        return true;
    }

    @Override
    protected void tick(WorldServer var0, Warden var1, long var2) {
        if (var1.getBrain().hasMemoryValue(MemoryModuleType.ROAR_SOUND_DELAY) || var1.getBrain().hasMemoryValue(MemoryModuleType.ROAR_SOUND_COOLDOWN)) {
            return;
        }
        var1.getBrain().setMemoryWithExpiry(MemoryModuleType.ROAR_SOUND_COOLDOWN, Unit.INSTANCE, WardenAi.ROAR_DURATION - 25);
        var1.playSound(SoundEffects.WARDEN_ROAR, 3.0f, 1.0f);
    }

    @Override
    protected void stop(WorldServer var0, Warden var1, long var2) {
        if (var1.hasPose(EntityPose.ROARING)) {
            var1.setPose(EntityPose.STANDING);
        }
        var1.getBrain().getMemory(MemoryModuleType.ROAR_TARGET).ifPresent(var1::setAttackTarget);
        var1.getBrain().eraseMemory(MemoryModuleType.ROAR_TARGET);
    }

    @Override
    protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.stop(worldServer, (Warden)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void tick(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.tick(worldServer, (Warden)entityLiving, l2);
    }
}

