/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.FluidTypes;

public class TryLaySpawnOnWaterNearLand
extends Behavior<Frog> {
    private final Block spawnBlock;
    private final MemoryModuleType<?> memoryModule;

    public TryLaySpawnOnWaterNearLand(Block var0, MemoryModuleType<?> var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.IS_PREGNANT, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        this.spawnBlock = var0;
        this.memoryModule = var1;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, Frog var1) {
        return !var1.isInWater() && var1.isOnGround();
    }

    @Override
    protected void start(WorldServer var0, Frog var1, long var2) {
        BlockPosition var4 = var1.blockPosition().below();
        for (EnumDirection var6 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            BlockPosition var8;
            BlockPosition var7 = var4.relative(var6);
            if (!var0.getBlockState(var7).getCollisionShape(var0, var7).getFaceShape(EnumDirection.UP).isEmpty() || !var0.getFluidState(var7).is(FluidTypes.WATER) || !var0.getBlockState(var8 = var7.above()).isAir()) continue;
            var0.setBlock(var8, this.spawnBlock.defaultBlockState(), 3);
            var0.playSound(null, var1, SoundEffects.FROG_LAY_SPAWN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            var1.getBrain().eraseMemory(this.memoryModule);
            return;
        }
    }
}

