/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class TryFindLandNearWater
extends Behavior<EntityCreature> {
    private final int range;
    private final float speedModifier;
    private long nextOkStartTime;

    public TryFindLandNearWater(int var0, float var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED)));
        this.range = var0;
        this.speedModifier = var1;
    }

    @Override
    protected void stop(WorldServer var0, EntityCreature var1, long var2) {
        this.nextOkStartTime = var2 + 40L;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityCreature var1) {
        return !var1.level.getFluidState(var1.blockPosition()).is(TagsFluid.WATER);
    }

    @Override
    protected void start(WorldServer var0, EntityCreature var1, long var2) {
        if (var2 < this.nextOkStartTime) {
            return;
        }
        VoxelShapeCollision var4 = VoxelShapeCollision.of(var1);
        BlockPosition var5 = var1.blockPosition();
        BlockPosition.MutableBlockPosition var6 = new BlockPosition.MutableBlockPosition();
        for (BlockPosition var8 : BlockPosition.withinManhattan(var5, this.range, this.range, this.range)) {
            if (var8.getX() == var5.getX() && var8.getZ() == var5.getZ() || !var0.getBlockState(var8).getCollisionShape(var0, var8, var4).isEmpty() || var0.getBlockState(var6.setWithOffset((BaseBlockPosition)var8, EnumDirection.DOWN)).getCollisionShape(var0, var8, var4).isEmpty()) continue;
            for (EnumDirection var10 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                var6.setWithOffset((BaseBlockPosition)var8, var10);
                if (!var0.getBlockState(var6).isAir() || !var0.getBlockState(var6.move(EnumDirection.DOWN)).is(Blocks.WATER)) continue;
                this.nextOkStartTime = var2 + 40L;
                BehaviorUtil.setWalkAndLookTargetMemories((EntityLiving)var1, var8, this.speedModifier, 0);
                return;
            }
        }
    }

    @Override
    protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.stop(worldServer, (EntityCreature)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (EntityCreature)entityLiving, l2);
    }
}

