/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPosition;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class StayCloseToTarget<E extends EntityLiving>
extends Behavior<E> {
    private final Function<EntityLiving, Optional<BehaviorPosition>> targetPositionGetter;
    private final int closeEnough;
    private final int tooFar;
    private final float speedModifier;

    public StayCloseToTarget(Function<EntityLiving, Optional<BehaviorPosition>> var0, int var1, int var2, float var3) {
        super(Map.of(MemoryModuleType.WALK_TARGET, MemoryStatus.VALUE_ABSENT));
        this.targetPositionGetter = var0;
        this.closeEnough = var1;
        this.tooFar = var2;
        this.speedModifier = var3;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, E var1) {
        Optional<BehaviorPosition> var2 = this.targetPositionGetter.apply((EntityLiving)var1);
        if (var2.isEmpty()) {
            return false;
        }
        BehaviorPosition var3 = var2.get();
        return !((Entity)var1).position().closerThan(var3.currentPosition(), this.tooFar);
    }

    @Override
    protected void start(WorldServer var0, E var1, long var2) {
        BehaviorUtil.setWalkAndLookTargetMemories(var1, this.targetPositionGetter.apply((EntityLiving)var1).get(), this.speedModifier, this.closeEnough);
    }
}

