/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.util.RandomSource;

public class ShufflingList<U> {
    protected final List<a<U>> entries;
    private final RandomSource random = RandomSource.create();

    public ShufflingList() {
        this.entries = Lists.newArrayList();
    }

    private ShufflingList(List<a<U>> var0) {
        this.entries = Lists.newArrayList(var0);
    }

    public static <U> Codec<ShufflingList<U>> codec(Codec<U> var02) {
        return a.codec(var02).listOf().xmap(ShufflingList::new, var0 -> var0.entries);
    }

    public ShufflingList<U> add(U var0, int var1) {
        this.entries.add(new a<U>(var0, var1));
        return this;
    }

    public ShufflingList<U> shuffle() {
        this.entries.forEach(var0 -> var0.setRandom(this.random.nextFloat()));
        this.entries.sort(Comparator.comparingDouble(a::getRandWeight));
        return this;
    }

    public Stream<U> stream() {
        return this.entries.stream().map(a::getData);
    }

    public String toString() {
        return "ShufflingList[" + this.entries + "]";
    }

    public static class a<T> {
        final T data;
        final int weight;
        private double randWeight;

        a(T var0, int var1) {
            this.weight = var1;
            this.data = var0;
        }

        private double getRandWeight() {
            return this.randWeight;
        }

        void setRandom(float var0) {
            this.randWeight = -Math.pow(var0, 1.0f / (float)this.weight);
        }

        public T getData() {
            return this.data;
        }

        public int getWeight() {
            return this.weight;
        }

        public String toString() {
            return this.weight + ":" + this.data;
        }

        public static <E> Codec<a<E>> codec(final Codec<E> var0) {
            return new Codec<a<E>>(){

                public <T> DataResult<Pair<a<E>, T>> decode(DynamicOps<T> var02, T var12) {
                    Dynamic var2 = new Dynamic(var02, var12);
                    return var2.get("data").flatMap(arg_0 -> ((Codec)var0).parse(arg_0)).map(var1 -> new a<Object>(var1, var2.get("weight").asInt(1))).map(var1 -> Pair.of((Object)var1, (Object)var02.empty()));
                }

                public <T> DataResult<T> encode(a<E> var02, DynamicOps<T> var1, T var2) {
                    return var1.mapBuilder().add("weight", var1.createInt(var02.weight)).add("data", var0.encodeStart(var1, var02.data)).build(var2);
                }

                public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
                    return this.encode((a)object, dynamicOps, object2);
                }
            };
        }
    }
}

