/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPosition;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.allay.AllayAi;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;

public class GoAndGiveItemsToTarget<E extends EntityLiving>
extends Behavior<E> {
    private static final int CLOSE_ENOUGH_DISTANCE_TO_TARGET = 3;
    private static final int ITEM_PICKUP_COOLDOWN_AFTER_THROWING = 60;
    private final Function<EntityLiving, Optional<BehaviorPosition>> targetPositionGetter;
    private final float speedModifier;

    public GoAndGiveItemsToTarget(Function<EntityLiving, Optional<BehaviorPosition>> var0, float var1) {
        super(Map.of(MemoryModuleType.LOOK_TARGET, MemoryStatus.REGISTERED, MemoryModuleType.WALK_TARGET, MemoryStatus.REGISTERED, MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, MemoryStatus.REGISTERED));
        this.targetPositionGetter = var0;
        this.speedModifier = var1;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, E var1) {
        return this.canThrowItemToTarget(var1);
    }

    @Override
    protected boolean canStillUse(WorldServer var0, E var1, long var2) {
        return this.canThrowItemToTarget(var1);
    }

    @Override
    protected void start(WorldServer var0, E var12, long var2) {
        this.targetPositionGetter.apply((EntityLiving)var12).ifPresent(var1 -> BehaviorUtil.setWalkAndLookTargetMemories(var12, var1, this.speedModifier, 3));
    }

    @Override
    protected void tick(WorldServer var0, E var1, long var22) {
        ItemStack var8;
        Optional<BehaviorPosition> var4 = this.targetPositionGetter.apply((EntityLiving)var1);
        if (var4.isEmpty()) {
            return;
        }
        BehaviorPosition var5 = var4.get();
        double var6 = var5.currentPosition().distanceTo(((Entity)var1).getEyePosition());
        if (var6 < 3.0 && !(var8 = ((InventoryCarrier)var1).getInventory().removeItem(0, 1)).isEmpty()) {
            GoAndGiveItemsToTarget.throwItem(var1, var8, GoAndGiveItemsToTarget.getThrowPosition(var5));
            if (var1 instanceof Allay) {
                Allay var9 = (Allay)var1;
                AllayAi.getLikedPlayer(var9).ifPresent(var2 -> this.triggerDropItemOnBlock(var5, var8, (EntityPlayer)var2));
            }
            ((EntityLiving)var1).getBrain().setMemory(MemoryModuleType.ITEM_PICKUP_COOLDOWN_TICKS, 60);
        }
    }

    private void triggerDropItemOnBlock(BehaviorPosition var0, ItemStack var1, EntityPlayer var2) {
        BlockPosition var3 = var0.currentBlockPosition().below();
        CriterionTriggers.ALLAY_DROP_ITEM_ON_BLOCK.trigger(var2, var3, var1);
    }

    private boolean canThrowItemToTarget(E var0) {
        if (((InventoryCarrier)var0).getInventory().isEmpty()) {
            return false;
        }
        Optional<BehaviorPosition> var1 = this.targetPositionGetter.apply((EntityLiving)var0);
        return var1.isPresent();
    }

    private static Vec3D getThrowPosition(BehaviorPosition var0) {
        return var0.currentPosition().add(0.0, 1.0, 0.0);
    }

    public static void throwItem(EntityLiving var0, ItemStack var1, Vec3D var2) {
        Vec3D var3 = new Vec3D(0.2f, 0.3f, 0.2f);
        BehaviorUtil.throwItem(var0, var1, var2, var3, 0.2f);
        World var4 = var0.level;
        if (var4.getGameTime() % 7L == 0L && var4.random.nextDouble() < 0.9) {
            float var5 = SystemUtils.getRandom(Allay.THROW_SOUND_PITCHES, var4.getRandom()).floatValue();
            var4.playSound(null, var0, SoundEffects.ALLAY_THROW, SoundCategory.NEUTRAL, 1.0f, var5);
        }
    }
}

