/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorFindPosition;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.level.pathfinder.PathEntity;

public class BehaviorWalkHome
extends Behavior<EntityLiving> {
    private static final int CACHE_TIMEOUT = 40;
    private static final int BATCH_SIZE = 5;
    private static final int RATE = 20;
    private static final int OK_DISTANCE_SQR = 4;
    private final float speedModifier;
    private final Long2LongMap batchCache = new Long2LongOpenHashMap();
    private int triedCount;
    private long lastUpdate;

    public BehaviorWalkHome(float var0) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.HOME, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
        this.speedModifier = var0;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var02, EntityLiving var1) {
        if (var02.getGameTime() - this.lastUpdate < 20L) {
            return false;
        }
        EntityCreature var2 = (EntityCreature)var1;
        VillagePlace var3 = var02.getPoiManager();
        Optional<BlockPosition> var4 = var3.findClosest(var0 -> var0.is(PoiTypes.HOME), var1.blockPosition(), 48, VillagePlace.Occupancy.ANY);
        return var4.isPresent() && !(var4.get().distSqr(var2.blockPosition()) <= 4.0);
    }

    @Override
    protected void start(WorldServer var02, EntityLiving var1, long var2) {
        Predicate<BlockPosition> var6;
        this.triedCount = 0;
        this.lastUpdate = var02.getGameTime() + (long)var02.getRandom().nextInt(20);
        EntityCreature var4 = (EntityCreature)var1;
        VillagePlace var5 = var02.getPoiManager();
        Set<Pair<Holder<VillagePlaceType>, BlockPosition>> var7 = var5.findAllWithType(var0 -> var0.is(PoiTypes.HOME), var6 = var0 -> {
            long var1 = var0.asLong();
            if (this.batchCache.containsKey(var1)) {
                return false;
            }
            if (++this.triedCount >= 5) {
                return false;
            }
            this.batchCache.put(var1, this.lastUpdate + 40L);
            return true;
        }, var1.blockPosition(), 48, VillagePlace.Occupancy.ANY).collect(Collectors.toSet());
        PathEntity var8 = BehaviorFindPosition.findPathToPois(var4, var7);
        if (var8 != null && var8.canReach()) {
            BlockPosition var9 = var8.getTarget();
            Optional<Holder<VillagePlaceType>> var10 = var5.getType(var9);
            if (var10.isPresent()) {
                var1.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(var9, this.speedModifier, 1));
                PacketDebug.sendPoiTicketCountPacket(var02, var9);
            }
        } else if (this.triedCount < 5) {
            this.batchCache.long2LongEntrySet().removeIf(var0 -> var0.getLongValue() < this.lastUpdate);
        }
    }
}

