/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3D;

public class BehaviorStrollRandomUnconstrained
extends Behavior<EntityCreature> {
    private static final int MAX_XZ_DIST = 10;
    private static final int MAX_Y_DIST = 7;
    private final float speedModifier;
    protected final int maxHorizontalDistance;
    protected final int maxVerticalDistance;
    private final boolean mayStrollFromWater;

    public BehaviorStrollRandomUnconstrained(float var0) {
        this(var0, true);
    }

    public BehaviorStrollRandomUnconstrained(float var0, boolean var1) {
        this(var0, 10, 7, var1);
    }

    public BehaviorStrollRandomUnconstrained(float var0, int var1, int var2) {
        this(var0, var1, var2, true);
    }

    public BehaviorStrollRandomUnconstrained(float var0, int var1, int var2, boolean var3) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)));
        this.speedModifier = var0;
        this.maxHorizontalDistance = var1;
        this.maxVerticalDistance = var2;
        this.mayStrollFromWater = var3;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityCreature var1) {
        return this.mayStrollFromWater || !var1.isInWaterOrBubble();
    }

    @Override
    protected void start(WorldServer var02, EntityCreature var1, long var2) {
        Optional<Vec3D> var4 = Optional.ofNullable(this.getTargetPos(var1));
        var1.getBrain().setMemory(MemoryModuleType.WALK_TARGET, var4.map(var0 -> new MemoryTarget((Vec3D)var0, this.speedModifier, 0)));
    }

    @Nullable
    protected Vec3D getTargetPos(EntityCreature var0) {
        return LandRandomPos.getPos(var0, this.maxHorizontalDistance, this.maxVerticalDistance);
    }
}

