/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.schedule.Activity;

public class BehaviorPotentialJobSite
extends Behavior<EntityVillager> {
    private static final int TICKS_UNTIL_TIMEOUT = 1200;
    final float speedModifier;

    public BehaviorPotentialJobSite(float var0) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.POTENTIAL_JOB_SITE, (Object)((Object)MemoryStatus.VALUE_PRESENT)), 1200);
        this.speedModifier = var0;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var02, EntityVillager var1) {
        return var1.getBrain().getActiveNonCoreActivity().map(var0 -> var0 == Activity.IDLE || var0 == Activity.WORK || var0 == Activity.PLAY).orElse(true);
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityVillager var1, long var2) {
        return var1.getBrain().hasMemoryValue(MemoryModuleType.POTENTIAL_JOB_SITE);
    }

    @Override
    protected void tick(WorldServer var0, EntityVillager var1, long var2) {
        BehaviorUtil.setWalkAndLookTargetMemories((EntityLiving)var1, var1.getBrain().getMemory(MemoryModuleType.POTENTIAL_JOB_SITE).get().pos(), this.speedModifier, 1);
    }

    @Override
    protected void stop(WorldServer var0, EntityVillager var12, long var2) {
        Optional<GlobalPos> var4 = var12.getBrain().getMemory(MemoryModuleType.POTENTIAL_JOB_SITE);
        var4.ifPresent(var1 -> {
            BlockPosition var2 = var1.pos();
            WorldServer var3 = var0.getServer().getLevel(var1.dimension());
            if (var3 == null) {
                return;
            }
            VillagePlace var4 = var3.getPoiManager();
            if (var4.exists(var2, var0 -> true)) {
                var4.release(var2);
            }
            PacketDebug.sendPoiTicketCountPacket(var0, var2);
        });
        var12.getBrain().eraseMemory(MemoryModuleType.POTENTIAL_JOB_SITE);
    }

    @Override
    protected /* synthetic */ boolean canStillUse(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        return this.canStillUse(worldServer, (EntityVillager)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void tick(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.tick(worldServer, (EntityVillager)entityLiving, l2);
    }
}

