/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.level.pathfinder.PathEntity;

public class BehaviorFindPosition
extends Behavior<EntityCreature> {
    private static final int BATCH_SIZE = 5;
    private static final int RATE = 20;
    public static final int SCAN_RANGE = 48;
    private final Predicate<Holder<VillagePlaceType>> poiType;
    private final MemoryModuleType<GlobalPos> memoryToAcquire;
    private final boolean onlyIfAdult;
    private final Optional<Byte> onPoiAcquisitionEvent;
    private long nextScheduledStart;
    private final Long2ObjectMap<a> batchCache = new Long2ObjectOpenHashMap();

    public BehaviorFindPosition(Predicate<Holder<VillagePlaceType>> var0, MemoryModuleType<GlobalPos> var1, MemoryModuleType<GlobalPos> var2, boolean var3, Optional<Byte> var4) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)BehaviorFindPosition.constructEntryConditionMap(var1, var2));
        this.poiType = var0;
        this.memoryToAcquire = var2;
        this.onlyIfAdult = var3;
        this.onPoiAcquisitionEvent = var4;
    }

    public BehaviorFindPosition(Predicate<Holder<VillagePlaceType>> var0, MemoryModuleType<GlobalPos> var1, boolean var2, Optional<Byte> var3) {
        this(var0, var1, var1, var2, var3);
    }

    private static ImmutableMap<MemoryModuleType<?>, MemoryStatus> constructEntryConditionMap(MemoryModuleType<GlobalPos> var0, MemoryModuleType<GlobalPos> var1) {
        ImmutableMap.Builder var2 = ImmutableMap.builder();
        var2.put(var0, (Object)MemoryStatus.VALUE_ABSENT);
        if (var1 != var0) {
            var2.put(var1, (Object)MemoryStatus.VALUE_ABSENT);
        }
        return var2.build();
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityCreature var1) {
        if (this.onlyIfAdult && var1.isBaby()) {
            return false;
        }
        if (this.nextScheduledStart == 0L) {
            this.nextScheduledStart = var1.level.getGameTime() + (long)var0.random.nextInt(20);
            return false;
        }
        return var0.getGameTime() >= this.nextScheduledStart;
    }

    @Override
    protected void start(WorldServer var0, EntityCreature var1, long var22) {
        this.nextScheduledStart = var22 + 20L + (long)var0.getRandom().nextInt(20);
        VillagePlace var42 = var0.getPoiManager();
        this.batchCache.long2ObjectEntrySet().removeIf(var2 -> !((a)var2.getValue()).isStillValid(var22));
        Predicate<BlockPosition> var5 = var2 -> {
            a var3 = (a)this.batchCache.get(var2.asLong());
            if (var3 == null) {
                return true;
            }
            if (!var3.shouldRetry(var22)) {
                return false;
            }
            var3.markAttempt(var22);
            return true;
        };
        Set<Pair<Holder<VillagePlaceType>, BlockPosition>> var6 = var42.findAllClosestFirstWithType(this.poiType, var5, var1.blockPosition(), 48, VillagePlace.Occupancy.HAS_SPACE).limit(5L).collect(Collectors.toSet());
        PathEntity var7 = BehaviorFindPosition.findPathToPois(var1, var6);
        if (var7 != null && var7.canReach()) {
            BlockPosition var8 = var7.getTarget();
            var42.getType(var8).ifPresent(var4 -> {
                var42.take(this.poiType, (var1, var2) -> var2.equals(var8), var8, 1);
                var1.getBrain().setMemory(this.memoryToAcquire, GlobalPos.of(var0.dimension(), var8));
                this.onPoiAcquisitionEvent.ifPresent(var2 -> var0.broadcastEntityEvent(var1, (byte)var2));
                this.batchCache.clear();
                PacketDebug.sendPoiTicketCountPacket(var0, var8);
            });
        } else {
            for (Pair<Holder<VillagePlaceType>, BlockPosition> var9 : var6) {
                this.batchCache.computeIfAbsent(((BlockPosition)var9.getSecond()).asLong(), var3 -> new a(var0.level.random, var22));
            }
        }
    }

    @Nullable
    public static PathEntity findPathToPois(EntityInsentient var0, Set<Pair<Holder<VillagePlaceType>, BlockPosition>> var1) {
        if (var1.isEmpty()) {
            return null;
        }
        HashSet<BlockPosition> var2 = new HashSet<BlockPosition>();
        int var3 = 1;
        for (Pair<Holder<VillagePlaceType>, BlockPosition> var5 : var1) {
            var3 = Math.max(var3, ((VillagePlaceType)((Holder)var5.getFirst()).value()).validRange());
            var2.add((BlockPosition)var5.getSecond());
        }
        return var0.getNavigation().createPath(var2, var3);
    }

    static class a {
        private static final int MIN_INTERVAL_INCREASE = 40;
        private static final int MAX_INTERVAL_INCREASE = 80;
        private static final int MAX_RETRY_PATHFINDING_INTERVAL = 400;
        private final RandomSource random;
        private long previousAttemptTimestamp;
        private long nextScheduledAttemptTimestamp;
        private int currentDelay;

        a(RandomSource var0, long var1) {
            this.random = var0;
            this.markAttempt(var1);
        }

        public void markAttempt(long var0) {
            this.previousAttemptTimestamp = var0;
            int var2 = this.currentDelay + this.random.nextInt(40) + 40;
            this.currentDelay = Math.min(var2, 400);
            this.nextScheduledAttemptTimestamp = var0 + (long)this.currentDelay;
        }

        public boolean isStillValid(long var0) {
            return var0 - this.previousAttemptTimestamp < 400L;
        }

        public boolean shouldRetry(long var0) {
            return var0 >= this.nextScheduledAttemptTimestamp;
        }

        public String toString() {
            return "RetryMarker{, previousAttemptAt=" + this.previousAttemptTimestamp + ", nextScheduledAttemptAt=" + this.nextScheduledAttemptTimestamp + ", currentDelay=" + this.currentDelay + "}";
        }
    }
}

