/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPanic;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.EntityVillager;

public class BehaviorCooldown
extends Behavior<EntityVillager> {
    private static final int SAFE_DISTANCE_FROM_DANGER = 36;

    public BehaviorCooldown() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of());
    }

    @Override
    protected void start(WorldServer var0, EntityVillager var1, long var2) {
        boolean var4;
        boolean bl = var4 = BehaviorPanic.isHurt(var1) || BehaviorPanic.hasHostile(var1) || BehaviorCooldown.isCloseToEntityThatHurtMe(var1);
        if (!var4) {
            var1.getBrain().eraseMemory(MemoryModuleType.HURT_BY);
            var1.getBrain().eraseMemory(MemoryModuleType.HURT_BY_ENTITY);
            var1.getBrain().updateActivityFromSchedule(var0.getDayTime(), var0.getGameTime());
        }
    }

    private static boolean isCloseToEntityThatHurtMe(EntityVillager var0) {
        return var0.getBrain().getMemory(MemoryModuleType.HURT_BY_ENTITY).filter(var1 -> var1.distanceToSqr(var0) <= 36.0).isPresent();
    }
}

