/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerProfession;

public class BehaviorBetterJob
extends Behavior<EntityVillager> {
    final VillagerProfession profession;

    public BehaviorBetterJob(VillagerProfession var0) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.JOB_SITE, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
        this.profession = var0;
    }

    @Override
    protected void start(WorldServer var0, EntityVillager var1, long var2) {
        GlobalPos var4 = var1.getBrain().getMemory(MemoryModuleType.JOB_SITE).get();
        var0.getPoiManager().getType(var4.pos()).ifPresent(var22 -> BehaviorUtil.getNearbyVillagersWithCondition(var1, var2 -> this.competesForSameJobsite(var4, (Holder<VillagePlaceType>)var22, (EntityVillager)var2)).reduce(var1, BehaviorBetterJob::selectWinner));
    }

    private static EntityVillager selectWinner(EntityVillager var0, EntityVillager var1) {
        EntityVillager var3;
        EntityVillager var2;
        if (var0.getVillagerXp() > var1.getVillagerXp()) {
            var2 = var0;
            var3 = var1;
        } else {
            var2 = var1;
            var3 = var0;
        }
        var3.getBrain().eraseMemory(MemoryModuleType.JOB_SITE);
        return var2;
    }

    private boolean competesForSameJobsite(GlobalPos var0, Holder<VillagePlaceType> var1, EntityVillager var2) {
        return this.hasJobSite(var2) && var0.equals(var2.getBrain().getMemory(MemoryModuleType.JOB_SITE).get()) && this.hasMatchingProfession(var1, var2.getVillagerData().getProfession());
    }

    private boolean hasMatchingProfession(Holder<VillagePlaceType> var0, VillagerProfession var1) {
        return var1.heldJobSite().test(var0);
    }

    private boolean hasJobSite(EntityVillager var0) {
        return var0.getBrain().getMemory(MemoryModuleType.JOB_SITE).isPresent();
    }
}

