/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import org.slf4j.Logger;

public class AttributeMapBase {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<AttributeBase, AttributeModifiable> attributes = Maps.newHashMap();
    private final Set<AttributeModifiable> dirtyAttributes = Sets.newHashSet();
    private final AttributeProvider supplier;

    public AttributeMapBase(AttributeProvider var0) {
        this.supplier = var0;
    }

    private void onAttributeModified(AttributeModifiable var0) {
        if (var0.getAttribute().isClientSyncable()) {
            this.dirtyAttributes.add(var0);
        }
    }

    public Set<AttributeModifiable> getDirtyAttributes() {
        return this.dirtyAttributes;
    }

    public Collection<AttributeModifiable> getSyncableAttributes() {
        return this.attributes.values().stream().filter(var0 -> var0.getAttribute().isClientSyncable()).collect(Collectors.toList());
    }

    @Nullable
    public AttributeModifiable getInstance(AttributeBase var02) {
        return this.attributes.computeIfAbsent(var02, var0 -> this.supplier.createInstance(this::onAttributeModified, (AttributeBase)var0));
    }

    public boolean hasAttribute(AttributeBase var0) {
        return this.attributes.get(var0) != null || this.supplier.hasAttribute(var0);
    }

    public boolean hasModifier(AttributeBase var0, UUID var1) {
        AttributeModifiable var2 = this.attributes.get(var0);
        return var2 != null ? var2.getModifier(var1) != null : this.supplier.hasModifier(var0, var1);
    }

    public double getValue(AttributeBase var0) {
        AttributeModifiable var1 = this.attributes.get(var0);
        return var1 != null ? var1.getValue() : this.supplier.getValue(var0);
    }

    public double getBaseValue(AttributeBase var0) {
        AttributeModifiable var1 = this.attributes.get(var0);
        return var1 != null ? var1.getBaseValue() : this.supplier.getBaseValue(var0);
    }

    public double getModifierValue(AttributeBase var0, UUID var1) {
        AttributeModifiable var2 = this.attributes.get(var0);
        return var2 != null ? var2.getModifier(var1).getAmount() : this.supplier.getModifierValue(var0, var1);
    }

    public void removeAttributeModifiers(Multimap<AttributeBase, AttributeModifier> var02) {
        var02.asMap().forEach((var0, var1) -> {
            AttributeModifiable var2 = this.attributes.get(var0);
            if (var2 != null) {
                var1.forEach(var2::removeModifier);
            }
        });
    }

    public void addTransientAttributeModifiers(Multimap<AttributeBase, AttributeModifier> var02) {
        var02.forEach((var0, var1) -> {
            AttributeModifiable var2 = this.getInstance((AttributeBase)var0);
            if (var2 != null) {
                var2.removeModifier((AttributeModifier)var1);
                var2.addTransientModifier((AttributeModifier)var1);
            }
        });
    }

    public void assignValues(AttributeMapBase var02) {
        var02.attributes.values().forEach(var0 -> {
            AttributeModifiable var1 = this.getInstance(var0.getAttribute());
            if (var1 != null) {
                var1.replaceFrom((AttributeModifiable)var0);
            }
        });
    }

    public NBTTagList save() {
        NBTTagList var0 = new NBTTagList();
        for (AttributeModifiable var2 : this.attributes.values()) {
            var0.add(var2.save());
        }
        return var0;
    }

    public void load(NBTTagList var0) {
        for (int var12 = 0; var12 < var0.size(); ++var12) {
            NBTTagCompound var2 = var0.getCompound(var12);
            String var3 = var2.getString("Name");
            SystemUtils.ifElse(IRegistry.ATTRIBUTE.getOptional(MinecraftKey.tryParse(var3)), var1 -> {
                AttributeModifiable var2 = this.getInstance((AttributeBase)var1);
                if (var2 != null) {
                    var2.load(var2);
                }
            }, () -> LOGGER.warn("Ignoring unknown attribute '{}'", (Object)var3));
        }
    }
}

