/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.phys.Vec3D;

public interface ISteerable {
    public boolean boost();

    public void travelWithInput(Vec3D var1);

    public float getSteeringSpeed();

    default public boolean travel(EntityInsentient var0, SaddleStorage var1, Vec3D var2) {
        if (!var0.isAlive()) {
            return false;
        }
        Entity var3 = var0.getControllingPassenger();
        if (!var0.isVehicle() || !(var3 instanceof EntityHuman)) {
            var0.maxUpStep = 0.5f;
            var0.flyingSpeed = 0.02f;
            this.travelWithInput(var2);
            return false;
        }
        var0.setYRot(var3.getYRot());
        var0.yRotO = var0.getYRot();
        var0.setXRot(var3.getXRot() * 0.5f);
        var0.setRot(var0.getYRot(), var0.getXRot());
        var0.yBodyRot = var0.getYRot();
        var0.yHeadRot = var0.getYRot();
        var0.maxUpStep = 1.0f;
        var0.flyingSpeed = var0.getSpeed() * 0.1f;
        if (var1.boosting && var1.boostTime++ > var1.boostTimeTotal) {
            var1.boosting = false;
        }
        if (var0.isControlledByLocalInstance()) {
            float var4 = this.getSteeringSpeed();
            if (var1.boosting) {
                var4 += var4 * 1.15f * MathHelper.sin((float)var1.boostTime / (float)var1.boostTimeTotal * (float)Math.PI);
            }
            var0.setSpeed(var4);
            this.travelWithInput(new Vec3D(0.0, 0.0, 1.0));
            var0.lerpSteps = 0;
        } else {
            var0.calculateEntityAnimation(var0, false);
            var0.setDeltaMovement(Vec3D.ZERO);
        }
        var0.tryCheckInsideBlocks();
        return true;
    }
}

