/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.UtilColor;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.phys.Vec3D;

public final class MobEffectUtil {
    public static String formatDuration(MobEffect var0, float var1) {
        if (var0.isNoCounter()) {
            return "**:**";
        }
        int var2 = MathHelper.floor((float)var0.getDuration() * var1);
        return UtilColor.formatTickDuration(var2);
    }

    public static boolean hasDigSpeed(EntityLiving var0) {
        return var0.hasEffect(MobEffects.DIG_SPEED) || var0.hasEffect(MobEffects.CONDUIT_POWER);
    }

    public static int getDigSpeedAmplification(EntityLiving var0) {
        int var1 = 0;
        int var2 = 0;
        if (var0.hasEffect(MobEffects.DIG_SPEED)) {
            var1 = var0.getEffect(MobEffects.DIG_SPEED).getAmplifier();
        }
        if (var0.hasEffect(MobEffects.CONDUIT_POWER)) {
            var2 = var0.getEffect(MobEffects.CONDUIT_POWER).getAmplifier();
        }
        return Math.max(var1, var2);
    }

    public static boolean hasWaterBreathing(EntityLiving var0) {
        return var0.hasEffect(MobEffects.WATER_BREATHING) || var0.hasEffect(MobEffects.CONDUIT_POWER);
    }

    public static List<EntityPlayer> addEffectToPlayersAround(WorldServer var0, @Nullable Entity var1, Vec3D var22, double var3, MobEffect var5, int var6) {
        MobEffectList var72 = var5.getEffect();
        List<EntityPlayer> var8 = var0.getPlayers(var7 -> !(!var7.gameMode.isSurvival() || var1 != null && var1.isAlliedTo((Entity)var7) || !var22.closerThan(var7.position(), var3) || var7.hasEffect(var72) && var7.getEffect(var72).getAmplifier() >= var5.getAmplifier() && var7.getEffect(var72).getDuration() >= var6));
        var8.forEach(var2 -> var2.addEffect(new MobEffect(var5), var1));
        return var8;
    }
}

