/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.thread;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.util.profiling.metrics.MetricSampler;
import net.minecraft.util.profiling.metrics.MetricsRegistry;
import net.minecraft.util.profiling.metrics.ProfilerMeasured;
import net.minecraft.util.thread.Mailbox;
import org.slf4j.Logger;

public abstract class IAsyncTaskHandler<R extends Runnable>
implements ProfilerMeasured,
Mailbox<R>,
Executor {
    private final String name;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Queue<R> pendingRunnables = Queues.newConcurrentLinkedQueue();
    private int blockingCount;

    protected IAsyncTaskHandler(String var0) {
        this.name = var0;
        MetricsRegistry.INSTANCE.add(this);
    }

    protected abstract R wrapRunnable(Runnable var1);

    protected abstract boolean shouldRun(R var1);

    public boolean isSameThread() {
        return Thread.currentThread() == this.getRunningThread();
    }

    protected abstract Thread getRunningThread();

    protected boolean scheduleExecutables() {
        return !this.isSameThread();
    }

    public int getPendingTasksCount() {
        return this.pendingRunnables.size();
    }

    @Override
    public String name() {
        return this.name;
    }

    public <V> CompletableFuture<V> submit(Supplier<V> var0) {
        if (this.scheduleExecutables()) {
            return CompletableFuture.supplyAsync(var0, this);
        }
        return CompletableFuture.completedFuture(var0.get());
    }

    private CompletableFuture<Void> submitAsync(Runnable var0) {
        return CompletableFuture.supplyAsync(() -> {
            var0.run();
            return null;
        }, this);
    }

    public CompletableFuture<Void> submit(Runnable var0) {
        if (this.scheduleExecutables()) {
            return this.submitAsync(var0);
        }
        var0.run();
        return CompletableFuture.completedFuture(null);
    }

    public void executeBlocking(Runnable var0) {
        if (!this.isSameThread()) {
            this.submitAsync(var0).join();
        } else {
            var0.run();
        }
    }

    @Override
    public void tell(R var0) {
        this.pendingRunnables.add(var0);
        LockSupport.unpark(this.getRunningThread());
    }

    @Override
    public void execute(Runnable var0) {
        if (this.scheduleExecutables()) {
            this.tell(this.wrapRunnable(var0));
        } else {
            var0.run();
        }
    }

    public void executeIfPossible(Runnable var0) {
        this.execute(var0);
    }

    protected void dropAllTasks() {
        this.pendingRunnables.clear();
    }

    protected void runAllTasks() {
        while (this.pollTask()) {
        }
    }

    public boolean pollTask() {
        Runnable var0 = (Runnable)this.pendingRunnables.peek();
        if (var0 == null) {
            return false;
        }
        if (this.blockingCount == 0 && !this.shouldRun(var0)) {
            return false;
        }
        this.doRunTask((Runnable)this.pendingRunnables.remove());
        return true;
    }

    public void managedBlock(BooleanSupplier var0) {
        ++this.blockingCount;
        try {
            while (!var0.getAsBoolean()) {
                if (this.pollTask()) continue;
                this.waitForTasks();
            }
        }
        finally {
            --this.blockingCount;
        }
    }

    protected void waitForTasks() {
        Thread.yield();
        LockSupport.parkNanos("waiting for tasks", 100000L);
    }

    protected void doRunTask(R var0) {
        try {
            var0.run();
        }
        catch (Exception var1) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Error executing task on {}", (Object)this.name(), (Object)var1);
        }
    }

    @Override
    public List<MetricSampler> profiledMetrics() {
        return ImmutableList.of((Object)MetricSampler.create(this.name + "-pending-tasks", MetricCategory.EVENT_LOOPS, this::getPendingTasksCount));
    }

    @Override
    public /* synthetic */ void tell(Object object) {
        this.tell((R)((Runnable)object));
    }
}

