/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterBedBlock
extends DataFix {
    public DataConverterBedBlock(Schema var0, boolean var1) {
        super(var0, var1);
    }

    public TypeRewriteRule makeRule() {
        Type var0 = this.getOutputSchema().getType(DataConverterTypes.CHUNK);
        Type var1 = var0.findFieldType("Level");
        Type var2 = var1.findFieldType("TileEntities");
        if (!(var2 instanceof List.ListType)) {
            throw new IllegalStateException("Tile entity type is not a list type.");
        }
        List.ListType var3 = (List.ListType)var2;
        return this.cap(var1, var3);
    }

    private <TE> TypeRewriteRule cap(Type<?> var0, List.ListType<TE> var1) {
        Type var2 = var1.getElement();
        OpticFinder var32 = DSL.fieldFinder((String)"Level", var0);
        OpticFinder var4 = DSL.fieldFinder((String)"TileEntities", var1);
        int var5 = 416;
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhere("InjectBedBlockEntityType", (Type)this.getInputSchema().findChoiceType(DataConverterTypes.BLOCK_ENTITY), (Type)this.getOutputSchema().findChoiceType(DataConverterTypes.BLOCK_ENTITY), var02 -> var0 -> var0), (TypeRewriteRule)this.fixTypeEverywhereTyped("BedBlockEntityInjecter", this.getOutputSchema().getType(DataConverterTypes.CHUNK), var3 -> {
            Typed var4 = var3.getTyped(var32);
            Dynamic var5 = (Dynamic)var4.get(DSL.remainderFinder());
            int var6 = var5.get("xPos").asInt(0);
            int var7 = var5.get("zPos").asInt(0);
            ArrayList var8 = Lists.newArrayList((Iterable)((Iterable)var4.getOrCreate(var4)));
            List var9 = var5.get("Sections").asList(Function.identity());
            for (int var10 = 0; var10 < var9.size(); ++var10) {
                Dynamic var11 = (Dynamic)var9.get(var10);
                int var12 = var11.get("Y").asInt(0);
                Stream<Integer> var13 = var11.get("Blocks").asStream().map(var0 -> var0.asInt(0));
                int var14 = 0;
                Iterator iterator = ((Iterable)var13::iterator).iterator();
                while (iterator.hasNext()) {
                    int var16 = (Integer)iterator.next();
                    if (416 == (var16 & 0xFF) << 4) {
                        int var17 = var14 & 0xF;
                        int var18 = var14 >> 8 & 0xF;
                        int var19 = var14 >> 4 & 0xF;
                        HashMap var20 = Maps.newHashMap();
                        var20.put(var11.createString("id"), var11.createString("minecraft:bed"));
                        var20.put(var11.createString("x"), var11.createInt(var17 + (var6 << 4)));
                        var20.put(var11.createString("y"), var11.createInt(var18 + (var12 << 4)));
                        var20.put(var11.createString("z"), var11.createInt(var19 + (var7 << 4)));
                        var20.put(var11.createString("color"), var11.createShort((short)14));
                        var8.add(((Pair)var2.read(var11.createMap((Map)var20)).result().orElseThrow(() -> new IllegalStateException("Could not parse newly created bed block entity."))).getFirst());
                    }
                    ++var14;
                }
            }
            if (!var8.isEmpty()) {
                return var3.set(var32, var4.set(var4, (Object)var8));
            }
            return var3;
        }));
    }
}

