/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import io.netty.util.internal.ThreadLocalRandom;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.levelgen.ThreadSafeLegacyRandomSource;

public interface RandomSource {
    @Deprecated
    public static final double GAUSSIAN_SPREAD_FACTOR = 2.297;

    public static RandomSource create() {
        return RandomSource.create(RandomSupport.generateUniqueSeed());
    }

    @Deprecated
    public static RandomSource createThreadSafe() {
        return new ThreadSafeLegacyRandomSource(RandomSupport.generateUniqueSeed());
    }

    public static RandomSource create(long var0) {
        return new LegacyRandomSource(var0);
    }

    public static RandomSource createNewThreadLocalInstance() {
        return new SingleThreadedRandomSource(ThreadLocalRandom.current().nextLong());
    }

    public RandomSource fork();

    public PositionalRandomFactory forkPositional();

    public void setSeed(long var1);

    public int nextInt();

    public int nextInt(int var1);

    default public int nextIntBetweenInclusive(int var0, int var1) {
        return this.nextInt(var1 - var0 + 1) + var0;
    }

    public long nextLong();

    public boolean nextBoolean();

    public float nextFloat();

    public double nextDouble();

    public double nextGaussian();

    default public double triangle(double var0, double var2) {
        return var0 + var2 * (this.nextDouble() - this.nextDouble());
    }

    default public void consumeCount(int var0) {
        for (int var1 = 0; var1 < var0; ++var1) {
            this.nextInt();
        }
    }

    default public int nextInt(int var0, int var1) {
        if (var0 >= var1) {
            throw new IllegalArgumentException("bound - origin is non positive");
        }
        return var0 + this.nextInt(var1 - var0);
    }
}

