/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.primitives.Longs;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.util.CryptographyException;

public class MinecraftEncryption {
    private static final String SYMMETRIC_ALGORITHM = "AES";
    private static final int SYMMETRIC_BITS = 128;
    private static final String ASYMMETRIC_ALGORITHM = "RSA";
    private static final int ASYMMETRIC_BITS = 1024;
    private static final String BYTE_ENCODING = "ISO_8859_1";
    private static final String HASH_ALGORITHM = "SHA-1";
    public static final String SIGNING_ALGORITHM = "SHA256withRSA";
    private static final String PEM_RSA_PRIVATE_KEY_HEADER = "-----BEGIN RSA PRIVATE KEY-----";
    private static final String PEM_RSA_PRIVATE_KEY_FOOTER = "-----END RSA PRIVATE KEY-----";
    public static final String RSA_PUBLIC_KEY_HEADER = "-----BEGIN RSA PUBLIC KEY-----";
    private static final String RSA_PUBLIC_KEY_FOOTER = "-----END RSA PUBLIC KEY-----";
    public static final String MIME_LINE_SEPARATOR = "\n";
    public static final Base64.Encoder MIME_ENCODER = Base64.getMimeEncoder(76, "\n".getBytes(StandardCharsets.UTF_8));
    public static final Codec<PublicKey> PUBLIC_KEY_CODEC = Codec.STRING.comapFlatMap(var0 -> {
        try {
            return DataResult.success((Object)MinecraftEncryption.stringToRsaPublicKey(var0));
        }
        catch (CryptographyException var1) {
            return DataResult.error((String)var1.getMessage());
        }
    }, MinecraftEncryption::rsaPublicKeyToString);
    public static final Codec<PrivateKey> PRIVATE_KEY_CODEC = Codec.STRING.comapFlatMap(var0 -> {
        try {
            return DataResult.success((Object)MinecraftEncryption.stringToPemRsaPrivateKey(var0));
        }
        catch (CryptographyException var1) {
            return DataResult.error((String)var1.getMessage());
        }
    }, MinecraftEncryption::pemRsaPrivateKeyToString);

    public static SecretKey generateSecretKey() throws CryptographyException {
        try {
            KeyGenerator var0 = KeyGenerator.getInstance(SYMMETRIC_ALGORITHM);
            var0.init(128);
            return var0.generateKey();
        }
        catch (Exception var0) {
            throw new CryptographyException(var0);
        }
    }

    public static KeyPair generateKeyPair() throws CryptographyException {
        try {
            KeyPairGenerator var0 = KeyPairGenerator.getInstance(ASYMMETRIC_ALGORITHM);
            var0.initialize(1024);
            return var0.generateKeyPair();
        }
        catch (Exception var0) {
            throw new CryptographyException(var0);
        }
    }

    public static byte[] digestData(String var0, PublicKey var1, SecretKey var2) throws CryptographyException {
        try {
            return MinecraftEncryption.digestData(var0.getBytes(BYTE_ENCODING), var2.getEncoded(), var1.getEncoded());
        }
        catch (Exception var3) {
            throw new CryptographyException(var3);
        }
    }

    private static byte[] digestData(byte[] ... var0) throws Exception {
        MessageDigest var1 = MessageDigest.getInstance(HASH_ALGORITHM);
        for (byte[] var5 : var0) {
            var1.update(var5);
        }
        return var1.digest();
    }

    private static <T extends Key> T rsaStringToKey(String var0, String var1, String var2, a<T> var3) throws CryptographyException {
        int var4 = var0.indexOf(var1);
        if (var4 != -1) {
            int var5 = var0.indexOf(var2, var4 += var1.length());
            var0 = var0.substring(var4, var5 + 1);
        }
        try {
            return var3.apply(Base64.getMimeDecoder().decode(var0));
        }
        catch (IllegalArgumentException var5) {
            throw new CryptographyException(var5);
        }
    }

    public static PrivateKey stringToPemRsaPrivateKey(String var0) throws CryptographyException {
        return MinecraftEncryption.rsaStringToKey(var0, PEM_RSA_PRIVATE_KEY_HEADER, PEM_RSA_PRIVATE_KEY_FOOTER, MinecraftEncryption::byteToPrivateKey);
    }

    public static PublicKey stringToRsaPublicKey(String var0) throws CryptographyException {
        return MinecraftEncryption.rsaStringToKey(var0, RSA_PUBLIC_KEY_HEADER, RSA_PUBLIC_KEY_FOOTER, MinecraftEncryption::byteToPublicKey);
    }

    public static String rsaPublicKeyToString(PublicKey var0) {
        if (!ASYMMETRIC_ALGORITHM.equals(var0.getAlgorithm())) {
            throw new IllegalArgumentException("Public key must be RSA");
        }
        return "-----BEGIN RSA PUBLIC KEY-----\n" + MIME_ENCODER.encodeToString(var0.getEncoded()) + "\n-----END RSA PUBLIC KEY-----\n";
    }

    public static String pemRsaPrivateKeyToString(PrivateKey var0) {
        if (!ASYMMETRIC_ALGORITHM.equals(var0.getAlgorithm())) {
            throw new IllegalArgumentException("Private key must be RSA");
        }
        return "-----BEGIN RSA PRIVATE KEY-----\n" + MIME_ENCODER.encodeToString(var0.getEncoded()) + "\n-----END RSA PRIVATE KEY-----\n";
    }

    private static PrivateKey byteToPrivateKey(byte[] var0) throws CryptographyException {
        try {
            PKCS8EncodedKeySpec var1 = new PKCS8EncodedKeySpec(var0);
            KeyFactory var2 = KeyFactory.getInstance(ASYMMETRIC_ALGORITHM);
            return var2.generatePrivate(var1);
        }
        catch (Exception var1) {
            throw new CryptographyException(var1);
        }
    }

    public static PublicKey byteToPublicKey(byte[] var0) throws CryptographyException {
        try {
            X509EncodedKeySpec var1 = new X509EncodedKeySpec(var0);
            KeyFactory var2 = KeyFactory.getInstance(ASYMMETRIC_ALGORITHM);
            return var2.generatePublic(var1);
        }
        catch (Exception var1) {
            throw new CryptographyException(var1);
        }
    }

    public static SecretKey decryptByteToSecretKey(PrivateKey var0, byte[] var1) throws CryptographyException {
        byte[] var2 = MinecraftEncryption.decryptUsingKey(var0, var1);
        try {
            return new SecretKeySpec(var2, SYMMETRIC_ALGORITHM);
        }
        catch (Exception var3) {
            throw new CryptographyException(var3);
        }
    }

    public static byte[] encryptUsingKey(Key var0, byte[] var1) throws CryptographyException {
        return MinecraftEncryption.cipherData(1, var0, var1);
    }

    public static byte[] decryptUsingKey(Key var0, byte[] var1) throws CryptographyException {
        return MinecraftEncryption.cipherData(2, var0, var1);
    }

    private static byte[] cipherData(int var0, Key var1, byte[] var2) throws CryptographyException {
        try {
            return MinecraftEncryption.setupCipher(var0, var1.getAlgorithm(), var1).doFinal(var2);
        }
        catch (Exception var3) {
            throw new CryptographyException(var3);
        }
    }

    private static Cipher setupCipher(int var0, String var1, Key var2) throws Exception {
        Cipher var3 = Cipher.getInstance(var1);
        var3.init(var0, var2);
        return var3;
    }

    public static Cipher getCipher(int var0, Key var1) throws CryptographyException {
        try {
            Cipher var2 = Cipher.getInstance("AES/CFB8/NoPadding");
            var2.init(var0, var1, new IvParameterSpec(var1.getEncoded()));
            return var2;
        }
        catch (Exception var2) {
            throw new CryptographyException(var2);
        }
    }

    static interface a<T extends Key> {
        public T apply(byte[] var1) throws CryptographyException;
    }

    public record b(long salt, byte[] signature) {
        public static final b EMPTY = new b(0L, ByteArrays.EMPTY_ARRAY);

        public b(PacketDataSerializer var0) {
            this(var0.readLong(), var0.readByteArray());
        }

        public boolean isValid() {
            return this.signature.length > 0;
        }

        public static void write(PacketDataSerializer var0, b var1) {
            var0.writeLong(var1.salt);
            var0.writeByteArray(var1.signature);
        }

        public byte[] saltAsBytes() {
            return Longs.toByteArray((long)this.salt);
        }
    }

    public static class c {
        private static final SecureRandom secureRandom = new SecureRandom();

        public static long getLong() {
            return secureRandom.nextLong();
        }
    }
}

