/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.metadata.ResourcePackMetaParser;
import net.minecraft.util.ExtraCodecs;
import org.slf4j.Logger;

public class ResourceFilterSection {
    static final Logger LOGGER = LogUtils.getLogger();
    static final Codec<ResourceFilterSection> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.list(a.CODEC).fieldOf("block").forGetter(var0 -> var0.blockList)).apply((Applicative)var02, ResourceFilterSection::new));
    public static final ResourcePackMetaParser<ResourceFilterSection> SERIALIZER = new ResourcePackMetaParser<ResourceFilterSection>(){

        @Override
        public String getMetadataSectionName() {
            return "filter";
        }

        @Override
        public ResourceFilterSection fromJson(JsonObject var0) {
            return (ResourceFilterSection)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)var0).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
        }

        @Override
        public /* synthetic */ Object fromJson(JsonObject jsonObject) {
            return this.fromJson(jsonObject);
        }
    };
    private final List<a> blockList;

    public ResourceFilterSection(List<a> var0) {
        this.blockList = List.copyOf(var0);
    }

    public boolean isNamespaceFiltered(String var0) {
        return this.blockList.stream().anyMatch(var1 -> var1.namespacePredicate.test(var0));
    }

    public boolean isPathFiltered(String var0) {
        return this.blockList.stream().anyMatch(var1 -> var1.pathPredicate.test(var0));
    }

    static class a
    implements Predicate<MinecraftKey> {
        static final Codec<a> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)ExtraCodecs.PATTERN.optionalFieldOf("namespace").forGetter(var0 -> var0.namespacePattern), (App)ExtraCodecs.PATTERN.optionalFieldOf("path").forGetter(var0 -> var0.pathPattern)).apply((Applicative)var02, a::new));
        private final Optional<Pattern> namespacePattern;
        final Predicate<String> namespacePredicate;
        private final Optional<Pattern> pathPattern;
        final Predicate<String> pathPredicate;

        private a(Optional<Pattern> var02, Optional<Pattern> var1) {
            this.namespacePattern = var02;
            this.namespacePredicate = var02.map(Pattern::asPredicate).orElse(var0 -> true);
            this.pathPattern = var1;
            this.pathPredicate = var1.map(Pattern::asPredicate).orElse(var0 -> true);
        }

        @Override
        public boolean test(MinecraftKey var0) {
            return this.namespacePredicate.test(var0.getNamespace()) && this.pathPredicate.test(var0.getPath());
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((MinecraftKey)object);
        }
    }
}

