/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataAbstract;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.profiling.GameProfilerFiller;
import org.slf4j.Logger;

public abstract class ResourceDataJson
extends ResourceDataAbstract<Map<MinecraftKey, JsonElement>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String PATH_SUFFIX = ".json";
    private static final int PATH_SUFFIX_LENGTH = ".json".length();
    private final Gson gson;
    private final String directory;

    public ResourceDataJson(Gson var0, String var1) {
        this.gson = var0;
        this.directory = var1;
    }

    @Override
    protected Map<MinecraftKey, JsonElement> prepare(IResourceManager var02, GameProfilerFiller var1) {
        HashMap var2 = Maps.newHashMap();
        int var3 = this.directory.length() + 1;
        for (Map.Entry<MinecraftKey, IResource> var5 : var02.listResources(this.directory, var0 -> var0.getPath().endsWith(PATH_SUFFIX)).entrySet()) {
            MinecraftKey var6 = var5.getKey();
            String var7 = var6.getPath();
            MinecraftKey var8 = new MinecraftKey(var6.getNamespace(), var7.substring(var3, var7.length() - PATH_SUFFIX_LENGTH));
            try {
                BufferedReader var9 = var5.getValue().openAsReader();
                try {
                    JsonElement var10 = ChatDeserializer.fromJson(this.gson, (Reader)var9, JsonElement.class);
                    if (var10 != null) {
                        JsonElement var11 = var2.put(var8, var10);
                        if (var11 == null) continue;
                        throw new IllegalStateException("Duplicate data file ignored with ID " + var8);
                    }
                    LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)var8, (Object)var6);
                }
                finally {
                    if (var9 == null) continue;
                    ((Reader)var9).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException var9) {
                LOGGER.error("Couldn't parse data file {} from {}", new Object[]{var8, var6, var9});
            }
        }
        return var2;
    }

    @Override
    protected /* synthetic */ Object prepare(IResourceManager iResourceManager, GameProfilerFiller gameProfilerFiller) {
        return this.prepare(iResourceManager, gameProfilerFiller);
    }
}

