/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import net.minecraft.server.packs.resources.ResourceMetadata;

public class IResource {
    private final String packId;
    private final a<InputStream> streamSupplier;
    private final a<ResourceMetadata> metadataSupplier;
    @Nullable
    private ResourceMetadata cachedMetadata;

    public IResource(String var0, a<InputStream> var1, a<ResourceMetadata> var2) {
        this.packId = var0;
        this.streamSupplier = var1;
        this.metadataSupplier = var2;
    }

    public IResource(String var0, a<InputStream> var1) {
        this.packId = var0;
        this.streamSupplier = var1;
        this.metadataSupplier = () -> ResourceMetadata.EMPTY;
        this.cachedMetadata = ResourceMetadata.EMPTY;
    }

    public String sourcePackId() {
        return this.packId;
    }

    public InputStream open() throws IOException {
        return this.streamSupplier.get();
    }

    public BufferedReader openAsReader() throws IOException {
        return new BufferedReader(new InputStreamReader(this.open(), StandardCharsets.UTF_8));
    }

    public ResourceMetadata metadata() throws IOException {
        if (this.cachedMetadata == null) {
            this.cachedMetadata = this.metadataSupplier.get();
        }
        return this.cachedMetadata;
    }

    @FunctionalInterface
    public static interface a<T> {
        public T get() throws IOException;
    }
}

