/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.SystemUtils;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.ResourceNotFoundException;
import net.minecraft.server.packs.ResourcePackAbstract;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.slf4j.Logger;

public class ResourcePackFolder
extends ResourcePackAbstract {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean ON_WINDOWS = SystemUtils.getPlatform() == SystemUtils.OS.WINDOWS;
    private static final CharMatcher BACKSLASH_MATCHER = CharMatcher.is((char)'\\');

    public ResourcePackFolder(File var0) {
        super(var0);
    }

    public static boolean validatePath(File var0, String var1) throws IOException {
        String var2 = var0.getCanonicalPath();
        if (ON_WINDOWS) {
            var2 = BACKSLASH_MATCHER.replaceFrom((CharSequence)var2, '/');
        }
        return var2.endsWith(var1);
    }

    @Override
    protected InputStream getResource(String var0) throws IOException {
        File var1 = this.getFile(var0);
        if (var1 == null) {
            throw new ResourceNotFoundException(this.file, var0);
        }
        return new FileInputStream(var1);
    }

    @Override
    protected boolean hasResource(String var0) {
        return this.getFile(var0) != null;
    }

    @Nullable
    private File getFile(String var0) {
        try {
            File var1 = new File(this.file, var0);
            if (var1.isFile() && ResourcePackFolder.validatePath(var1, var0)) {
                return var1;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Set<String> getNamespaces(EnumResourcePackType var0) {
        HashSet var1 = Sets.newHashSet();
        File var2 = new File(this.file, var0.getDirectory());
        File[] var3 = var2.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
        if (var3 != null) {
            for (File var7 : var3) {
                String var8 = ResourcePackFolder.getRelativePath(var2, var7);
                if (var8.equals(var8.toLowerCase(Locale.ROOT))) {
                    var1.add(var8.substring(0, var8.length() - 1));
                    continue;
                }
                this.logWarning(var8);
            }
        }
        return var1;
    }

    @Override
    public void close() {
    }

    @Override
    public Collection<MinecraftKey> getResources(EnumResourcePackType var0, String var1, String var2, Predicate<MinecraftKey> var3) {
        File var4 = new File(this.file, var0.getDirectory());
        ArrayList var5 = Lists.newArrayList();
        this.listResources(new File(new File(var4, var1), var2), var1, var5, var2 + "/", var3);
        return var5;
    }

    private void listResources(File var0, String var1, List<MinecraftKey> var2, String var3, Predicate<MinecraftKey> var4) {
        File[] var5 = var0.listFiles();
        if (var5 != null) {
            for (File var9 : var5) {
                if (var9.isDirectory()) {
                    this.listResources(var9, var1, var2, var3 + var9.getName() + "/", var4);
                    continue;
                }
                if (var9.getName().endsWith(".mcmeta")) continue;
                try {
                    String var10 = var3 + var9.getName();
                    MinecraftKey var11 = MinecraftKey.tryBuild(var1, var10);
                    if (var11 == null) {
                        LOGGER.warn("Invalid path in datapack: {}:{}, ignoring", (Object)var1, (Object)var10);
                        continue;
                    }
                    if (!var4.test(var11)) continue;
                    var2.add(var11);
                }
                catch (ResourceKeyInvalidException var10) {
                    LOGGER.error(var10.getMessage());
                }
            }
        }
    }
}

