/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.primitives.Ints;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.minecraft.InsecurePublicKeyException;
import com.mojang.logging.LogUtils;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Key;
import java.security.PrivateKey;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.ThrowingComponent;
import net.minecraft.network.protocol.game.PacketPlayOutKickDisconnect;
import net.minecraft.network.protocol.login.PacketLoginInCustomPayload;
import net.minecraft.network.protocol.login.PacketLoginInEncryptionBegin;
import net.minecraft.network.protocol.login.PacketLoginInListener;
import net.minecraft.network.protocol.login.PacketLoginInStart;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.login.PacketLoginOutEncryptionBegin;
import net.minecraft.network.protocol.login.PacketLoginOutSetCompression;
import net.minecraft.network.protocol.login.PacketLoginOutSuccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SignatureValidator;
import net.minecraft.world.entity.player.ProfilePublicKey;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class LoginListener
implements TickablePacketListener,
PacketLoginInListener {
    private static final AtomicInteger UNIQUE_THREAD_ID = new AtomicInteger(0);
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_TICKS_BEFORE_LOGIN = 600;
    private static final RandomSource RANDOM = RandomSource.create();
    private static final IChatBaseComponent MISSING_PROFILE_PUBLIC_KEY = IChatBaseComponent.translatable("multiplayer.disconnect.missing_public_key");
    private static final IChatBaseComponent INVALID_SIGNATURE = IChatBaseComponent.translatable("multiplayer.disconnect.invalid_public_key_signature");
    private static final IChatBaseComponent INVALID_PUBLIC_KEY = IChatBaseComponent.translatable("multiplayer.disconnect.invalid_public_key");
    private final byte[] nonce;
    final MinecraftServer server;
    public final NetworkManager connection;
    EnumProtocolState state = EnumProtocolState.HELLO;
    private int tick;
    @Nullable
    GameProfile gameProfile;
    private final String serverId = "";
    @Nullable
    private EntityPlayer delayedAcceptPlayer;
    @Nullable
    private ProfilePublicKey.a profilePublicKeyData;

    public LoginListener(MinecraftServer var0, NetworkManager var1) {
        this.server = var0;
        this.connection = var1;
        this.nonce = Ints.toByteArray((int)RANDOM.nextInt());
    }

    @Override
    public void tick() {
        EntityPlayer var0;
        if (this.state == EnumProtocolState.READY_TO_ACCEPT) {
            this.handleAcceptedLogin();
        } else if (this.state == EnumProtocolState.DELAY_ACCEPT && (var0 = this.server.getPlayerList().getPlayer(this.gameProfile.getId())) == null) {
            this.state = EnumProtocolState.READY_TO_ACCEPT;
            this.placeNewPlayer(this.delayedAcceptPlayer);
            this.delayedAcceptPlayer = null;
        }
        if (this.tick++ == 600) {
            this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.slow_login"));
        }
    }

    @Override
    public NetworkManager getConnection() {
        return this.connection;
    }

    public void disconnect(IChatBaseComponent var0) {
        try {
            LOGGER.info("Disconnecting {}: {}", (Object)this.getUserName(), (Object)var0.getString());
            this.connection.send(new PacketLoginOutDisconnect(var0));
            this.connection.disconnect(var0);
        }
        catch (Exception var1) {
            LOGGER.error("Error whilst disconnecting player", (Throwable)var1);
        }
    }

    public void handleAcceptedLogin() {
        Object var1;
        ProfilePublicKey var0;
        block11: {
            var0 = null;
            if (!this.gameProfile.isComplete()) {
                this.gameProfile = this.createFakeProfile(this.gameProfile);
            } else {
                try {
                    var1 = this.server.getServiceSignatureValidator();
                    var0 = LoginListener.validatePublicKey(this.profilePublicKeyData, this.gameProfile.getId(), (SignatureValidator)var1, this.server.enforceSecureProfile());
                }
                catch (a var12) {
                    LOGGER.error(var12.getMessage(), var12.getCause());
                    if (this.connection.isMemoryConnection()) break block11;
                    this.disconnect(var12.getComponent());
                    return;
                }
            }
        }
        var1 = this.server.getPlayerList().canPlayerLogin(this.connection.getRemoteAddress(), this.gameProfile);
        if (var1 != null) {
            this.disconnect((IChatBaseComponent)var1);
        } else {
            this.state = EnumProtocolState.ACCEPTED;
            if (this.server.getCompressionThreshold() >= 0 && !this.connection.isMemoryConnection()) {
                this.connection.send(new PacketLoginOutSetCompression(this.server.getCompressionThreshold()), PacketSendListener.thenRun(() -> this.connection.setupCompression(this.server.getCompressionThreshold(), true)));
            }
            this.connection.send(new PacketLoginOutSuccess(this.gameProfile));
            EntityPlayer var2 = this.server.getPlayerList().getPlayer(this.gameProfile.getId());
            try {
                EntityPlayer var3 = this.server.getPlayerList().getPlayerForLogin(this.gameProfile, var0);
                if (var2 != null) {
                    this.state = EnumProtocolState.DELAY_ACCEPT;
                    this.delayedAcceptPlayer = var3;
                } else {
                    this.placeNewPlayer(var3);
                }
            }
            catch (Exception var3) {
                LOGGER.error("Couldn't place player in world", (Throwable)var3);
                IChatMutableComponent var4 = IChatBaseComponent.translatable("multiplayer.disconnect.invalid_player_data");
                this.connection.send(new PacketPlayOutKickDisconnect(var4));
                this.connection.disconnect(var4);
            }
        }
    }

    private void placeNewPlayer(EntityPlayer var0) {
        this.server.getPlayerList().placeNewPlayer(this.connection, var0);
    }

    @Override
    public void onDisconnect(IChatBaseComponent var0) {
        LOGGER.info("{} lost connection: {}", (Object)this.getUserName(), (Object)var0.getString());
    }

    public String getUserName() {
        if (this.gameProfile != null) {
            return this.gameProfile + " (" + this.connection.getRemoteAddress() + ")";
        }
        return String.valueOf(this.connection.getRemoteAddress());
    }

    @Nullable
    private static ProfilePublicKey validatePublicKey(@Nullable ProfilePublicKey.a var0, UUID var1, SignatureValidator var2, boolean var3) throws a {
        try {
            if (var0 == null) {
                if (var3) {
                    throw new a(MISSING_PROFILE_PUBLIC_KEY);
                }
                return null;
            }
            return ProfilePublicKey.createValidated(var2, var1, var0);
        }
        catch (InsecurePublicKeyException.MissingException var4) {
            if (var3) {
                throw new a(INVALID_SIGNATURE, (Throwable)var4);
            }
            return null;
        }
        catch (CryptographyException var4) {
            throw new a(INVALID_PUBLIC_KEY, (Throwable)var4);
        }
        catch (Exception var4) {
            throw new a(INVALID_SIGNATURE, (Throwable)var4);
        }
    }

    @Override
    public void handleHello(PacketLoginInStart var0) {
        Validate.validState((this.state == EnumProtocolState.HELLO ? 1 : 0) != 0, (String)"Unexpected hello packet", (Object[])new Object[0]);
        Validate.validState((boolean)LoginListener.isValidUsername(var0.name()), (String)"Invalid characters in username", (Object[])new Object[0]);
        this.profilePublicKeyData = var0.publicKey().orElse(null);
        GameProfile var1 = this.server.getSingleplayerProfile();
        if (var1 != null && var0.name().equalsIgnoreCase(var1.getName())) {
            this.gameProfile = var1;
            this.state = EnumProtocolState.READY_TO_ACCEPT;
            return;
        }
        this.gameProfile = new GameProfile(null, var0.name());
        if (this.server.usesAuthentication() && !this.connection.isMemoryConnection()) {
            this.state = EnumProtocolState.KEY;
            this.connection.send(new PacketLoginOutEncryptionBegin("", this.server.getKeyPair().getPublic().getEncoded(), this.nonce));
        } else {
            this.state = EnumProtocolState.READY_TO_ACCEPT;
        }
    }

    public static boolean isValidUsername(String var02) {
        return var02.chars().filter(var0 -> var0 <= 32 || var0 >= 127).findAny().isEmpty();
    }

    @Override
    public void handleKey(PacketLoginInEncryptionBegin var0) {
        String var1;
        Object var2;
        Validate.validState((this.state == EnumProtocolState.KEY ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        try {
            Object var3;
            var2 = this.server.getKeyPair().getPrivate();
            if (this.profilePublicKeyData != null ? !var0.isChallengeSignatureValid(this.nonce, (ProfilePublicKey)(var3 = ProfilePublicKey.createTrusted(this.profilePublicKeyData))) : !var0.isNonceValid(this.nonce, (PrivateKey)var2)) {
                throw new IllegalStateException("Protocol error");
            }
            var3 = var0.getSecretKey((PrivateKey)var2);
            Cipher var4 = MinecraftEncryption.getCipher(2, (Key)var3);
            Cipher var5 = MinecraftEncryption.getCipher(1, (Key)var3);
            var1 = new BigInteger(MinecraftEncryption.digestData("", this.server.getKeyPair().getPublic(), (SecretKey)var3)).toString(16);
            this.state = EnumProtocolState.AUTHENTICATING;
            this.connection.setEncryptionKey(var4, var5);
        }
        catch (CryptographyException var22) {
            throw new IllegalStateException("Protocol error", var22);
        }
        var2 = new Thread("User Authenticator #" + UNIQUE_THREAD_ID.incrementAndGet()){

            @Override
            public void run() {
                GameProfile var0 = LoginListener.this.gameProfile;
                try {
                    LoginListener.this.gameProfile = LoginListener.this.server.getSessionService().hasJoinedServer(new GameProfile(null, var0.getName()), var1, this.getAddress());
                    if (LoginListener.this.gameProfile != null) {
                        LOGGER.info("UUID of player {} is {}", (Object)LoginListener.this.gameProfile.getName(), (Object)LoginListener.this.gameProfile.getId());
                        LoginListener.this.state = EnumProtocolState.READY_TO_ACCEPT;
                    } else if (LoginListener.this.server.isSingleplayer()) {
                        LOGGER.warn("Failed to verify username but will let them in anyway!");
                        LoginListener.this.gameProfile = var0;
                        LoginListener.this.state = EnumProtocolState.READY_TO_ACCEPT;
                    } else {
                        LoginListener.this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.unverified_username"));
                        LOGGER.error("Username '{}' tried to join with an invalid session", (Object)var0.getName());
                    }
                }
                catch (AuthenticationUnavailableException var12) {
                    if (LoginListener.this.server.isSingleplayer()) {
                        LOGGER.warn("Authentication servers are down but will let them in anyway!");
                        LoginListener.this.gameProfile = var0;
                        LoginListener.this.state = EnumProtocolState.READY_TO_ACCEPT;
                    }
                    LoginListener.this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.authservers_down"));
                    LOGGER.error("Couldn't verify username because servers are unavailable");
                }
            }

            @Nullable
            private InetAddress getAddress() {
                SocketAddress var0 = LoginListener.this.connection.getRemoteAddress();
                return LoginListener.this.server.getPreventProxyConnections() && var0 instanceof InetSocketAddress ? ((InetSocketAddress)var0).getAddress() : null;
            }
        };
        ((Thread)var2).setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
        ((Thread)var2).start();
    }

    @Override
    public void handleCustomQueryPacket(PacketLoginInCustomPayload var0) {
        this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.unexpected_query_response"));
    }

    protected GameProfile createFakeProfile(GameProfile var0) {
        UUID var1 = UUIDUtil.createOfflinePlayerUUID(var0.getName());
        return new GameProfile(var1, var0.getName());
    }

    static final class EnumProtocolState
    extends Enum<EnumProtocolState> {
        public static final /* enum */ EnumProtocolState HELLO = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState KEY = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState AUTHENTICATING = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState NEGOTIATING = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState READY_TO_ACCEPT = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState DELAY_ACCEPT = new EnumProtocolState();
        public static final /* enum */ EnumProtocolState ACCEPTED = new EnumProtocolState();
        private static final /* synthetic */ EnumProtocolState[] h;

        public static EnumProtocolState[] values() {
            return (EnumProtocolState[])h.clone();
        }

        public static EnumProtocolState valueOf(String var0) {
            return Enum.valueOf(EnumProtocolState.class, var0);
        }

        private static /* synthetic */ EnumProtocolState[] a() {
            return new EnumProtocolState[]{HELLO, KEY, AUTHENTICATING, NEGOTIATING, READY_TO_ACCEPT, DELAY_ACCEPT, ACCEPTED};
        }

        static {
            h = EnumProtocolState.a();
        }
    }

    static class a
    extends ThrowingComponent {
        public a(IChatBaseComponent var0) {
            super(var0);
        }

        public a(IChatBaseComponent var0, Throwable var1) {
            super(var0, var1);
        }
    }
}

