/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level.progress;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.ChunkStatus;
import org.slf4j.Logger;

public class WorldLoadListenerLogger
implements WorldLoadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final int maxCount;
    private int count;
    private long startTime;
    private long nextTickTime = Long.MAX_VALUE;

    public WorldLoadListenerLogger(int var0) {
        int var1 = var0 * 2 + 1;
        this.maxCount = var1 * var1;
    }

    @Override
    public void updateSpawnPos(ChunkCoordIntPair var0) {
        this.startTime = this.nextTickTime = SystemUtils.getMillis();
    }

    @Override
    public void onStatusChange(ChunkCoordIntPair var0, @Nullable ChunkStatus var1) {
        if (var1 == ChunkStatus.FULL) {
            ++this.count;
        }
        int var2 = this.getProgress();
        if (SystemUtils.getMillis() > this.nextTickTime) {
            this.nextTickTime += 500L;
            LOGGER.info(IChatBaseComponent.translatable("menu.preparingSpawn", MathHelper.clamp(var2, 0, 100)).getString());
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        LOGGER.info("Time elapsed: {} ms", (Object)(SystemUtils.getMillis() - this.startTime));
        this.nextTickTime = Long.MAX_VALUE;
    }

    public int getProgress() {
        return MathHelper.floor((float)this.count * 100.0f / (float)this.maxCount);
    }
}

