/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.entity.Entity;

public class CommandTag {
    private static final SimpleCommandExceptionType ERROR_ADD_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.tag.add.failed"));
    private static final SimpleCommandExceptionType ERROR_REMOVE_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.tag.remove.failed"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("tag").requires(var0 -> var0.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.entities()).then(net.minecraft.commands.CommandDispatcher.literal("add").then(net.minecraft.commands.CommandDispatcher.argument("name", StringArgumentType.word()).executes(var0 -> CommandTag.addTag((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), StringArgumentType.getString((CommandContext)var0, (String)"name")))))).then(net.minecraft.commands.CommandDispatcher.literal("remove").then(net.minecraft.commands.CommandDispatcher.argument("name", StringArgumentType.word()).suggests((var0, var1) -> ICompletionProvider.suggest(CommandTag.getTags(ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets")), var1)).executes(var0 -> CommandTag.removeTag((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), StringArgumentType.getString((CommandContext)var0, (String)"name")))))).then(net.minecraft.commands.CommandDispatcher.literal("list").executes(var0 -> CommandTag.listTags((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"))))));
    }

    private static Collection<String> getTags(Collection<? extends Entity> var0) {
        HashSet var1 = Sets.newHashSet();
        for (Entity entity : var0) {
            var1.addAll(entity.getTags());
        }
        return var1;
    }

    private static int addTag(CommandListenerWrapper var0, Collection<? extends Entity> var1, String var2) throws CommandSyntaxException {
        int var3 = 0;
        for (Entity entity : var1) {
            if (!entity.addTag(var2)) continue;
            ++var3;
        }
        if (var3 == 0) {
            throw ERROR_ADD_FAILED.create();
        }
        if (var1.size() == 1) {
            var0.sendSuccess(IChatBaseComponent.translatable("commands.tag.add.success.single", var2, var1.iterator().next().getDisplayName()), true);
        } else {
            var0.sendSuccess(IChatBaseComponent.translatable("commands.tag.add.success.multiple", var2, var1.size()), true);
        }
        return var3;
    }

    private static int removeTag(CommandListenerWrapper var0, Collection<? extends Entity> var1, String var2) throws CommandSyntaxException {
        int var3 = 0;
        for (Entity entity : var1) {
            if (!entity.removeTag(var2)) continue;
            ++var3;
        }
        if (var3 == 0) {
            throw ERROR_REMOVE_FAILED.create();
        }
        if (var1.size() == 1) {
            var0.sendSuccess(IChatBaseComponent.translatable("commands.tag.remove.success.single", var2, var1.iterator().next().getDisplayName()), true);
        } else {
            var0.sendSuccess(IChatBaseComponent.translatable("commands.tag.remove.success.multiple", var2, var1.size()), true);
        }
        return var3;
    }

    private static int listTags(CommandListenerWrapper var0, Collection<? extends Entity> var1) {
        HashSet var2 = Sets.newHashSet();
        for (Entity entity : var1) {
            var2.addAll(entity.getTags());
        }
        if (var1.size() == 1) {
            Entity var3 = var1.iterator().next();
            if (var2.isEmpty()) {
                var0.sendSuccess(IChatBaseComponent.translatable("commands.tag.list.single.empty", var3.getDisplayName()), false);
            } else {
                var0.sendSuccess(IChatBaseComponent.translatable("commands.tag.list.single.success", var3.getDisplayName(), var2.size(), ChatComponentUtils.formatList(var2)), false);
            }
        } else if (var2.isEmpty()) {
            var0.sendSuccess(IChatBaseComponent.translatable("commands.tag.list.multiple.empty", var1.size()), false);
        } else {
            var0.sendSuccess(IChatBaseComponent.translatable("commands.tag.list.multiple.success", var1.size(), var2.size(), ChatComponentUtils.formatList(var2)), false);
        }
        return var2.size();
    }
}

