/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.HttpUtilities;

public class CommandPublish {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.publish.failed"));
    private static final DynamicCommandExceptionType ERROR_ALREADY_PUBLISHED = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("commands.publish.alreadyPublished", var0));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("publish").requires(var0 -> var0.hasPermission(4))).executes(var0 -> CommandPublish.publish((CommandListenerWrapper)var0.getSource(), HttpUtilities.getAvailablePort()))).then(net.minecraft.commands.CommandDispatcher.argument("port", IntegerArgumentType.integer((int)0, (int)65535)).executes(var0 -> CommandPublish.publish((CommandListenerWrapper)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"port")))));
    }

    private static int publish(CommandListenerWrapper var0, int var1) throws CommandSyntaxException {
        if (var0.getServer().isPublished()) {
            throw ERROR_ALREADY_PUBLISHED.create((Object)var0.getServer().getPort());
        }
        if (!var0.getServer().publishServer(null, false, var1)) {
            throw ERROR_FAILED.create();
        }
        var0.sendSuccess(IChatBaseComponent.translatable("commands.publish.success", var1), true);
        return var1;
    }
}

