/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutCustomSoundEffect;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.world.phys.Vec3D;

public class CommandPlaySound {
    private static final SimpleCommandExceptionType ERROR_TOO_FAR = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.playsound.failed"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        RequiredArgumentBuilder var1 = net.minecraft.commands.CommandDispatcher.argument("sound", ArgumentMinecraftKeyRegistered.id()).suggests(CompletionProviders.AVAILABLE_SOUNDS);
        for (SoundCategory var5 : SoundCategory.values()) {
            var1.then(CommandPlaySound.source(var5));
        }
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("playsound").requires(var0 -> var0.hasPermission(2))).then((ArgumentBuilder)var1));
    }

    private static LiteralArgumentBuilder<CommandListenerWrapper> source(SoundCategory var0) {
        return (LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal(var0.getName()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.players()).executes(var1 -> CommandPlaySound.playSound((CommandListenerWrapper)var1.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var1, "targets"), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var1, "sound"), var0, ((CommandListenerWrapper)var1.getSource()).getPosition(), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentVec3.vec3()).executes(var1 -> CommandPlaySound.playSound((CommandListenerWrapper)var1.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var1, "targets"), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var1, "sound"), var0, ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var1, "pos"), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("volume", FloatArgumentType.floatArg((float)0.0f)).executes(var1 -> CommandPlaySound.playSound((CommandListenerWrapper)var1.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var1, "targets"), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var1, "sound"), var0, ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var1, "pos"), ((Float)var1.getArgument("volume", Float.class)).floatValue(), 1.0f, 0.0f))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("pitch", FloatArgumentType.floatArg((float)0.0f, (float)2.0f)).executes(var1 -> CommandPlaySound.playSound((CommandListenerWrapper)var1.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var1, "targets"), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var1, "sound"), var0, ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var1, "pos"), ((Float)var1.getArgument("volume", Float.class)).floatValue(), ((Float)var1.getArgument("pitch", Float.class)).floatValue(), 0.0f))).then(net.minecraft.commands.CommandDispatcher.argument("minVolume", FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(var1 -> CommandPlaySound.playSound((CommandListenerWrapper)var1.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var1, "targets"), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var1, "sound"), var0, ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var1, "pos"), ((Float)var1.getArgument("volume", Float.class)).floatValue(), ((Float)var1.getArgument("pitch", Float.class)).floatValue(), ((Float)var1.getArgument("minVolume", Float.class)).floatValue())))))));
    }

    private static int playSound(CommandListenerWrapper var0, Collection<EntityPlayer> var1, MinecraftKey var2, SoundCategory var3, Vec3D var4, float var5, float var6, float var7) throws CommandSyntaxException {
        double var8 = Math.pow(var5 > 1.0f ? (double)(var5 * 16.0f) : 16.0, 2.0);
        int var10 = 0;
        long var11 = var0.getLevel().getRandom().nextLong();
        for (EntityPlayer var14 : var1) {
            double var15 = var4.x - var14.getX();
            double var17 = var4.y - var14.getY();
            double var19 = var4.z - var14.getZ();
            double var21 = var15 * var15 + var17 * var17 + var19 * var19;
            Vec3D var23 = var4;
            float var24 = var5;
            if (var21 > var8) {
                if (var7 <= 0.0f) continue;
                double var25 = Math.sqrt(var21);
                var23 = new Vec3D(var14.getX() + var15 / var25 * 2.0, var14.getY() + var17 / var25 * 2.0, var14.getZ() + var19 / var25 * 2.0);
                var24 = var7;
            }
            var14.connection.send(new PacketPlayOutCustomSoundEffect(var2, var3, var23, var24, var6, var11));
            ++var10;
        }
        if (var10 == 0) {
            throw ERROR_TOO_FAR.create();
        }
        if (var1.size() == 1) {
            var0.sendSuccess(IChatBaseComponent.translatable("commands.playsound.success.single", var2, var1.iterator().next().getDisplayName()), true);
        } else {
            var0.sendSuccess(IChatBaseComponent.translatable("commands.playsound.success.multiple", var2, var1.size()), true);
        }
        return var10;
    }
}

