/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.minecraft.EnumChatFormat;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ResourceOrTagLocationArgument;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.levelgen.structure.Structure;

public class CommandLocate {
    private static final DynamicCommandExceptionType ERROR_STRUCTURE_NOT_FOUND = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("commands.locate.structure.not_found", var0));
    private static final DynamicCommandExceptionType ERROR_STRUCTURE_INVALID = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("commands.locate.structure.invalid", var0));
    private static final DynamicCommandExceptionType ERROR_BIOME_NOT_FOUND = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("commands.locate.biome.not_found", var0));
    private static final DynamicCommandExceptionType ERROR_BIOME_INVALID = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("commands.locate.biome.invalid", var0));
    private static final DynamicCommandExceptionType ERROR_POI_NOT_FOUND = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("commands.locate.poi.not_found", var0));
    private static final DynamicCommandExceptionType ERROR_POI_INVALID = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatable("commands.locate.poi.invalid", var0));
    private static final int MAX_STRUCTURE_SEARCH_RADIUS = 100;
    private static final int MAX_BIOME_SEARCH_RADIUS = 6400;
    private static final int BIOME_SAMPLE_RESOLUTION_HORIZONTAL = 32;
    private static final int BIOME_SAMPLE_RESOLUTION_VERTICAL = 64;
    private static final int POI_SEARCH_RADIUS = 256;

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("locate").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.literal("structure").then(net.minecraft.commands.CommandDispatcher.argument("structure", ResourceOrTagLocationArgument.resourceOrTag(IRegistry.STRUCTURE_REGISTRY)).executes(var0 -> CommandLocate.locateStructure((CommandListenerWrapper)var0.getSource(), ResourceOrTagLocationArgument.getRegistryType((CommandContext<CommandListenerWrapper>)var0, "structure", IRegistry.STRUCTURE_REGISTRY, ERROR_STRUCTURE_INVALID)))))).then(net.minecraft.commands.CommandDispatcher.literal("biome").then(net.minecraft.commands.CommandDispatcher.argument("biome", ResourceOrTagLocationArgument.resourceOrTag(IRegistry.BIOME_REGISTRY)).executes(var0 -> CommandLocate.locateBiome((CommandListenerWrapper)var0.getSource(), ResourceOrTagLocationArgument.getRegistryType((CommandContext<CommandListenerWrapper>)var0, "biome", IRegistry.BIOME_REGISTRY, ERROR_BIOME_INVALID)))))).then(net.minecraft.commands.CommandDispatcher.literal("poi").then(net.minecraft.commands.CommandDispatcher.argument("poi", ResourceOrTagLocationArgument.resourceOrTag(IRegistry.POINT_OF_INTEREST_TYPE_REGISTRY)).executes(var0 -> CommandLocate.locatePoi((CommandListenerWrapper)var0.getSource(), ResourceOrTagLocationArgument.getRegistryType((CommandContext<CommandListenerWrapper>)var0, "poi", IRegistry.POINT_OF_INTEREST_TYPE_REGISTRY, ERROR_POI_INVALID))))));
    }

    private static Optional<? extends HolderSet.b<Structure>> getHolders(ResourceOrTagLocationArgument.c<Structure> var0, IRegistry<Structure> var12) {
        return (Optional)var0.unwrap().map(var1 -> var12.getHolder((ResourceKey<Structure>)var1).map(var0 -> HolderSet.direct(var0)), var12::getTag);
    }

    private static int locateStructure(CommandListenerWrapper var0, ResourceOrTagLocationArgument.c<Structure> var1) throws CommandSyntaxException {
        IRegistry<Structure> var2 = var0.getLevel().registryAccess().registryOrThrow(IRegistry.STRUCTURE_REGISTRY);
        HolderSet var3 = CommandLocate.getHolders(var1, var2).orElseThrow(() -> ERROR_STRUCTURE_INVALID.create((Object)var1.asPrintable()));
        BlockPosition var4 = new BlockPosition(var0.getPosition());
        WorldServer var5 = var0.getLevel();
        Pair<BlockPosition, Holder<Structure>> var6 = var5.getChunkSource().getGenerator().findNearestMapStructure(var5, var3, var4, 100, false);
        if (var6 == null) {
            throw ERROR_STRUCTURE_NOT_FOUND.create((Object)var1.asPrintable());
        }
        return CommandLocate.showLocateResult(var0, var1, var4, var6, "commands.locate.structure.success", false);
    }

    private static int locateBiome(CommandListenerWrapper var0, ResourceOrTagLocationArgument.c<BiomeBase> var1) throws CommandSyntaxException {
        BlockPosition var2 = new BlockPosition(var0.getPosition());
        Pair<BlockPosition, Holder<BiomeBase>> var3 = var0.getLevel().findClosestBiome3d(var1, var2, 6400, 32, 64);
        if (var3 == null) {
            throw ERROR_BIOME_NOT_FOUND.create((Object)var1.asPrintable());
        }
        return CommandLocate.showLocateResult(var0, var1, var2, var3, "commands.locate.biome.success", true);
    }

    private static int locatePoi(CommandListenerWrapper var0, ResourceOrTagLocationArgument.c<VillagePlaceType> var1) throws CommandSyntaxException {
        BlockPosition var2 = new BlockPosition(var0.getPosition());
        WorldServer var3 = var0.getLevel();
        Optional<Pair<Holder<VillagePlaceType>, BlockPosition>> var4 = var3.getPoiManager().findClosestWithType(var1, var2, 256, VillagePlace.Occupancy.ANY);
        if (var4.isEmpty()) {
            throw ERROR_POI_NOT_FOUND.create((Object)var1.asPrintable());
        }
        return CommandLocate.showLocateResult(var0, var1, var2, var4.get().swap(), "commands.locate.poi.success", false);
    }

    public static int showLocateResult(CommandListenerWrapper var02, ResourceOrTagLocationArgument.c<?> var12, BlockPosition var22, Pair<BlockPosition, ? extends Holder<?>> var3, String var4, boolean var5) {
        BlockPosition var6 = (BlockPosition)var3.getFirst();
        String var7 = (String)var12.unwrap().map(var0 -> var0.location().toString(), var1 -> "#" + var1.location() + " (" + ((Holder)var3.getSecond()).unwrapKey().map(var0 -> var0.location().toString()).orElse("[unregistered]") + ")");
        int var8 = var5 ? MathHelper.floor(MathHelper.sqrt((float)var22.distSqr(var6))) : MathHelper.floor(CommandLocate.dist(var22.getX(), var22.getZ(), var6.getX(), var6.getZ()));
        String var9 = var5 ? String.valueOf(var6.getY()) : "~";
        IChatMutableComponent var10 = ChatComponentUtils.wrapInSquareBrackets(IChatBaseComponent.translatable("chat.coordinates", var6.getX(), var9, var6.getZ())).withStyle(var2 -> var2.withColor(EnumChatFormat.GREEN).withClickEvent(new ChatClickable(ChatClickable.EnumClickAction.SUGGEST_COMMAND, "/tp @s " + var6.getX() + " " + var9 + " " + var6.getZ())).withHoverEvent(new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_TEXT, IChatBaseComponent.translatable("chat.coordinates.tooltip"))));
        var02.sendSuccess(IChatBaseComponent.translatable(var4, var7, var10, var8), false);
        return var8;
    }

    private static float dist(int var0, int var1, int var2, int var3) {
        int var4 = var2 - var0;
        int var5 = var3 - var1;
        return MathHelper.sqrt(var4 * var4 + var5 * var5);
    }
}

