/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.commands.CommandException;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;

public class CommandAdvancement {
    private static final SuggestionProvider<CommandListenerWrapper> SUGGEST_ADVANCEMENTS = (var0, var1) -> {
        Collection<Advancement> var2 = ((CommandListenerWrapper)var0.getSource()).getServer().getAdvancements().getAllAdvancements();
        return ICompletionProvider.suggestResource(var2.stream().map(Advancement::getId), var1);
    };

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("advancement").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.literal("grant").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.players()).then(net.minecraft.commands.CommandDispatcher.literal("only").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("advancement", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_ADVANCEMENTS).executes(var0 -> CommandAdvancement.perform((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Action.GRANT, CommandAdvancement.getAdvancements(ArgumentMinecraftKeyRegistered.getAdvancement((CommandContext<CommandListenerWrapper>)var0, "advancement"), Filter.ONLY)))).then(net.minecraft.commands.CommandDispatcher.argument("criterion", StringArgumentType.greedyString()).suggests((var0, var1) -> ICompletionProvider.suggest(ArgumentMinecraftKeyRegistered.getAdvancement((CommandContext<CommandListenerWrapper>)var0, "advancement").getCriteria().keySet(), var1)).executes(var0 -> CommandAdvancement.performCriterion((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Action.GRANT, ArgumentMinecraftKeyRegistered.getAdvancement((CommandContext<CommandListenerWrapper>)var0, "advancement"), StringArgumentType.getString((CommandContext)var0, (String)"criterion"))))))).then(net.minecraft.commands.CommandDispatcher.literal("from").then(net.minecraft.commands.CommandDispatcher.argument("advancement", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_ADVANCEMENTS).executes(var0 -> CommandAdvancement.perform((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Action.GRANT, CommandAdvancement.getAdvancements(ArgumentMinecraftKeyRegistered.getAdvancement((CommandContext<CommandListenerWrapper>)var0, "advancement"), Filter.FROM)))))).then(net.minecraft.commands.CommandDispatcher.literal("until").then(net.minecraft.commands.CommandDispatcher.argument("advancement", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_ADVANCEMENTS).executes(var0 -> CommandAdvancement.perform((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Action.GRANT, CommandAdvancement.getAdvancements(ArgumentMinecraftKeyRegistered.getAdvancement((CommandContext<CommandListenerWrapper>)var0, "advancement"), Filter.UNTIL)))))).then(net.minecraft.commands.CommandDispatcher.literal("through").then(net.minecraft.commands.CommandDispatcher.argument("advancement", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_ADVANCEMENTS).executes(var0 -> CommandAdvancement.perform((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Action.GRANT, CommandAdvancement.getAdvancements(ArgumentMinecraftKeyRegistered.getAdvancement((CommandContext<CommandListenerWrapper>)var0, "advancement"), Filter.THROUGH)))))).then(net.minecraft.commands.CommandDispatcher.literal("everything").executes(var0 -> CommandAdvancement.perform((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Action.GRANT, ((CommandListenerWrapper)var0.getSource()).getServer().getAdvancements().getAllAdvancements())))))).then(net.minecraft.commands.CommandDispatcher.literal("revoke").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.players()).then(net.minecraft.commands.CommandDispatcher.literal("only").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("advancement", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_ADVANCEMENTS).executes(var0 -> CommandAdvancement.perform((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Action.REVOKE, CommandAdvancement.getAdvancements(ArgumentMinecraftKeyRegistered.getAdvancement((CommandContext<CommandListenerWrapper>)var0, "advancement"), Filter.ONLY)))).then(net.minecraft.commands.CommandDispatcher.argument("criterion", StringArgumentType.greedyString()).suggests((var0, var1) -> ICompletionProvider.suggest(ArgumentMinecraftKeyRegistered.getAdvancement((CommandContext<CommandListenerWrapper>)var0, "advancement").getCriteria().keySet(), var1)).executes(var0 -> CommandAdvancement.performCriterion((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Action.REVOKE, ArgumentMinecraftKeyRegistered.getAdvancement((CommandContext<CommandListenerWrapper>)var0, "advancement"), StringArgumentType.getString((CommandContext)var0, (String)"criterion"))))))).then(net.minecraft.commands.CommandDispatcher.literal("from").then(net.minecraft.commands.CommandDispatcher.argument("advancement", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_ADVANCEMENTS).executes(var0 -> CommandAdvancement.perform((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Action.REVOKE, CommandAdvancement.getAdvancements(ArgumentMinecraftKeyRegistered.getAdvancement((CommandContext<CommandListenerWrapper>)var0, "advancement"), Filter.FROM)))))).then(net.minecraft.commands.CommandDispatcher.literal("until").then(net.minecraft.commands.CommandDispatcher.argument("advancement", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_ADVANCEMENTS).executes(var0 -> CommandAdvancement.perform((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Action.REVOKE, CommandAdvancement.getAdvancements(ArgumentMinecraftKeyRegistered.getAdvancement((CommandContext<CommandListenerWrapper>)var0, "advancement"), Filter.UNTIL)))))).then(net.minecraft.commands.CommandDispatcher.literal("through").then(net.minecraft.commands.CommandDispatcher.argument("advancement", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_ADVANCEMENTS).executes(var0 -> CommandAdvancement.perform((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Action.REVOKE, CommandAdvancement.getAdvancements(ArgumentMinecraftKeyRegistered.getAdvancement((CommandContext<CommandListenerWrapper>)var0, "advancement"), Filter.THROUGH)))))).then(net.minecraft.commands.CommandDispatcher.literal("everything").executes(var0 -> CommandAdvancement.perform((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "targets"), Action.REVOKE, ((CommandListenerWrapper)var0.getSource()).getServer().getAdvancements().getAllAdvancements()))))));
    }

    private static int perform(CommandListenerWrapper var0, Collection<EntityPlayer> var1, Action var2, Collection<Advancement> var3) {
        int var4 = 0;
        for (EntityPlayer var6 : var1) {
            var4 += var2.perform(var6, var3);
        }
        if (var4 == 0) {
            if (var3.size() == 1) {
                if (var1.size() == 1) {
                    throw new CommandException(IChatBaseComponent.translatable(var2.getKey() + ".one.to.one.failure", var3.iterator().next().getChatComponent(), var1.iterator().next().getDisplayName()));
                }
                throw new CommandException(IChatBaseComponent.translatable(var2.getKey() + ".one.to.many.failure", var3.iterator().next().getChatComponent(), var1.size()));
            }
            if (var1.size() == 1) {
                throw new CommandException(IChatBaseComponent.translatable(var2.getKey() + ".many.to.one.failure", var3.size(), var1.iterator().next().getDisplayName()));
            }
            throw new CommandException(IChatBaseComponent.translatable(var2.getKey() + ".many.to.many.failure", var3.size(), var1.size()));
        }
        if (var3.size() == 1) {
            if (var1.size() == 1) {
                var0.sendSuccess(IChatBaseComponent.translatable(var2.getKey() + ".one.to.one.success", var3.iterator().next().getChatComponent(), var1.iterator().next().getDisplayName()), true);
            } else {
                var0.sendSuccess(IChatBaseComponent.translatable(var2.getKey() + ".one.to.many.success", var3.iterator().next().getChatComponent(), var1.size()), true);
            }
        } else if (var1.size() == 1) {
            var0.sendSuccess(IChatBaseComponent.translatable(var2.getKey() + ".many.to.one.success", var3.size(), var1.iterator().next().getDisplayName()), true);
        } else {
            var0.sendSuccess(IChatBaseComponent.translatable(var2.getKey() + ".many.to.many.success", var3.size(), var1.size()), true);
        }
        return var4;
    }

    private static int performCriterion(CommandListenerWrapper var0, Collection<EntityPlayer> var1, Action var2, Advancement var3, String var4) {
        int var5 = 0;
        if (!var3.getCriteria().containsKey(var4)) {
            throw new CommandException(IChatBaseComponent.translatable("commands.advancement.criterionNotFound", var3.getChatComponent(), var4));
        }
        for (EntityPlayer var7 : var1) {
            if (!var2.performCriterion(var7, var3, var4)) continue;
            ++var5;
        }
        if (var5 == 0) {
            if (var1.size() == 1) {
                throw new CommandException(IChatBaseComponent.translatable(var2.getKey() + ".criterion.to.one.failure", var4, var3.getChatComponent(), var1.iterator().next().getDisplayName()));
            }
            throw new CommandException(IChatBaseComponent.translatable(var2.getKey() + ".criterion.to.many.failure", var4, var3.getChatComponent(), var1.size()));
        }
        if (var1.size() == 1) {
            var0.sendSuccess(IChatBaseComponent.translatable(var2.getKey() + ".criterion.to.one.success", var4, var3.getChatComponent(), var1.iterator().next().getDisplayName()), true);
        } else {
            var0.sendSuccess(IChatBaseComponent.translatable(var2.getKey() + ".criterion.to.many.success", var4, var3.getChatComponent(), var1.size()), true);
        }
        return var5;
    }

    private static List<Advancement> getAdvancements(Advancement var0, Filter var1) {
        ArrayList var2 = Lists.newArrayList();
        if (var1.parents) {
            for (Advancement var3 = var0.getParent(); var3 != null; var3 = var3.getParent()) {
                var2.add(var3);
            }
        }
        var2.add(var0);
        if (var1.children) {
            CommandAdvancement.addChildren(var0, var2);
        }
        return var2;
    }

    private static void addChildren(Advancement var0, List<Advancement> var1) {
        for (Advancement var3 : var0.getChildren()) {
            var1.add(var3);
            CommandAdvancement.addChildren(var3, var1);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static abstract class Action
    extends Enum<Action> {
        public static final /* enum */ Action GRANT = new Action("grant"){

            @Override
            protected boolean perform(EntityPlayer var0, Advancement var1) {
                AdvancementProgress var2 = var0.getAdvancements().getOrStartProgress(var1);
                if (var2.isDone()) {
                    return false;
                }
                for (String var4 : var2.getRemainingCriteria()) {
                    var0.getAdvancements().award(var1, var4);
                }
                return true;
            }

            @Override
            protected boolean performCriterion(EntityPlayer var0, Advancement var1, String var2) {
                return var0.getAdvancements().award(var1, var2);
            }
        };
        public static final /* enum */ Action REVOKE = new Action("revoke"){

            @Override
            protected boolean perform(EntityPlayer var0, Advancement var1) {
                AdvancementProgress var2 = var0.getAdvancements().getOrStartProgress(var1);
                if (!var2.hasProgress()) {
                    return false;
                }
                for (String var4 : var2.getCompletedCriteria()) {
                    var0.getAdvancements().revoke(var1, var4);
                }
                return true;
            }

            @Override
            protected boolean performCriterion(EntityPlayer var0, Advancement var1, String var2) {
                return var0.getAdvancements().revoke(var1, var2);
            }
        };
        private final String key;
        private static final /* synthetic */ Action[] d;

        public static Action[] values() {
            return (Action[])d.clone();
        }

        public static Action valueOf(String var0) {
            return Enum.valueOf(Action.class, var0);
        }

        Action(String var2) {
            this.key = "commands.advancement." + var2;
        }

        public int perform(EntityPlayer var0, Iterable<Advancement> var1) {
            int var2 = 0;
            for (Advancement var4 : var1) {
                if (!this.perform(var0, var4)) continue;
                ++var2;
            }
            return var2;
        }

        protected abstract boolean perform(EntityPlayer var1, Advancement var2);

        protected abstract boolean performCriterion(EntityPlayer var1, Advancement var2, String var3);

        protected String getKey() {
            return this.key;
        }

        private static /* synthetic */ Action[] b() {
            return new Action[]{GRANT, REVOKE};
        }

        static {
            d = Action.b();
        }
    }

    static final class Filter
    extends Enum<Filter> {
        public static final /* enum */ Filter ONLY = new Filter(false, false);
        public static final /* enum */ Filter THROUGH = new Filter(true, true);
        public static final /* enum */ Filter FROM = new Filter(false, true);
        public static final /* enum */ Filter UNTIL = new Filter(true, false);
        public static final /* enum */ Filter EVERYTHING = new Filter(true, true);
        final boolean parents;
        final boolean children;
        private static final /* synthetic */ Filter[] h;

        public static Filter[] values() {
            return (Filter[])h.clone();
        }

        public static Filter valueOf(String var0) {
            return Enum.valueOf(Filter.class, var0);
        }

        private Filter(boolean var2, boolean var3) {
            this.parents = var2;
            this.children = var3;
        }

        private static /* synthetic */ Filter[] a() {
            return new Filter[]{ONLY, THROUGH, FROM, UNTIL, EVERYTHING};
        }

        static {
            h = Filter.a();
        }
    }
}

