/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionInstance;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutAdvancements;
import net.minecraft.network.protocol.game.PacketPlayOutSelectAdvancementTab;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.GameRules;
import org.slf4j.Logger;

public class AdvancementDataPlayer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int VISIBILITY_DEPTH = 2;
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(AdvancementProgress.class, (Object)new AdvancementProgress.a()).registerTypeAdapter(MinecraftKey.class, (Object)new MinecraftKey.a()).setPrettyPrinting().create();
    private static final TypeToken<Map<MinecraftKey, AdvancementProgress>> TYPE_TOKEN = new TypeToken<Map<MinecraftKey, AdvancementProgress>>(){};
    private final DataFixer dataFixer;
    private final PlayerList playerList;
    private final File file;
    public final Map<Advancement, AdvancementProgress> advancements = Maps.newLinkedHashMap();
    private final Set<Advancement> visible = Sets.newLinkedHashSet();
    private final Set<Advancement> visibilityChanged = Sets.newLinkedHashSet();
    private final Set<Advancement> progressChanged = Sets.newLinkedHashSet();
    private EntityPlayer player;
    @Nullable
    private Advancement lastSelectedTab;
    private boolean isFirstPacket = true;

    public AdvancementDataPlayer(DataFixer var0, PlayerList var1, AdvancementDataWorld var2, File var3, EntityPlayer var4) {
        this.dataFixer = var0;
        this.playerList = var1;
        this.file = var3;
        this.player = var4;
        this.load(var2);
    }

    public void setPlayer(EntityPlayer var0) {
        this.player = var0;
    }

    public void stopListening() {
        for (CriterionTrigger<?> var1 : CriterionTriggers.all()) {
            var1.removePlayerListeners(this);
        }
    }

    public void reload(AdvancementDataWorld var0) {
        this.stopListening();
        this.advancements.clear();
        this.visible.clear();
        this.visibilityChanged.clear();
        this.progressChanged.clear();
        this.isFirstPacket = true;
        this.lastSelectedTab = null;
        this.load(var0);
    }

    private void registerListeners(AdvancementDataWorld var0) {
        for (Advancement var2 : var0.getAllAdvancements()) {
            this.registerListeners(var2);
        }
    }

    private void ensureAllVisible() {
        ArrayList var0 = Lists.newArrayList();
        for (Map.Entry<Advancement, AdvancementProgress> var2 : this.advancements.entrySet()) {
            if (!var2.getValue().isDone()) continue;
            var0.add((Advancement)var2.getKey());
            this.progressChanged.add((Advancement)var2.getKey());
        }
        for (Map.Entry<Advancement, AdvancementProgress> var2 : var0) {
            this.ensureVisibility((Advancement)((Object)var2));
        }
    }

    private void checkForAutomaticTriggers(AdvancementDataWorld var0) {
        for (Advancement var2 : var0.getAllAdvancements()) {
            if (!var2.getCriteria().isEmpty()) continue;
            this.award(var2, "");
            var2.getRewards().grant(this.player);
        }
    }

    private void load(AdvancementDataWorld var0) {
        if (this.file.isFile()) {
            try (JsonReader var1 = new JsonReader((Reader)new StringReader(Files.toString((File)this.file, (Charset)StandardCharsets.UTF_8)));){
                var1.setLenient(false);
                Dynamic var2 = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)Streams.parse((JsonReader)var1));
                if (!var2.get("DataVersion").asNumber().result().isPresent()) {
                    var2 = var2.set("DataVersion", var2.createInt(1343));
                }
                var2 = this.dataFixer.update(DataFixTypes.ADVANCEMENTS.getType(), var2, var2.get("DataVersion").asInt(0), SharedConstants.getCurrentVersion().getWorldVersion());
                var2 = var2.remove("DataVersion");
                Map var3 = (Map)GSON.getAdapter(TYPE_TOKEN).fromJsonTree((JsonElement)var2.getValue());
                if (var3 == null) {
                    throw new JsonParseException("Found null for advancements");
                }
                Stream<Map.Entry> var4 = var3.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue));
                for (Map.Entry var6 : var4.collect(Collectors.toList())) {
                    Advancement var7 = var0.getAdvancement((MinecraftKey)var6.getKey());
                    if (var7 == null) {
                        LOGGER.warn("Ignored advancement '{}' in progress file {} - it doesn't exist anymore?", var6.getKey(), (Object)this.file);
                        continue;
                    }
                    this.startProgress(var7, (AdvancementProgress)var6.getValue());
                }
            }
            catch (JsonParseException var12) {
                LOGGER.error("Couldn't parse player advancements in {}", (Object)this.file, (Object)var12);
            }
            catch (IOException var13) {
                LOGGER.error("Couldn't access player advancements in {}", (Object)this.file, (Object)var13);
            }
        }
        this.checkForAutomaticTriggers(var0);
        this.ensureAllVisible();
        this.registerListeners(var0);
    }

    public void save() {
        Object var3;
        HashMap var0 = Maps.newHashMap();
        for (Map.Entry<Advancement, AdvancementProgress> var2 : this.advancements.entrySet()) {
            var3 = var2.getValue();
            if (!((AdvancementProgress)var3).hasProgress()) continue;
            var0.put(var2.getKey().getId(), var3);
        }
        if (this.file.getParentFile() != null) {
            this.file.getParentFile().mkdirs();
        }
        JsonElement var1 = GSON.toJsonTree((Object)var0);
        var1.getAsJsonObject().addProperty("DataVersion", (Number)SharedConstants.getCurrentVersion().getWorldVersion());
        try {
            Map.Entry<Advancement, AdvancementProgress> var2;
            var2 = new FileOutputStream(this.file);
            try {
                var3 = new OutputStreamWriter((OutputStream)((Object)var2), Charsets.UTF_8.newEncoder());
                try {
                    GSON.toJson(var1, (Appendable)var3);
                }
                finally {
                    ((Writer)var3).close();
                }
            }
            finally {
                ((OutputStream)((Object)var2)).close();
            }
        }
        catch (IOException var2) {
            LOGGER.error("Couldn't save player advancements to {}", (Object)this.file, (Object)var2);
        }
    }

    public boolean award(Advancement var0, String var1) {
        boolean var2 = false;
        AdvancementProgress var3 = this.getOrStartProgress(var0);
        boolean var4 = var3.isDone();
        if (var3.grantProgress(var1)) {
            this.unregisterListeners(var0);
            this.progressChanged.add(var0);
            var2 = true;
            if (!var4 && var3.isDone()) {
                var0.getRewards().grant(this.player);
                if (var0.getDisplay() != null && var0.getDisplay().shouldAnnounceChat() && this.player.level.getGameRules().getBoolean(GameRules.RULE_ANNOUNCE_ADVANCEMENTS)) {
                    this.playerList.broadcastSystemMessage(IChatBaseComponent.translatable("chat.type.advancement." + var0.getDisplay().getFrame().getName(), this.player.getDisplayName(), var0.getChatComponent()), false);
                }
            }
        }
        if (var3.isDone()) {
            this.ensureVisibility(var0);
        }
        return var2;
    }

    public boolean revoke(Advancement var0, String var1) {
        boolean var2 = false;
        AdvancementProgress var3 = this.getOrStartProgress(var0);
        if (var3.revokeProgress(var1)) {
            this.registerListeners(var0);
            this.progressChanged.add(var0);
            var2 = true;
        }
        if (!var3.hasProgress()) {
            this.ensureVisibility(var0);
        }
        return var2;
    }

    private void registerListeners(Advancement var0) {
        AdvancementProgress var1 = this.getOrStartProgress(var0);
        if (var1.isDone()) {
            return;
        }
        for (Map.Entry<String, Criterion> var3 : var0.getCriteria().entrySet()) {
            CriterionTrigger<CriterionInstance> var6;
            CriterionInstance var5;
            CriterionProgress var4 = var1.getCriterion(var3.getKey());
            if (var4 == null || var4.isDone() || (var5 = var3.getValue().getTrigger()) == null || (var6 = CriterionTriggers.getCriterion(var5.getCriterion())) == null) continue;
            var6.addPlayerListener(this, new CriterionTrigger.a<CriterionInstance>(var5, var0, var3.getKey()));
        }
    }

    private void unregisterListeners(Advancement var0) {
        AdvancementProgress var1 = this.getOrStartProgress(var0);
        for (Map.Entry<String, Criterion> var3 : var0.getCriteria().entrySet()) {
            CriterionTrigger<CriterionInstance> var6;
            CriterionInstance var5;
            CriterionProgress var4 = var1.getCriterion(var3.getKey());
            if (var4 == null || !var4.isDone() && !var1.isDone() || (var5 = var3.getValue().getTrigger()) == null || (var6 = CriterionTriggers.getCriterion(var5.getCriterion())) == null) continue;
            var6.removePlayerListener(this, new CriterionTrigger.a<CriterionInstance>(var5, var0, var3.getKey()));
        }
    }

    public void flushDirty(EntityPlayer var0) {
        if (this.isFirstPacket || !this.visibilityChanged.isEmpty() || !this.progressChanged.isEmpty()) {
            HashMap var1 = Maps.newHashMap();
            LinkedHashSet var2 = Sets.newLinkedHashSet();
            LinkedHashSet var3 = Sets.newLinkedHashSet();
            for (Advancement var5 : this.progressChanged) {
                if (!this.visible.contains(var5)) continue;
                var1.put(var5.getId(), this.advancements.get(var5));
            }
            for (Advancement var5 : this.visibilityChanged) {
                if (this.visible.contains(var5)) {
                    var2.add(var5);
                    continue;
                }
                var3.add(var5.getId());
            }
            if (this.isFirstPacket || !var1.isEmpty() || !var2.isEmpty() || !var3.isEmpty()) {
                var0.connection.send(new PacketPlayOutAdvancements(this.isFirstPacket, var2, var3, var1));
                this.visibilityChanged.clear();
                this.progressChanged.clear();
            }
        }
        this.isFirstPacket = false;
    }

    public void setSelectedTab(@Nullable Advancement var0) {
        Advancement var1 = this.lastSelectedTab;
        this.lastSelectedTab = var0 != null && var0.getParent() == null && var0.getDisplay() != null ? var0 : null;
        if (var1 != this.lastSelectedTab) {
            this.player.connection.send(new PacketPlayOutSelectAdvancementTab(this.lastSelectedTab == null ? null : this.lastSelectedTab.getId()));
        }
    }

    public AdvancementProgress getOrStartProgress(Advancement var0) {
        AdvancementProgress var1 = this.advancements.get(var0);
        if (var1 == null) {
            var1 = new AdvancementProgress();
            this.startProgress(var0, var1);
        }
        return var1;
    }

    private void startProgress(Advancement var0, AdvancementProgress var1) {
        var1.update(var0.getCriteria(), var0.getRequirements());
        this.advancements.put(var0, var1);
    }

    private void ensureVisibility(Advancement var0) {
        boolean var1 = this.shouldBeVisible(var0);
        boolean var2 = this.visible.contains(var0);
        if (var1 && !var2) {
            this.visible.add(var0);
            this.visibilityChanged.add(var0);
            if (this.advancements.containsKey(var0)) {
                this.progressChanged.add(var0);
            }
        } else if (!var1 && var2) {
            this.visible.remove(var0);
            this.visibilityChanged.add(var0);
        }
        if (var1 != var2 && var0.getParent() != null) {
            this.ensureVisibility(var0.getParent());
        }
        for (Advancement var4 : var0.getChildren()) {
            this.ensureVisibility(var4);
        }
    }

    private boolean shouldBeVisible(Advancement var0) {
        for (int var1 = 0; var0 != null && var1 <= 2; var0 = var0.getParent(), ++var1) {
            if (var1 == 0 && this.hasCompletedChildrenOrSelf(var0)) {
                return true;
            }
            if (var0.getDisplay() == null) {
                return false;
            }
            AdvancementProgress var2 = this.getOrStartProgress(var0);
            if (var2.isDone()) {
                return true;
            }
            if (!var0.getDisplay().isHidden()) continue;
            return false;
        }
        return false;
    }

    private boolean hasCompletedChildrenOrSelf(Advancement var0) {
        AdvancementProgress var1 = this.getOrStartProgress(var0);
        if (var1.isDone()) {
            return true;
        }
        for (Advancement var3 : var0.getChildren()) {
            if (!this.hasCompletedChildrenOrSelf(var3)) continue;
            return true;
        }
        return false;
    }
}

