/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.resources.DynamicOpsWrapper;
import net.minecraft.resources.RegistryLoader;
import net.minecraft.resources.RegistryResourceAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.util.ExtraCodecs;

public class RegistryOps<T>
extends DynamicOpsWrapper<T> {
    private final Optional<RegistryLoader.a> loader;
    private final IRegistryCustom registryAccess;
    private final DynamicOps<JsonElement> asJson;

    public static <T> RegistryOps<T> create(DynamicOps<T> var0, IRegistryCustom var1) {
        return new RegistryOps<T>(var0, var1, Optional.empty());
    }

    public static <T> RegistryOps<T> createAndLoad(DynamicOps<T> var0, IRegistryCustom.e var1, IResourceManager var2) {
        return RegistryOps.createAndLoad(var0, var1, RegistryResourceAccess.forResourceManager(var2));
    }

    public static <T> RegistryOps<T> createAndLoad(DynamicOps<T> var0, IRegistryCustom.e var1, RegistryResourceAccess var2) {
        RegistryLoader var3 = new RegistryLoader(var2);
        RegistryOps<T> var4 = new RegistryOps<T>(var0, var1, Optional.of(var3.bind(var1)));
        IRegistryCustom.load(var1, var4.getAsJson(), var3);
        return var4;
    }

    private RegistryOps(DynamicOps<T> var0, IRegistryCustom var1, Optional<RegistryLoader.a> var2) {
        super(var0);
        this.loader = var2;
        this.registryAccess = var1;
        this.asJson = var0 == JsonOps.INSTANCE ? this : new RegistryOps<T>(JsonOps.INSTANCE, var1, var2);
    }

    public <E> Optional<? extends IRegistry<E>> registry(ResourceKey<? extends IRegistry<? extends E>> var0) {
        return this.registryAccess.registry(var0);
    }

    public Optional<RegistryLoader.a> registryLoader() {
        return this.loader;
    }

    public DynamicOps<JsonElement> getAsJson() {
        return this.asJson;
    }

    public static <E> MapCodec<IRegistry<E>> retrieveRegistry(ResourceKey<? extends IRegistry<? extends E>> var0) {
        return ExtraCodecs.retrieveContext(var1 -> {
            if (var1 instanceof RegistryOps) {
                RegistryOps var2 = (RegistryOps)var1;
                return var2.registry(var0).map(var0 -> DataResult.success((Object)var0, (Lifecycle)var0.elementsLifecycle())).orElseGet(() -> DataResult.error((String)("Unknown registry: " + var0)));
            }
            return DataResult.error((String)"Not a registry ops");
        });
    }
}

