/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.level.EnumGamemode;

public class PacketPlayOutPlayerInfo
implements Packet<PacketListenerPlayOut> {
    private final EnumPlayerInfoAction action;
    private final List<PlayerInfoData> entries;

    public PacketPlayOutPlayerInfo(EnumPlayerInfoAction var0, EntityPlayer ... var1) {
        this.action = var0;
        this.entries = Lists.newArrayListWithCapacity((int)var1.length);
        for (EntityPlayer var5 : var1) {
            this.entries.add(PacketPlayOutPlayerInfo.createPlayerUpdate(var5));
        }
    }

    public PacketPlayOutPlayerInfo(EnumPlayerInfoAction var0, Collection<EntityPlayer> var1) {
        this.action = var0;
        this.entries = Lists.newArrayListWithCapacity((int)var1.size());
        for (EntityPlayer var3 : var1) {
            this.entries.add(PacketPlayOutPlayerInfo.createPlayerUpdate(var3));
        }
    }

    public PacketPlayOutPlayerInfo(PacketDataSerializer var0) {
        this.action = var0.readEnum(EnumPlayerInfoAction.class);
        this.entries = var0.readList(this.action::read);
    }

    private static PlayerInfoData createPlayerUpdate(EntityPlayer var0) {
        ProfilePublicKey var1 = var0.getProfilePublicKey();
        ProfilePublicKey.a var2 = var1 != null ? var1.data() : null;
        return new PlayerInfoData(var0.getGameProfile(), var0.latency, var0.gameMode.getGameModeForPlayer(), var0.getTabListDisplayName(), var2);
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeEnum(this.action);
        var0.writeCollection(this.entries, this.action::write);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handlePlayerInfo(this);
    }

    public List<PlayerInfoData> getEntries() {
        return this.entries;
    }

    public EnumPlayerInfoAction getAction() {
        return this.action;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("action", (Object)this.action).add("entries", this.entries).toString();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class EnumPlayerInfoAction
    extends Enum<EnumPlayerInfoAction> {
        public static final /* enum */ EnumPlayerInfoAction ADD_PLAYER = new EnumPlayerInfoAction(){

            @Override
            protected PlayerInfoData read(PacketDataSerializer var0) {
                GameProfile var1 = var0.readGameProfile();
                EnumGamemode var2 = EnumGamemode.byId(var0.readVarInt());
                int var3 = var0.readVarInt();
                IChatBaseComponent var4 = (IChatBaseComponent)var0.readNullable(PacketDataSerializer::readComponent);
                ProfilePublicKey.a var5 = (ProfilePublicKey.a)var0.readNullable(ProfilePublicKey.a::new);
                return new PlayerInfoData(var1, var3, var2, var4, var5);
            }

            @Override
            protected void write(PacketDataSerializer var02, PlayerInfoData var12) {
                var02.writeGameProfile(var12.getProfile());
                var02.writeVarInt(var12.getGameMode().getId());
                var02.writeVarInt(var12.getLatency());
                var02.writeNullable(var12.getDisplayName(), PacketDataSerializer::writeComponent);
                var02.writeNullable(var12.getProfilePublicKey(), (var0, var1) -> var1.write((PacketDataSerializer)((Object)var0)));
            }
        };
        public static final /* enum */ EnumPlayerInfoAction UPDATE_GAME_MODE = new EnumPlayerInfoAction(){

            @Override
            protected PlayerInfoData read(PacketDataSerializer var0) {
                GameProfile var1 = new GameProfile(var0.readUUID(), null);
                EnumGamemode var2 = EnumGamemode.byId(var0.readVarInt());
                return new PlayerInfoData(var1, 0, var2, null, null);
            }

            @Override
            protected void write(PacketDataSerializer var0, PlayerInfoData var1) {
                var0.writeUUID(var1.getProfile().getId());
                var0.writeVarInt(var1.getGameMode().getId());
            }
        };
        public static final /* enum */ EnumPlayerInfoAction UPDATE_LATENCY = new EnumPlayerInfoAction(){

            @Override
            protected PlayerInfoData read(PacketDataSerializer var0) {
                GameProfile var1 = new GameProfile(var0.readUUID(), null);
                int var2 = var0.readVarInt();
                return new PlayerInfoData(var1, var2, null, null, null);
            }

            @Override
            protected void write(PacketDataSerializer var0, PlayerInfoData var1) {
                var0.writeUUID(var1.getProfile().getId());
                var0.writeVarInt(var1.getLatency());
            }
        };
        public static final /* enum */ EnumPlayerInfoAction UPDATE_DISPLAY_NAME = new EnumPlayerInfoAction(){

            @Override
            protected PlayerInfoData read(PacketDataSerializer var0) {
                GameProfile var1 = new GameProfile(var0.readUUID(), null);
                IChatBaseComponent var2 = (IChatBaseComponent)var0.readNullable(PacketDataSerializer::readComponent);
                return new PlayerInfoData(var1, 0, null, var2, null);
            }

            @Override
            protected void write(PacketDataSerializer var0, PlayerInfoData var1) {
                var0.writeUUID(var1.getProfile().getId());
                var0.writeNullable(var1.getDisplayName(), PacketDataSerializer::writeComponent);
            }
        };
        public static final /* enum */ EnumPlayerInfoAction REMOVE_PLAYER = new EnumPlayerInfoAction(){

            @Override
            protected PlayerInfoData read(PacketDataSerializer var0) {
                GameProfile var1 = new GameProfile(var0.readUUID(), null);
                return new PlayerInfoData(var1, 0, null, null, null);
            }

            @Override
            protected void write(PacketDataSerializer var0, PlayerInfoData var1) {
                var0.writeUUID(var1.getProfile().getId());
            }
        };
        private static final /* synthetic */ EnumPlayerInfoAction[] f;

        public static EnumPlayerInfoAction[] values() {
            return (EnumPlayerInfoAction[])f.clone();
        }

        public static EnumPlayerInfoAction valueOf(String var0) {
            return Enum.valueOf(EnumPlayerInfoAction.class, var0);
        }

        protected abstract PlayerInfoData read(PacketDataSerializer var1);

        protected abstract void write(PacketDataSerializer var1, PlayerInfoData var2);

        private static /* synthetic */ EnumPlayerInfoAction[] a() {
            return new EnumPlayerInfoAction[]{ADD_PLAYER, UPDATE_GAME_MODE, UPDATE_LATENCY, UPDATE_DISPLAY_NAME, REMOVE_PLAYER};
        }

        static {
            f = EnumPlayerInfoAction.a();
        }
    }

    public static class PlayerInfoData {
        private final int latency;
        private final EnumGamemode gameMode;
        private final GameProfile profile;
        @Nullable
        private final IChatBaseComponent displayName;
        @Nullable
        private final ProfilePublicKey.a profilePublicKey;

        public PlayerInfoData(GameProfile var0, int var1, @Nullable EnumGamemode var2, @Nullable IChatBaseComponent var3, @Nullable ProfilePublicKey.a var4) {
            this.profile = var0;
            this.latency = var1;
            this.gameMode = var2;
            this.displayName = var3;
            this.profilePublicKey = var4;
        }

        public GameProfile getProfile() {
            return this.profile;
        }

        public int getLatency() {
            return this.latency;
        }

        public EnumGamemode getGameMode() {
            return this.gameMode;
        }

        @Nullable
        public IChatBaseComponent getDisplayName() {
            return this.displayName;
        }

        @Nullable
        public ProfilePublicKey.a getProfilePublicKey() {
            return this.profilePublicKey;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("latency", this.latency).add("gameMode", (Object)this.gameMode).add("profile", (Object)this.profile).add("displayName", this.displayName == null ? null : IChatBaseComponent.ChatSerializer.toJson(this.displayName)).add("profilePublicKey", (Object)this.profilePublicKey).toString();
        }
    }
}

