/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;

public class ClientboundServerDataPacket
implements Packet<PacketListenerPlayOut> {
    private final Optional<IChatBaseComponent> motd;
    private final Optional<String> iconBase64;
    private final boolean previewsChat;
    private final boolean enforcesSecureChat;

    public ClientboundServerDataPacket(@Nullable IChatBaseComponent var0, @Nullable String var1, boolean var2, boolean var3) {
        this.motd = Optional.ofNullable(var0);
        this.iconBase64 = Optional.ofNullable(var1);
        this.previewsChat = var2;
        this.enforcesSecureChat = var3;
    }

    public ClientboundServerDataPacket(PacketDataSerializer var0) {
        this.motd = var0.readOptional(PacketDataSerializer::readComponent);
        this.iconBase64 = var0.readOptional(PacketDataSerializer::readUtf);
        this.previewsChat = var0.readBoolean();
        this.enforcesSecureChat = var0.readBoolean();
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeOptional(this.motd, PacketDataSerializer::writeComponent);
        var0.writeOptional(this.iconBase64, PacketDataSerializer::writeUtf);
        var0.writeBoolean(this.previewsChat);
        var0.writeBoolean(this.enforcesSecureChat);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleServerData(this);
    }

    public Optional<IChatBaseComponent> getMotd() {
        return this.motd;
    }

    public Optional<String> getIconBase64() {
        return this.iconBase64;
    }

    public boolean previewsChat() {
        return this.previewsChat;
    }

    public boolean enforcesSecureChat() {
        return this.enforcesSecureChat;
    }
}

