/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.LastSeenMessages;

public class LastSeenMessagesValidator {
    private static final int NOT_FOUND = Integer.MIN_VALUE;
    private LastSeenMessages lastSeenMessages = LastSeenMessages.EMPTY;
    private final ObjectList<LastSeenMessages.a> pendingEntries = new ObjectArrayList();

    public void addPending(LastSeenMessages.a var0) {
        this.pendingEntries.add((Object)var0);
    }

    public int pendingMessagesCount() {
        return this.pendingEntries.size();
    }

    private boolean hasDuplicateProfiles(LastSeenMessages var0) {
        HashSet<UUID> var1 = new HashSet<UUID>(var0.entries().size());
        for (LastSeenMessages.a var3 : var0.entries()) {
            if (var1.add(var3.profileId())) continue;
            return true;
        }
        return false;
    }

    private int calculateIndices(List<LastSeenMessages.a> var0, int[] var1, @Nullable LastSeenMessages.a var2) {
        int var6;
        int var5;
        Arrays.fill(var1, Integer.MIN_VALUE);
        List<LastSeenMessages.a> var3 = this.lastSeenMessages.entries();
        int var4 = var3.size();
        for (var5 = var4 - 1; var5 >= 0; --var5) {
            var6 = var0.indexOf(var3.get(var5));
            if (var6 == -1) continue;
            var1[var6] = -var5 - 1;
        }
        var5 = Integer.MIN_VALUE;
        var6 = this.pendingEntries.size();
        for (int var7 = 0; var7 < var6; ++var7) {
            LastSeenMessages.a var8 = (LastSeenMessages.a)this.pendingEntries.get(var7);
            int var9 = var0.indexOf(var8);
            if (var9 != -1) {
                var1[var9] = var7;
            }
            if (!var8.equals(var2)) continue;
            var5 = var7;
        }
        return var5;
    }

    public Set<a> validateAndUpdate(LastSeenMessages.b var0) {
        EnumSet<a> var1 = EnumSet.noneOf(a.class);
        LastSeenMessages var2 = var0.lastSeen();
        LastSeenMessages.a var3 = var0.lastReceived().orElse(null);
        List<LastSeenMessages.a> var4 = var2.entries();
        int var5 = this.lastSeenMessages.entries().size();
        int var6 = Integer.MIN_VALUE;
        int var7 = var4.size();
        if (var7 < var5) {
            var1.add(a.REMOVED_MESSAGES);
        }
        int[] var8 = new int[var7];
        int var9 = this.calculateIndices(var4, var8, var3);
        for (int var10 = var7 - 1; var10 >= 0; --var10) {
            int var11 = var8[var10];
            if (var11 != Integer.MIN_VALUE) {
                if (var11 < var6) {
                    var1.add(a.OUT_OF_ORDER);
                    continue;
                }
                var6 = var11;
                continue;
            }
            var1.add(a.UNKNOWN_MESSAGES);
        }
        if (var3 != null) {
            if (var9 == Integer.MIN_VALUE || var9 < var6) {
                var1.add(a.UNKNOWN_MESSAGES);
            } else {
                var6 = var9;
            }
        }
        if (var6 >= 0) {
            this.pendingEntries.removeElements(0, var6 + 1);
        }
        if (this.hasDuplicateProfiles(var2)) {
            var1.add(a.DUPLICATED_PROFILES);
        }
        this.lastSeenMessages = var2;
        return var1;
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a OUT_OF_ORDER = new a("messages received out of order");
        public static final /* enum */ a DUPLICATED_PROFILES = new a("multiple entries for single profile");
        public static final /* enum */ a UNKNOWN_MESSAGES = new a("unknown message");
        public static final /* enum */ a REMOVED_MESSAGES = new a("previously present messages removed from context");
        private final String message;
        private static final /* synthetic */ a[] f;

        public static a[] values() {
            return (a[])f.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(String var2) {
            this.message = var2;
        }

        public String message() {
            return this.message;
        }

        private static /* synthetic */ a[] b() {
            return new a[]{OUT_OF_ORDER, DUPLICATED_PROFILES, UNKNOWN_MESSAGES, REMOVED_MESSAGES};
        }

        static {
            f = a.b();
        }
    }
}

