/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.Message;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.BlockDataSource;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.network.chat.contents.EntityDataSource;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.StorageDataSource;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.ChatTypeAdapterFactory;
import net.minecraft.util.FormattedString;

public interface IChatBaseComponent
extends Message,
IChatFormatted {
    public ChatModifier getStyle();

    public ComponentContents getContents();

    @Override
    default public String getString() {
        return IChatFormatted.super.getString();
    }

    default public String getString(int var0) {
        StringBuilder var1 = new StringBuilder();
        this.visit(var2 -> {
            int var3 = var0 - var1.length();
            if (var3 <= 0) {
                return STOP_ITERATION;
            }
            var1.append(var2.length() <= var3 ? var2 : var2.substring(0, var3));
            return Optional.empty();
        });
        return var1.toString();
    }

    public List<IChatBaseComponent> getSiblings();

    default public IChatMutableComponent plainCopy() {
        return IChatMutableComponent.create(this.getContents());
    }

    default public IChatMutableComponent copy() {
        return new IChatMutableComponent(this.getContents(), new ArrayList<IChatBaseComponent>(this.getSiblings()), this.getStyle());
    }

    public FormattedString getVisualOrderText();

    @Override
    default public <T> Optional<T> visit(IChatFormatted.b<T> var0, ChatModifier var1) {
        ChatModifier var2 = this.getStyle().applyTo(var1);
        Optional<T> var3 = this.getContents().visit(var0, var2);
        if (var3.isPresent()) {
            return var3;
        }
        for (IChatBaseComponent var5 : this.getSiblings()) {
            Optional<T> var6 = var5.visit(var0, var2);
            if (!var6.isPresent()) continue;
            return var6;
        }
        return Optional.empty();
    }

    @Override
    default public <T> Optional<T> visit(IChatFormatted.a<T> var0) {
        Optional<T> var1 = this.getContents().visit(var0);
        if (var1.isPresent()) {
            return var1;
        }
        for (IChatBaseComponent var3 : this.getSiblings()) {
            Optional<T> var4 = var3.visit(var0);
            if (!var4.isPresent()) continue;
            return var4;
        }
        return Optional.empty();
    }

    default public List<IChatBaseComponent> toFlatList() {
        return this.toFlatList(ChatModifier.EMPTY);
    }

    default public List<IChatBaseComponent> toFlatList(ChatModifier var0) {
        ArrayList var12 = Lists.newArrayList();
        this.visit((var1, var2) -> {
            if (!var2.isEmpty()) {
                var12.add(IChatBaseComponent.literal(var2).withStyle(var1));
            }
            return Optional.empty();
        }, var0);
        return var12;
    }

    default public boolean contains(IChatBaseComponent var0) {
        List<IChatBaseComponent> var2;
        if (this.equals(var0)) {
            return true;
        }
        List<IChatBaseComponent> var1 = this.toFlatList();
        return Collections.indexOfSubList(var1, var2 = var0.toFlatList(this.getStyle())) != -1;
    }

    public static IChatBaseComponent nullToEmpty(@Nullable String var0) {
        return var0 != null ? IChatBaseComponent.literal(var0) : CommonComponents.EMPTY;
    }

    public static IChatMutableComponent literal(String var0) {
        return IChatMutableComponent.create(new LiteralContents(var0));
    }

    public static IChatMutableComponent translatable(String var0) {
        return IChatMutableComponent.create(new TranslatableContents(var0));
    }

    public static IChatMutableComponent translatable(String var0, Object ... var1) {
        return IChatMutableComponent.create(new TranslatableContents(var0, var1));
    }

    public static IChatMutableComponent empty() {
        return IChatMutableComponent.create(ComponentContents.EMPTY);
    }

    public static IChatMutableComponent keybind(String var0) {
        return IChatMutableComponent.create(new KeybindContents(var0));
    }

    public static IChatMutableComponent nbt(String var0, boolean var1, Optional<IChatBaseComponent> var2, DataSource var3) {
        return IChatMutableComponent.create(new NbtContents(var0, var1, var2, var3));
    }

    public static IChatMutableComponent score(String var0, String var1) {
        return IChatMutableComponent.create(new ScoreContents(var0, var1));
    }

    public static IChatMutableComponent selector(String var0, Optional<IChatBaseComponent> var1) {
        return IChatMutableComponent.create(new SelectorContents(var0, var1));
    }

    public static class ChatSerializer
    implements JsonDeserializer<IChatMutableComponent>,
    JsonSerializer<IChatBaseComponent> {
        private static final Gson GSON = SystemUtils.make(() -> {
            GsonBuilder var0 = new GsonBuilder();
            var0.disableHtmlEscaping();
            var0.registerTypeHierarchyAdapter(IChatBaseComponent.class, (Object)new ChatSerializer());
            var0.registerTypeHierarchyAdapter(ChatModifier.class, (Object)new ChatModifier.ChatModifierSerializer());
            var0.registerTypeAdapterFactory((TypeAdapterFactory)new ChatTypeAdapterFactory());
            return var0.create();
        });
        private static final Field JSON_READER_POS = SystemUtils.make(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field var0 = JsonReader.class.getDeclaredField("pos");
                var0.setAccessible(true);
                return var0;
            }
            catch (NoSuchFieldException var0) {
                throw new IllegalStateException("Couldn't get field 'pos' for JsonReader", var0);
            }
        });
        private static final Field JSON_READER_LINESTART = SystemUtils.make(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field var0 = JsonReader.class.getDeclaredField("lineStart");
                var0.setAccessible(true);
                return var0;
            }
            catch (NoSuchFieldException var0) {
                throw new IllegalStateException("Couldn't get field 'lineStart' for JsonReader", var0);
            }
        });

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public IChatMutableComponent deserialize(JsonElement var0, Type var1, JsonDeserializationContext var2) throws JsonParseException {
            if (var0.isJsonPrimitive()) {
                return IChatBaseComponent.literal(var0.getAsString());
            }
            if (var0.isJsonObject()) {
                IChatMutableComponent var4;
                Object var5;
                JsonObject var3 = var0.getAsJsonObject();
                if (var3.has("text")) {
                    var5 = ChatDeserializer.getAsString(var3, "text");
                    var4 = ((String)var5).isEmpty() ? IChatBaseComponent.empty() : IChatBaseComponent.literal((String)var5);
                } else if (var3.has("translate")) {
                    var5 = ChatDeserializer.getAsString(var3, "translate");
                    if (var3.has("with")) {
                        void var9_20;
                        JsonArray jsonArray = ChatDeserializer.getAsJsonArray(var3, "with");
                        Object[] var7 = new Object[jsonArray.size()];
                        boolean bl = false;
                        while (var9_20 < var7.length) {
                            var7[var9_20] = ChatSerializer.unwrapTextArgument(this.deserialize(jsonArray.get((int)var9_20), var1, var2));
                            ++var9_20;
                        }
                        var4 = IChatBaseComponent.translatable((String)var5, var7);
                    } else {
                        var4 = IChatBaseComponent.translatable((String)var5);
                    }
                } else if (var3.has("score")) {
                    var5 = ChatDeserializer.getAsJsonObject(var3, "score");
                    if (!var5.has("name") || !var5.has("objective")) throw new JsonParseException("A score component needs a least a name and an objective");
                    var4 = IChatBaseComponent.score(ChatDeserializer.getAsString((JsonObject)var5, "name"), ChatDeserializer.getAsString((JsonObject)var5, "objective"));
                } else if (var3.has("selector")) {
                    var5 = this.parseSeparator(var1, var2, var3);
                    var4 = IChatBaseComponent.selector(ChatDeserializer.getAsString(var3, "selector"), (Optional<IChatBaseComponent>)var5);
                } else if (var3.has("keybind")) {
                    var4 = IChatBaseComponent.keybind(ChatDeserializer.getAsString(var3, "keybind"));
                } else {
                    void var9_24;
                    if (!var3.has("nbt")) throw new JsonParseException("Don't know how to turn " + var0 + " into a Component");
                    var5 = ChatDeserializer.getAsString(var3, "nbt");
                    Optional<IChatBaseComponent> optional = this.parseSeparator(var1, var2, var3);
                    boolean var7 = ChatDeserializer.getAsBoolean(var3, "interpret", false);
                    if (var3.has("block")) {
                        BlockDataSource blockDataSource = new BlockDataSource(ChatDeserializer.getAsString(var3, "block"));
                    } else if (var3.has("entity")) {
                        EntityDataSource entityDataSource = new EntityDataSource(ChatDeserializer.getAsString(var3, "entity"));
                    } else {
                        if (!var3.has("storage")) throw new JsonParseException("Don't know how to turn " + var0 + " into a Component");
                        StorageDataSource storageDataSource = new StorageDataSource(new MinecraftKey(ChatDeserializer.getAsString(var3, "storage")));
                    }
                    var4 = IChatBaseComponent.nbt((String)var5, var7, optional, (DataSource)var9_24);
                }
                if (var3.has("extra")) {
                    void var7_14;
                    var5 = ChatDeserializer.getAsJsonArray(var3, "extra");
                    if (var5.size() <= 0) throw new JsonParseException("Unexpected empty array of components");
                    boolean bl = false;
                    while (var7_14 < var5.size()) {
                        var4.append(this.deserialize(var5.get((int)var7_14), var1, var2));
                        ++var7_14;
                    }
                }
                var4.setStyle((ChatModifier)var2.deserialize(var0, ChatModifier.class));
                return var4;
            }
            if (!var0.isJsonArray()) throw new JsonParseException("Don't know how to turn " + var0 + " into a Component");
            JsonArray var3 = var0.getAsJsonArray();
            IChatMutableComponent var4 = null;
            for (JsonElement jsonElement : var3) {
                IChatMutableComponent var7 = this.deserialize(jsonElement, jsonElement.getClass(), var2);
                if (var4 == null) {
                    var4 = var7;
                    continue;
                }
                var4.append(var7);
            }
            return var4;
        }

        private static Object unwrapTextArgument(Object var0) {
            ComponentContents var2;
            IChatBaseComponent var1;
            if (var0 instanceof IChatBaseComponent && (var1 = (IChatBaseComponent)var0).getStyle().isEmpty() && var1.getSiblings().isEmpty() && (var2 = var1.getContents()) instanceof LiteralContents) {
                LiteralContents var3 = (LiteralContents)var2;
                return var3.text();
            }
            return var0;
        }

        private Optional<IChatBaseComponent> parseSeparator(Type var0, JsonDeserializationContext var1, JsonObject var2) {
            if (var2.has("separator")) {
                return Optional.of(this.deserialize(var2.get("separator"), var0, var1));
            }
            return Optional.empty();
        }

        private void serializeStyle(ChatModifier var0, JsonObject var1, JsonSerializationContext var2) {
            JsonElement var3 = var2.serialize((Object)var0);
            if (var3.isJsonObject()) {
                JsonObject var4 = (JsonObject)var3;
                for (Map.Entry var6 : var4.entrySet()) {
                    var1.add((String)var6.getKey(), (JsonElement)var6.getValue());
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public JsonElement serialize(IChatBaseComponent var0, Type var1, JsonSerializationContext var2) {
            ComponentContents var4;
            JsonObject var3 = new JsonObject();
            if (!var0.getStyle().isEmpty()) {
                this.serializeStyle(var0.getStyle(), var3, var2);
            }
            if (!var0.getSiblings().isEmpty()) {
                var4 = new JsonArray();
                for (IChatBaseComponent iChatBaseComponent : var0.getSiblings()) {
                    var4.add(this.serialize(iChatBaseComponent, (Type)((Object)IChatBaseComponent.class), var2));
                }
                var3.add("extra", (JsonElement)var4);
            }
            if ((var4 = var0.getContents()) == ComponentContents.EMPTY) {
                var3.addProperty("text", "");
                return var3;
            } else if (var4 instanceof LiteralContents) {
                LiteralContents literalContents = (LiteralContents)var4;
                var3.addProperty("text", literalContents.text());
                return var3;
            } else if (var4 instanceof TranslatableContents) {
                TranslatableContents var7 = (TranslatableContents)var4;
                var3.addProperty("translate", var7.getKey());
                if (var7.getArgs().length <= 0) return var3;
                JsonArray var11 = new JsonArray();
                for (Object var15 : var7.getArgs()) {
                    if (var15 instanceof IChatBaseComponent) {
                        var11.add(this.serialize((IChatBaseComponent)var15, var15.getClass(), var2));
                        continue;
                    }
                    var11.add((JsonElement)new JsonPrimitive(String.valueOf(var15)));
                }
                var3.add("with", (JsonElement)var11);
                return var3;
            } else if (var4 instanceof ScoreContents) {
                ScoreContents var8 = (ScoreContents)var4;
                JsonObject var11 = new JsonObject();
                var11.addProperty("name", var8.getName());
                var11.addProperty("objective", var8.getObjective());
                var3.add("score", (JsonElement)var11);
                return var3;
            } else if (var4 instanceof SelectorContents) {
                SelectorContents var9 = (SelectorContents)var4;
                var3.addProperty("selector", var9.getPattern());
                this.serializeSeparator(var2, var3, var9.getSeparator());
                return var3;
            } else if (var4 instanceof KeybindContents) {
                KeybindContents var10 = (KeybindContents)var4;
                var3.addProperty("keybind", var10.getName());
                return var3;
            } else {
                if (!(var4 instanceof NbtContents)) throw new IllegalArgumentException("Don't know how to serialize " + var4 + " as a Component");
                NbtContents var5 = (NbtContents)var4;
                var3.addProperty("nbt", var5.getNbtPath());
                var3.addProperty("interpret", Boolean.valueOf(var5.isInterpreting()));
                this.serializeSeparator(var2, var3, var5.getSeparator());
                DataSource var11 = var5.getDataSource();
                if (var11 instanceof BlockDataSource) {
                    BlockDataSource var13 = (BlockDataSource)var11;
                    var3.addProperty("block", var13.posPattern());
                    return var3;
                } else if (var11 instanceof EntityDataSource) {
                    EntityDataSource var14 = (EntityDataSource)var11;
                    var3.addProperty("entity", var14.selectorPattern());
                    return var3;
                } else {
                    if (!(var11 instanceof StorageDataSource)) throw new IllegalArgumentException("Don't know how to serialize " + var4 + " as a Component");
                    StorageDataSource var12 = (StorageDataSource)var11;
                    var3.addProperty("storage", var12.id().toString());
                }
            }
            return var3;
        }

        private void serializeSeparator(JsonSerializationContext var0, JsonObject var1, Optional<IChatBaseComponent> var22) {
            var22.ifPresent(var2 -> var1.add("separator", this.serialize((IChatBaseComponent)var2, (Type)var2.getClass(), var0)));
        }

        public static String toJson(IChatBaseComponent var0) {
            return GSON.toJson((Object)var0);
        }

        public static String toStableJson(IChatBaseComponent var0) {
            return ChatDeserializer.toStableString(ChatSerializer.toJsonTree(var0));
        }

        public static JsonElement toJsonTree(IChatBaseComponent var0) {
            return GSON.toJsonTree((Object)var0);
        }

        @Nullable
        public static IChatMutableComponent fromJson(String var0) {
            return ChatDeserializer.fromJson(GSON, var0, IChatMutableComponent.class, false);
        }

        @Nullable
        public static IChatMutableComponent fromJson(JsonElement var0) {
            return (IChatMutableComponent)GSON.fromJson(var0, IChatMutableComponent.class);
        }

        @Nullable
        public static IChatMutableComponent fromJsonLenient(String var0) {
            return ChatDeserializer.fromJson(GSON, var0, IChatMutableComponent.class, true);
        }

        public static IChatMutableComponent fromJson(com.mojang.brigadier.StringReader var0) {
            try {
                JsonReader var1 = new JsonReader((Reader)new StringReader(var0.getRemaining()));
                var1.setLenient(false);
                IChatMutableComponent var2 = (IChatMutableComponent)GSON.getAdapter(IChatMutableComponent.class).read(var1);
                var0.setCursor(var0.getCursor() + ChatSerializer.getPos(var1));
                return var2;
            }
            catch (IOException | StackOverflowError var1) {
                throw new JsonParseException(var1);
            }
        }

        private static int getPos(JsonReader var0) {
            try {
                return JSON_READER_POS.getInt(var0) - JSON_READER_LINESTART.getInt(var0) + 1;
            }
            catch (IllegalAccessException var1) {
                throw new IllegalStateException("Couldn't read position of JsonReader", var1);
            }
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((IChatBaseComponent)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

