/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import java.util.BitSet;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatMessageContent;
import net.minecraft.network.chat.IChatBaseComponent;

public class FilterMask {
    public static final FilterMask FULLY_FILTERED = new FilterMask(new BitSet(0), a.FULLY_FILTERED);
    public static final FilterMask PASS_THROUGH = new FilterMask(new BitSet(0), a.PASS_THROUGH);
    private static final char HASH = '#';
    private final BitSet mask;
    private final a type;

    private FilterMask(BitSet var0, a var1) {
        this.mask = var0;
        this.type = var1;
    }

    public FilterMask(int var0) {
        this(new BitSet(var0), a.PARTIALLY_FILTERED);
    }

    public static FilterMask read(PacketDataSerializer var0) {
        a var1 = var0.readEnum(a.class);
        return switch (var1) {
            default -> throw new IncompatibleClassChangeError();
            case a.PASS_THROUGH -> PASS_THROUGH;
            case a.FULLY_FILTERED -> FULLY_FILTERED;
            case a.PARTIALLY_FILTERED -> new FilterMask(var0.readBitSet(), a.PARTIALLY_FILTERED);
        };
    }

    public static void write(PacketDataSerializer var0, FilterMask var1) {
        var0.writeEnum(var1.type);
        if (var1.type == a.PARTIALLY_FILTERED) {
            var0.writeBitSet(var1.mask);
        }
    }

    public void setFiltered(int var0) {
        this.mask.set(var0);
    }

    @Nullable
    public String apply(String var0) {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case a.FULLY_FILTERED -> null;
            case a.PASS_THROUGH -> var0;
            case a.PARTIALLY_FILTERED -> {
                char[] var1 = var0.toCharArray();
                for (int var2 = 0; var2 < var1.length && var2 < this.mask.length(); ++var2) {
                    if (!this.mask.get(var2)) continue;
                    var1[var2] = 35;
                }
                yield new String(var1);
            }
        };
    }

    @Nullable
    public IChatBaseComponent apply(ChatMessageContent var0) {
        String var1 = var0.plain();
        return SystemUtils.mapNullable(this.apply(var1), IChatBaseComponent::literal);
    }

    public boolean isEmpty() {
        return this.type == a.PASS_THROUGH;
    }

    public boolean isFullyFiltered() {
        return this.type == a.FULLY_FILTERED;
    }

    static final class a
    extends Enum<a> {
        public static final /* enum */ a PASS_THROUGH = new a();
        public static final /* enum */ a FULLY_FILTERED = new a();
        public static final /* enum */ a PARTIALLY_FILTERED = new a();
        private static final /* synthetic */ a[] d;

        public static a[] values() {
            return (a[])d.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{PASS_THROUGH, FULLY_FILTERED, PARTIALLY_FILTERED};
        }

        static {
            d = a.a();
        }
    }
}

