/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.data.RegistryGeneration;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatDecoration;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;

public record ChatMessageType(ChatDecoration chat, ChatDecoration narration) {
    public static final Codec<ChatMessageType> CODEC = RecordCodecBuilder.create((T var0) -> var0.group((App)ChatDecoration.CODEC.fieldOf("chat").forGetter(ChatMessageType::chat), (App)ChatDecoration.CODEC.fieldOf("narration").forGetter(ChatMessageType::narration)).apply((Applicative)var0, ChatMessageType::new));
    public static final ChatDecoration DEFAULT_CHAT_DECORATION = ChatDecoration.withSender("chat.type.text");
    public static final ResourceKey<ChatMessageType> CHAT = ChatMessageType.create("chat");
    public static final ResourceKey<ChatMessageType> SAY_COMMAND = ChatMessageType.create("say_command");
    public static final ResourceKey<ChatMessageType> MSG_COMMAND_INCOMING = ChatMessageType.create("msg_command_incoming");
    public static final ResourceKey<ChatMessageType> MSG_COMMAND_OUTGOING = ChatMessageType.create("msg_command_outgoing");
    public static final ResourceKey<ChatMessageType> TEAM_MSG_COMMAND_INCOMING = ChatMessageType.create("team_msg_command_incoming");
    public static final ResourceKey<ChatMessageType> TEAM_MSG_COMMAND_OUTGOING = ChatMessageType.create("team_msg_command_outgoing");
    public static final ResourceKey<ChatMessageType> EMOTE_COMMAND = ChatMessageType.create("emote_command");

    private static ResourceKey<ChatMessageType> create(String var0) {
        return ResourceKey.create(IRegistry.CHAT_TYPE_REGISTRY, new MinecraftKey(var0));
    }

    public static Holder<ChatMessageType> bootstrap(IRegistry<ChatMessageType> var0) {
        RegistryGeneration.register(var0, CHAT, new ChatMessageType(DEFAULT_CHAT_DECORATION, ChatDecoration.withSender("chat.type.text.narrate")));
        RegistryGeneration.register(var0, SAY_COMMAND, new ChatMessageType(ChatDecoration.withSender("chat.type.announcement"), ChatDecoration.withSender("chat.type.text.narrate")));
        RegistryGeneration.register(var0, MSG_COMMAND_INCOMING, new ChatMessageType(ChatDecoration.incomingDirectMessage("commands.message.display.incoming"), ChatDecoration.withSender("chat.type.text.narrate")));
        RegistryGeneration.register(var0, MSG_COMMAND_OUTGOING, new ChatMessageType(ChatDecoration.outgoingDirectMessage("commands.message.display.outgoing"), ChatDecoration.withSender("chat.type.text.narrate")));
        RegistryGeneration.register(var0, TEAM_MSG_COMMAND_INCOMING, new ChatMessageType(ChatDecoration.teamMessage("chat.type.team.text"), ChatDecoration.withSender("chat.type.text.narrate")));
        RegistryGeneration.register(var0, TEAM_MSG_COMMAND_OUTGOING, new ChatMessageType(ChatDecoration.teamMessage("chat.type.team.sent"), ChatDecoration.withSender("chat.type.text.narrate")));
        return RegistryGeneration.register(var0, EMOTE_COMMAND, new ChatMessageType(ChatDecoration.withSender("chat.type.emote"), ChatDecoration.withSender("chat.type.emote")));
    }

    public static a bind(ResourceKey<ChatMessageType> var0, Entity var1) {
        return ChatMessageType.bind(var0, var1.level.registryAccess(), var1.getDisplayName());
    }

    public static a bind(ResourceKey<ChatMessageType> var0, CommandListenerWrapper var1) {
        return ChatMessageType.bind(var0, var1.registryAccess(), var1.getDisplayName());
    }

    public static a bind(ResourceKey<ChatMessageType> var0, IRegistryCustom var1, IChatBaseComponent var2) {
        IRegistry<ChatMessageType> var3 = var1.registryOrThrow(IRegistry.CHAT_TYPE_REGISTRY);
        return var3.getOrThrow(var0).bind(var2);
    }

    public a bind(IChatBaseComponent var0) {
        return new a(this, var0);
    }

    public record a(ChatMessageType chatType, IChatBaseComponent name, @Nullable IChatBaseComponent targetName) {
        a(ChatMessageType var0, IChatBaseComponent var1) {
            this(var0, var1, null);
        }

        public IChatBaseComponent decorate(IChatBaseComponent var0) {
            return this.chatType.chat().decorate(var0, this);
        }

        public IChatBaseComponent decorateNarration(IChatBaseComponent var0) {
            return this.chatType.narration().decorate(var0, this);
        }

        public a withTargetName(IChatBaseComponent var0) {
            return new a(this.chatType, this.name, var0);
        }

        public b toNetwork(IRegistryCustom var0) {
            IRegistry<ChatMessageType> var1 = var0.registryOrThrow(IRegistry.CHAT_TYPE_REGISTRY);
            return new b(var1.getId(this.chatType), this.name, this.targetName);
        }
    }

    public record b(int chatType, IChatBaseComponent name, @Nullable IChatBaseComponent targetName) {
        public b(PacketDataSerializer var0) {
            this(var0.readVarInt(), var0.readComponent(), (IChatBaseComponent)var0.readNullable(PacketDataSerializer::readComponent));
        }

        public void write(PacketDataSerializer var0) {
            var0.writeVarInt(this.chatType);
            var0.writeComponent(this.name);
            var0.writeNullable(this.targetName, PacketDataSerializer::writeComponent);
        }

        public Optional<a> resolve(IRegistryCustom var02) {
            IRegistry<ChatMessageType> var1 = var02.registryOrThrow(IRegistry.CHAT_TYPE_REGISTRY);
            ChatMessageType var2 = (ChatMessageType)var1.byId(this.chatType);
            return Optional.ofNullable(var2).map(var0 -> new a((ChatMessageType)var0, this.name, this.targetName));
        }
    }
}

