/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import java.util.Objects;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;

public record ChatMessageContent(String plain, IChatBaseComponent decorated) {
    public ChatMessageContent(String var0) {
        this(var0, IChatBaseComponent.literal(var0));
    }

    public boolean isDecorated() {
        return !this.decorated.equals(IChatBaseComponent.literal(this.plain));
    }

    public static ChatMessageContent read(PacketDataSerializer var0) {
        String var1 = var0.readUtf(256);
        IChatBaseComponent var2 = (IChatBaseComponent)var0.readNullable(PacketDataSerializer::readComponent);
        return new ChatMessageContent(var1, Objects.requireNonNullElse(var2, IChatBaseComponent.literal(var1)));
    }

    public static void write(PacketDataSerializer var0, ChatMessageContent var1) {
        var0.writeUtf(var1.plain(), 256);
        IChatBaseComponent var2 = var1.isDecorated() ? var1.decorated() : null;
        var0.writeNullable(var2, PacketDataSerializer::writeComponent);
    }
}

