/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public class ChatClickable {
    private final EnumClickAction action;
    private final String value;

    public ChatClickable(EnumClickAction var0, String var1) {
        this.action = var0;
        this.value = var1;
    }

    public EnumClickAction getAction() {
        return this.action;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 == null || this.getClass() != var0.getClass()) {
            return false;
        }
        ChatClickable var1 = (ChatClickable)var0;
        if (this.action != var1.action) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(var1.value) : var1.value != null);
    }

    public String toString() {
        return "ClickEvent{action=" + this.action + ", value='" + this.value + "'}";
    }

    public int hashCode() {
        int var0 = this.action.hashCode();
        var0 = 31 * var0 + (this.value != null ? this.value.hashCode() : 0);
        return var0;
    }

    public static final class EnumClickAction
    extends Enum<EnumClickAction> {
        public static final /* enum */ EnumClickAction OPEN_URL = new EnumClickAction("open_url", true);
        public static final /* enum */ EnumClickAction OPEN_FILE = new EnumClickAction("open_file", false);
        public static final /* enum */ EnumClickAction RUN_COMMAND = new EnumClickAction("run_command", true);
        public static final /* enum */ EnumClickAction SUGGEST_COMMAND = new EnumClickAction("suggest_command", true);
        public static final /* enum */ EnumClickAction CHANGE_PAGE = new EnumClickAction("change_page", true);
        public static final /* enum */ EnumClickAction COPY_TO_CLIPBOARD = new EnumClickAction("copy_to_clipboard", true);
        private static final Map<String, EnumClickAction> LOOKUP;
        private final boolean allowFromServer;
        private final String name;
        private static final /* synthetic */ EnumClickAction[] j;

        public static EnumClickAction[] values() {
            return (EnumClickAction[])j.clone();
        }

        public static EnumClickAction valueOf(String var0) {
            return Enum.valueOf(EnumClickAction.class, var0);
        }

        private EnumClickAction(String var2, boolean var3) {
            this.name = var2;
            this.allowFromServer = var3;
        }

        public boolean isAllowedFromServer() {
            return this.allowFromServer;
        }

        public String getName() {
            return this.name;
        }

        public static EnumClickAction getByName(String var0) {
            return LOOKUP.get(var0);
        }

        private static /* synthetic */ EnumClickAction[] c() {
            return new EnumClickAction[]{OPEN_URL, OPEN_FILE, RUN_COMMAND, SUGGEST_COMMAND, CHANGE_PAGE, COPY_TO_CLIPBOARD};
        }

        static {
            j = EnumClickAction.c();
            LOOKUP = Arrays.stream(EnumClickAction.values()).collect(Collectors.toMap(EnumClickAction::getName, var0 -> var0));
        }
    }
}

