/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;

public class NBTTagCompound
implements NBTBase {
    public static final Codec<NBTTagCompound> CODEC = Codec.PASSTHROUGH.comapFlatMap(var0 -> {
        NBTBase var1 = (NBTBase)var0.convert((DynamicOps)DynamicOpsNBT.INSTANCE).getValue();
        if (var1 instanceof NBTTagCompound) {
            return DataResult.success((Object)((NBTTagCompound)var1));
        }
        return DataResult.error((String)("Not a compound tag: " + var1));
    }, var0 -> new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, var0));
    private static final int SELF_SIZE_IN_BITS = 384;
    private static final int MAP_ENTRY_SIZE_IN_BITS = 256;
    public static final NBTTagType<NBTTagCompound> TYPE = new NBTTagType.b<NBTTagCompound>(){

        @Override
        public NBTTagCompound load(DataInput var0, int var1, NBTReadLimiter var2) throws IOException {
            byte var4;
            var2.accountBits(384L);
            if (var1 > 512) {
                throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
            }
            HashMap var3 = Maps.newHashMap();
            while ((var4 = NBTTagCompound.readNamedTagType(var0, var2)) != 0) {
                String var5 = NBTTagCompound.readNamedTagName(var0, var2);
                var2.accountBits(224 + 16 * var5.length());
                NBTBase var6 = NBTTagCompound.readNamedTagData(NBTTagTypes.getType(var4), var5, var0, var1 + 1, var2);
                if (var3.put(var5, var6) == null) continue;
                var2.accountBits(288L);
            }
            return new NBTTagCompound(var3);
        }

        @Override
        public StreamTagVisitor.b parse(DataInput var0, StreamTagVisitor var1) throws IOException {
            byte var2;
            block13: while ((var2 = var0.readByte()) != 0) {
                NBTTagType<?> var3 = NBTTagTypes.getType(var2);
                switch (var1.visitEntry(var3)) {
                    case HALT: {
                        return StreamTagVisitor.b.HALT;
                    }
                    case BREAK: {
                        NBTTagString.skipString(var0);
                        var3.skip(var0);
                        break block13;
                    }
                    case SKIP: {
                        NBTTagString.skipString(var0);
                        var3.skip(var0);
                        continue block13;
                    }
                    default: {
                        String var4 = var0.readUTF();
                        switch (var1.visitEntry(var3, var4)) {
                            case HALT: {
                                return StreamTagVisitor.b.HALT;
                            }
                            case BREAK: {
                                var3.skip(var0);
                                break block13;
                            }
                            case SKIP: {
                                var3.skip(var0);
                                continue block13;
                            }
                        }
                        switch (var3.parse(var0, var1)) {
                            case HALT: {
                                return StreamTagVisitor.b.HALT;
                            }
                        }
                        continue block13;
                    }
                }
            }
            if (var2 != 0) {
                while ((var2 = var0.readByte()) != 0) {
                    NBTTagString.skipString(var0);
                    NBTTagTypes.getType(var2).skip(var0);
                }
            }
            return var1.visitContainerEnd();
        }

        @Override
        public void skip(DataInput var0) throws IOException {
            byte var1;
            while ((var1 = var0.readByte()) != 0) {
                NBTTagString.skipString(var0);
                NBTTagTypes.getType(var1).skip(var0);
            }
        }

        @Override
        public String getName() {
            return "COMPOUND";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Compound";
        }

        @Override
        public /* synthetic */ NBTBase load(DataInput dataInput, int n2, NBTReadLimiter nBTReadLimiter) throws IOException {
            return this.load(dataInput, n2, nBTReadLimiter);
        }
    };
    private final Map<String, NBTBase> tags;

    protected NBTTagCompound(Map<String, NBTBase> var0) {
        this.tags = var0;
    }

    public NBTTagCompound() {
        this(Maps.newHashMap());
    }

    @Override
    public void write(DataOutput var0) throws IOException {
        for (String var2 : this.tags.keySet()) {
            NBTBase var3 = this.tags.get(var2);
            NBTTagCompound.writeNamedTag(var2, var3, var0);
        }
        var0.writeByte(0);
    }

    public Set<String> getAllKeys() {
        return this.tags.keySet();
    }

    @Override
    public byte getId() {
        return 10;
    }

    public NBTTagType<NBTTagCompound> getType() {
        return TYPE;
    }

    public int size() {
        return this.tags.size();
    }

    @Nullable
    public NBTBase put(String var0, NBTBase var1) {
        return this.tags.put(var0, var1);
    }

    public void putByte(String var0, byte var1) {
        this.tags.put(var0, NBTTagByte.valueOf(var1));
    }

    public void putShort(String var0, short var1) {
        this.tags.put(var0, NBTTagShort.valueOf(var1));
    }

    public void putInt(String var0, int var1) {
        this.tags.put(var0, NBTTagInt.valueOf(var1));
    }

    public void putLong(String var0, long var1) {
        this.tags.put(var0, NBTTagLong.valueOf(var1));
    }

    public void putUUID(String var0, UUID var1) {
        this.tags.put(var0, GameProfileSerializer.createUUID(var1));
    }

    public UUID getUUID(String var0) {
        return GameProfileSerializer.loadUUID(this.get(var0));
    }

    public boolean hasUUID(String var0) {
        NBTBase var1 = this.get(var0);
        return var1 != null && var1.getType() == NBTTagIntArray.TYPE && ((NBTTagIntArray)var1).getAsIntArray().length == 4;
    }

    public void putFloat(String var0, float var1) {
        this.tags.put(var0, NBTTagFloat.valueOf(var1));
    }

    public void putDouble(String var0, double var1) {
        this.tags.put(var0, NBTTagDouble.valueOf(var1));
    }

    public void putString(String var0, String var1) {
        this.tags.put(var0, NBTTagString.valueOf(var1));
    }

    public void putByteArray(String var0, byte[] var1) {
        this.tags.put(var0, new NBTTagByteArray(var1));
    }

    public void putByteArray(String var0, List<Byte> var1) {
        this.tags.put(var0, new NBTTagByteArray(var1));
    }

    public void putIntArray(String var0, int[] var1) {
        this.tags.put(var0, new NBTTagIntArray(var1));
    }

    public void putIntArray(String var0, List<Integer> var1) {
        this.tags.put(var0, new NBTTagIntArray(var1));
    }

    public void putLongArray(String var0, long[] var1) {
        this.tags.put(var0, new NBTTagLongArray(var1));
    }

    public void putLongArray(String var0, List<Long> var1) {
        this.tags.put(var0, new NBTTagLongArray(var1));
    }

    public void putBoolean(String var0, boolean var1) {
        this.tags.put(var0, NBTTagByte.valueOf(var1));
    }

    @Nullable
    public NBTBase get(String var0) {
        return this.tags.get(var0);
    }

    public byte getTagType(String var0) {
        NBTBase var1 = this.tags.get(var0);
        if (var1 == null) {
            return 0;
        }
        return var1.getId();
    }

    public boolean contains(String var0) {
        return this.tags.containsKey(var0);
    }

    public boolean contains(String var0, int var1) {
        byte var2 = this.getTagType(var0);
        if (var2 == var1) {
            return true;
        }
        if (var1 == 99) {
            return var2 == 1 || var2 == 2 || var2 == 3 || var2 == 4 || var2 == 5 || var2 == 6;
        }
        return false;
    }

    public byte getByte(String var0) {
        try {
            if (this.contains(var0, 99)) {
                return ((NBTNumber)this.tags.get(var0)).getAsByte();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public short getShort(String var0) {
        try {
            if (this.contains(var0, 99)) {
                return ((NBTNumber)this.tags.get(var0)).getAsShort();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public int getInt(String var0) {
        try {
            if (this.contains(var0, 99)) {
                return ((NBTNumber)this.tags.get(var0)).getAsInt();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public long getLong(String var0) {
        try {
            if (this.contains(var0, 99)) {
                return ((NBTNumber)this.tags.get(var0)).getAsLong();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0L;
    }

    public float getFloat(String var0) {
        try {
            if (this.contains(var0, 99)) {
                return ((NBTNumber)this.tags.get(var0)).getAsFloat();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0f;
    }

    public double getDouble(String var0) {
        try {
            if (this.contains(var0, 99)) {
                return ((NBTNumber)this.tags.get(var0)).getAsDouble();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0;
    }

    public String getString(String var0) {
        try {
            if (this.contains(var0, 8)) {
                return this.tags.get(var0).getAsString();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return "";
    }

    public byte[] getByteArray(String var0) {
        try {
            if (this.contains(var0, 7)) {
                return ((NBTTagByteArray)this.tags.get(var0)).getAsByteArray();
            }
        }
        catch (ClassCastException var1) {
            throw new ReportedException(this.createReport(var0, NBTTagByteArray.TYPE, var1));
        }
        return new byte[0];
    }

    public int[] getIntArray(String var0) {
        try {
            if (this.contains(var0, 11)) {
                return ((NBTTagIntArray)this.tags.get(var0)).getAsIntArray();
            }
        }
        catch (ClassCastException var1) {
            throw new ReportedException(this.createReport(var0, NBTTagIntArray.TYPE, var1));
        }
        return new int[0];
    }

    public long[] getLongArray(String var0) {
        try {
            if (this.contains(var0, 12)) {
                return ((NBTTagLongArray)this.tags.get(var0)).getAsLongArray();
            }
        }
        catch (ClassCastException var1) {
            throw new ReportedException(this.createReport(var0, NBTTagLongArray.TYPE, var1));
        }
        return new long[0];
    }

    public NBTTagCompound getCompound(String var0) {
        try {
            if (this.contains(var0, 10)) {
                return (NBTTagCompound)this.tags.get(var0);
            }
        }
        catch (ClassCastException var1) {
            throw new ReportedException(this.createReport(var0, TYPE, var1));
        }
        return new NBTTagCompound();
    }

    public NBTTagList getList(String var0, int var1) {
        try {
            if (this.getTagType(var0) == 9) {
                NBTTagList var2 = (NBTTagList)this.tags.get(var0);
                if (var2.isEmpty() || var2.getElementType() == var1) {
                    return var2;
                }
                return new NBTTagList();
            }
        }
        catch (ClassCastException var2) {
            throw new ReportedException(this.createReport(var0, NBTTagList.TYPE, var2));
        }
        return new NBTTagList();
    }

    public boolean getBoolean(String var0) {
        return this.getByte(var0) != 0;
    }

    public void remove(String var0) {
        this.tags.remove(var0);
    }

    @Override
    public String toString() {
        return this.getAsString();
    }

    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    private CrashReport createReport(String var0, NBTTagType<?> var1, ClassCastException var2) {
        CrashReport var3 = CrashReport.forThrowable(var2, "Reading NBT data");
        CrashReportSystemDetails var4 = var3.addCategory("Corrupt NBT tag", 1);
        var4.setDetail("Tag type found", () -> this.tags.get(var0).getType().getName());
        var4.setDetail("Tag type expected", var1::getName);
        var4.setDetail("Tag name", var0);
        return var3;
    }

    @Override
    public NBTTagCompound copy() {
        HashMap var0 = Maps.newHashMap((Map)Maps.transformValues(this.tags, NBTBase::copy));
        return new NBTTagCompound(var0);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        return var0 instanceof NBTTagCompound && Objects.equals(this.tags, ((NBTTagCompound)var0).tags);
    }

    public int hashCode() {
        return this.tags.hashCode();
    }

    private static void writeNamedTag(String var0, NBTBase var1, DataOutput var2) throws IOException {
        var2.writeByte(var1.getId());
        if (var1.getId() == 0) {
            return;
        }
        var2.writeUTF(var0);
        var1.write(var2);
    }

    static byte readNamedTagType(DataInput var0, NBTReadLimiter var1) throws IOException {
        return var0.readByte();
    }

    static String readNamedTagName(DataInput var0, NBTReadLimiter var1) throws IOException {
        return var0.readUTF();
    }

    static NBTBase readNamedTagData(NBTTagType<?> var0, String var1, DataInput var2, int var3, NBTReadLimiter var4) {
        try {
            return var0.load(var2, var3, var4);
        }
        catch (IOException var5) {
            CrashReport var6 = CrashReport.forThrowable(var5, "Loading NBT data");
            CrashReportSystemDetails var7 = var6.addCategory("NBT Tag");
            var7.setDetail("Tag name", var1);
            var7.setDetail("Tag type", var0.getName());
            throw new ReportedException(var6);
        }
    }

    public NBTTagCompound merge(NBTTagCompound var0) {
        for (String var2 : var0.tags.keySet()) {
            NBTBase var3 = var0.tags.get(var2);
            if (var3.getId() == 10) {
                if (this.contains(var2, 10)) {
                    NBTTagCompound var4 = this.getCompound(var2);
                    var4.merge((NBTTagCompound)var3);
                    continue;
                }
                this.put(var2, var3.copy());
                continue;
            }
            this.put(var2, var3.copy());
        }
        return this;
    }

    @Override
    public void accept(TagVisitor var0) {
        var0.visitCompound(this);
    }

    protected Map<String, NBTBase> entries() {
        return Collections.unmodifiableMap(this.tags);
    }

    @Override
    public StreamTagVisitor.b accept(StreamTagVisitor var0) {
        block14: for (Map.Entry<String, NBTBase> var2 : this.tags.entrySet()) {
            NBTBase var3 = var2.getValue();
            NBTTagType<?> var4 = var3.getType();
            StreamTagVisitor.a var5 = var0.visitEntry(var4);
            switch (var5) {
                case HALT: {
                    return StreamTagVisitor.b.HALT;
                }
                case BREAK: {
                    return var0.visitContainerEnd();
                }
                case SKIP: {
                    continue block14;
                }
            }
            var5 = var0.visitEntry(var4, var2.getKey());
            switch (var5) {
                case HALT: {
                    return StreamTagVisitor.b.HALT;
                }
                case BREAK: {
                    return var0.visitContainerEnd();
                }
                case SKIP: {
                    continue block14;
                }
            }
            StreamTagVisitor.b var6 = var3.accept(var0);
            switch (var6) {
                case HALT: {
                    return StreamTagVisitor.b.HALT;
                }
                case BREAK: {
                    return var0.visitContainerEnd();
                }
            }
        }
        return var0.visitContainerEnd();
    }

    @Override
    public /* synthetic */ NBTBase copy() {
        return this.copy();
    }
}

