/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessListener;

public class GameTestHarnessCollector {
    private static final char NOT_STARTED_TEST_CHAR = ' ';
    private static final char ONGOING_TEST_CHAR = '_';
    private static final char SUCCESSFUL_TEST_CHAR = '+';
    private static final char FAILED_OPTIONAL_TEST_CHAR = 'x';
    private static final char FAILED_REQUIRED_TEST_CHAR = 'X';
    private final Collection<GameTestHarnessInfo> tests = Lists.newArrayList();
    @Nullable
    private final Collection<GameTestHarnessListener> listeners = Lists.newArrayList();

    public GameTestHarnessCollector() {
    }

    public GameTestHarnessCollector(Collection<GameTestHarnessInfo> var0) {
        this.tests.addAll(var0);
    }

    public void addTestToTrack(GameTestHarnessInfo var0) {
        this.tests.add(var0);
        this.listeners.forEach(var0::addListener);
    }

    public void addListener(GameTestHarnessListener var0) {
        this.listeners.add(var0);
        this.tests.forEach(var1 -> var1.addListener(var0));
    }

    public void addFailureListener(final Consumer<GameTestHarnessInfo> var0) {
        this.addListener(new GameTestHarnessListener(){

            @Override
            public void testStructureLoaded(GameTestHarnessInfo var02) {
            }

            @Override
            public void testPassed(GameTestHarnessInfo var02) {
            }

            @Override
            public void testFailed(GameTestHarnessInfo var02) {
                var0.accept(var02);
            }
        });
    }

    public int getFailedRequiredCount() {
        return (int)this.tests.stream().filter(GameTestHarnessInfo::hasFailed).filter(GameTestHarnessInfo::isRequired).count();
    }

    public int getFailedOptionalCount() {
        return (int)this.tests.stream().filter(GameTestHarnessInfo::hasFailed).filter(GameTestHarnessInfo::isOptional).count();
    }

    public int getDoneCount() {
        return (int)this.tests.stream().filter(GameTestHarnessInfo::isDone).count();
    }

    public boolean hasFailedRequired() {
        return this.getFailedRequiredCount() > 0;
    }

    public boolean hasFailedOptional() {
        return this.getFailedOptionalCount() > 0;
    }

    public Collection<GameTestHarnessInfo> getFailedRequired() {
        return this.tests.stream().filter(GameTestHarnessInfo::hasFailed).filter(GameTestHarnessInfo::isRequired).collect(Collectors.toList());
    }

    public Collection<GameTestHarnessInfo> getFailedOptional() {
        return this.tests.stream().filter(GameTestHarnessInfo::hasFailed).filter(GameTestHarnessInfo::isOptional).collect(Collectors.toList());
    }

    public int getTotalCount() {
        return this.tests.size();
    }

    public boolean isDone() {
        return this.getDoneCount() == this.getTotalCount();
    }

    public String getProgressBar() {
        StringBuffer var0 = new StringBuffer();
        var0.append('[');
        this.tests.forEach(var1 -> {
            if (!var1.hasStarted()) {
                var0.append(' ');
            } else if (var1.hasSucceeded()) {
                var0.append('+');
            } else if (var1.hasFailed()) {
                var0.append(var1.isRequired() ? (char)'X' : (char)'x');
            } else {
                var0.append('_');
            }
        });
        var0.append(']');
        return var0.toString();
    }

    public String toString() {
        return this.getProgressBar();
    }
}

