/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.WorldVersion;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DebugReportProvider;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;

public class HashCache {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final String HEADER_MARKER = "// ";
    private final Path rootDir;
    private final Path cacheDir;
    private final String versionId;
    private final Map<DebugReportProvider, b> existingCaches;
    private final Map<DebugReportProvider, a> cachesToWrite = new HashMap<DebugReportProvider, a>();
    private final Set<Path> cachePaths = new HashSet<Path>();
    private final int initialCount;

    private Path getProviderCachePath(DebugReportProvider var0) {
        return this.cacheDir.resolve(Hashing.sha1().hashString((CharSequence)var0.getName(), StandardCharsets.UTF_8).toString());
    }

    public HashCache(Path var0, List<DebugReportProvider> var1, WorldVersion var2) throws IOException {
        this.versionId = var2.getName();
        this.rootDir = var0;
        this.cacheDir = var0.resolve(".cache");
        Files.createDirectories(this.cacheDir, new FileAttribute[0]);
        HashMap<DebugReportProvider, b> var3 = new HashMap<DebugReportProvider, b>();
        int var4 = 0;
        for (DebugReportProvider var6 : var1) {
            Path var7 = this.getProviderCachePath(var6);
            this.cachePaths.add(var7);
            b var8 = HashCache.readCache(var0, var7);
            var3.put(var6, var8);
            var4 += var8.count();
        }
        this.existingCaches = var3;
        this.initialCount = var4;
    }

    private static b readCache(Path var0, Path var1) {
        if (Files.isReadable(var1)) {
            try {
                return b.load(var0, var1);
            }
            catch (Exception var2) {
                LOGGER.warn("Failed to parse cache {}, discarding", (Object)var1, (Object)var2);
            }
        }
        return new b("unknown");
    }

    public boolean shouldRunInThisVersion(DebugReportProvider var0) {
        b var1 = this.existingCaches.get(var0);
        return var1 == null || !var1.version.equals(this.versionId);
    }

    public CachedOutput getUpdater(DebugReportProvider var02) {
        return this.cachesToWrite.computeIfAbsent(var02, var0 -> {
            b var1 = this.existingCaches.get(var0);
            if (var1 == null) {
                throw new IllegalStateException("Provider not registered: " + var0.getName());
            }
            a var2 = new a(this.versionId, var1);
            this.existingCaches.put((DebugReportProvider)var0, var2.newCache);
            return var2;
        });
    }

    public void purgeStaleAndWrite() throws IOException {
        MutableInt var0 = new MutableInt();
        this.cachesToWrite.forEach((var1, var2) -> {
            Path var3 = this.getProviderCachePath((DebugReportProvider)var1);
            var2.newCache.save(this.rootDir, var3, DateTimeFormatter.ISO_LOCAL_DATE_TIME.format(LocalDateTime.now()) + "\t" + var1.getName());
            var0.add(var2.writes);
        });
        HashSet<Path> var12 = new HashSet<Path>();
        this.existingCaches.values().forEach(var1 -> var12.addAll(var1.data().keySet()));
        var12.add(this.rootDir.resolve("version.json"));
        MutableInt var22 = new MutableInt();
        MutableInt var32 = new MutableInt();
        try (Stream<Path> var4 = Files.walk(this.rootDir, new FileVisitOption[0]);){
            var4.forEach(var3 -> {
                if (Files.isDirectory(var3, new LinkOption[0])) {
                    return;
                }
                if (this.cachePaths.contains(var3)) {
                    return;
                }
                var22.increment();
                if (var12.contains(var3)) {
                    return;
                }
                try {
                    Files.delete(var3);
                }
                catch (IOException var4) {
                    LOGGER.warn("Failed to delete file {}", var3, (Object)var4);
                }
                var32.increment();
            });
        }
        LOGGER.info("Caching: total files: {}, old count: {}, new count: {}, removed stale: {}, written: {}", new Object[]{var22, this.initialCount, var12.size(), var32, var0});
    }

    static final class b
    extends Record {
        final String version;
        private final Map<Path, HashCode> data;

        b(String var0) {
            this(var0, new HashMap<Path, HashCode>());
        }

        private b(String var0, Map<Path, HashCode> var1) {
            this.version = var0;
            this.data = var1;
        }

        @Nullable
        public HashCode get(Path var0) {
            return this.data.get(var0);
        }

        public void put(Path var0, HashCode var1) {
            this.data.put(var0, var1);
        }

        public int count() {
            return this.data.size();
        }

        public static b load(Path var0, Path var1) throws IOException {
            try (BufferedReader var22 = Files.newBufferedReader(var1, StandardCharsets.UTF_8);){
                String var3 = var22.readLine();
                if (!var3.startsWith(HashCache.HEADER_MARKER)) {
                    throw new IllegalStateException("Missing cache file header");
                }
                String[] var4 = var3.substring(HashCache.HEADER_MARKER.length()).split("\t", 2);
                String var5 = var4[0];
                HashMap var6 = new HashMap();
                var22.lines().forEach(var2 -> {
                    int var3 = var2.indexOf(32);
                    var6.put(var0.resolve(var2.substring(var3 + 1)), HashCode.fromString((String)var2.substring(0, var3)));
                });
                b b2 = new b(var5, Map.copyOf(var6));
                return b2;
            }
        }

        public void save(Path var0, Path var1, String var2) {
            try (BufferedWriter var3 = Files.newBufferedWriter(var1, StandardCharsets.UTF_8, new OpenOption[0]);){
                var3.write(HashCache.HEADER_MARKER);
                var3.write(this.version);
                var3.write(9);
                var3.write(var2);
                var3.newLine();
                for (Map.Entry<Path, HashCode> var5 : this.data.entrySet()) {
                    var3.write(var5.getValue().toString());
                    var3.write(32);
                    var3.write(var0.relativize(var5.getKey()).toString());
                    var3.newLine();
                }
            }
            catch (IOException var32) {
                LOGGER.warn("Unable write cachefile {}: {}", (Object)var1, (Object)var32);
            }
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "version;data", "version", "data"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "version;data", "version", "data"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "version;data", "version", "data"}, this, var0);
        }

        public String version() {
            return this.version;
        }

        public Map<Path, HashCode> data() {
            return this.data;
        }
    }

    static class a
    implements CachedOutput {
        private final b oldCache;
        final b newCache;
        int writes;

        a(String var0, b var1) {
            this.oldCache = var1;
            this.newCache = new b(var0);
        }

        private boolean shouldWrite(Path var0, HashCode var1) {
            return !Objects.equals(this.oldCache.get(var0), var1) || !Files.exists(var0, new LinkOption[0]);
        }

        @Override
        public void writeIfNeeded(Path var0, byte[] var1, HashCode var2) throws IOException {
            if (this.shouldWrite(var0, var2)) {
                ++this.writes;
                Files.createDirectories(var0.getParent(), new FileAttribute[0]);
                Files.write(var0, var1, new OpenOption[0]);
            }
            this.newCache.put(var0, var2);
        }
    }
}

